/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinrdm.dev.console.application.service.task.DevFnBaseTask;
import com.irdstudio.allinrdm.dev.console.facade.FormModelApiService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelPageService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelSubformService;
import com.irdstudio.allinrdm.dev.console.facade.FormSubformItemService;
import com.irdstudio.allinrdm.dev.console.facade.FormSubformStepService;
import com.irdstudio.allinrdm.dev.console.facade.FormSubformTabService;
import com.irdstudio.allinrdm.dev.console.facade.FormSubformTreeService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateButton;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateData;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateItem;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethod;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateStep;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateTab;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateTree;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelApiDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelPageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelSubformDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormSubformItemDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormSubformStepDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormSubformTabDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormSubformTreeDTO;
import com.irdstudio.allinrdm.dev.console.types.FormType;
import com.irdstudio.allinrdm.sam.console.facade.FnValidateInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnValidateInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DevFnCombineCreateTaskImpl")
public class DevFnCombineCreateTaskImpl
extends DevFnBaseTask {
    @Autowired
    protected FormModelInfoService formModelInfoService;
    @Autowired
    protected FormModelSubformService formModelSubformService;
    @Autowired
    protected FormSubformTreeService formSubformTreeService;
    @Autowired
    protected FormSubformTabService formSubformTabService;
    @Autowired
    protected FormSubformStepService formSubformStepService;
    @Autowired
    protected FormSubformItemService formSubformItemService;
    @Autowired
    protected FormModelPageService formModelPageService;
    @Autowired
    protected FormModelApiService formModelApiService;

    @Override
    public boolean create(FnModelInfoDTO fnModelInfo, boolean reCreateFlag, Map<String, Object> params) {
        String userId = fnModelInfo.getLoginUserId();
        String subsId = fnModelInfo.getSubsId();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String fnType2 = fnModelInfo.getFnType2();
        FormModelInfoDTO formInfo = new FormModelInfoDTO();
        formInfo.setFormId(formId);
        formInfo = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formInfo);
        if (formInfo == null) {
            return false;
        }
        String formType = formInfo.getFormType();
        FormModelSubformDTO subformParam = new FormModelSubformDTO();
        subformParam.setFormId(formId);
        List subFormList = this.formModelSubformService.queryList((Object)subformParam);
        if (StringUtils.equals((CharSequence)formType, (CharSequence)FormType.Tree.getCode())) {
            return this.initTreeModel(formInfo, fnModelInfo, reCreateFlag, subFormList);
        }
        if (StringUtils.equals((CharSequence)formType, (CharSequence)FormType.Guide.getCode())) {
            return this.initGuideModel(formInfo, fnModelInfo, reCreateFlag, subFormList);
        }
        if (StringUtils.equals((CharSequence)formType, (CharSequence)FormType.Tab.getCode())) {
            return this.initTabModel(formInfo, fnModelInfo, reCreateFlag, subFormList);
        }
        if (StringUtils.equals((CharSequence)formType, (CharSequence)FormType.UnionForm.getCode())) {
            return this.initUnionFormModel(formInfo, fnModelInfo, reCreateFlag, subFormList);
        }
        return false;
    }

    @Override
    public boolean refactor(FnModelInfoDTO fnModelInfo) {
        return false;
    }

    private boolean initTreeModel(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo, boolean reCreateFlag, List<FormModelSubformDTO> subFormList) {
        String userId = fnModelInfo.getLoginUserId();
        String subsId = fnModelInfo.getSubsId();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String fnType2 = fnModelInfo.getFnType2();
        String formType = formInfo.getFormType();
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()) + "TreeAdd.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String url = String.format("/%s/api/%s/%s", fnModelInfo.getAppCode(), TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()), "addTree");
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        ArrayList<FormSubformTreeDTO> treeList = new ArrayList<FormSubformTreeDTO>();
        FormSubformTreeDTO root = new FormSubformTreeDTO();
        root.setTreeId(UUIDUtil.getUUID());
        root.setTreeCode(formInfo.getFormCode());
        root.setTreeName(formInfo.getFormName());
        root.setTreeOrder(Integer.valueOf(0));
        root.setFnId(fnId);
        root.setSubformId(formId);
        root.setFormId(formId);
        treeList.add(root);
        if (CollectionUtils.isNotEmpty(subFormList)) {
            FnType fnTypeEnum = FnType.get((String)fnType2);
            int order = 1;
            for (FormModelSubformDTO subform : subFormList) {
                FormModelPageDTO pageParam = new FormModelPageDTO();
                pageParam.setPageName(fnTypeEnum.getName() + "\u9875\u9762");
                pageParam.setFormId(subform.getSubformId());
                List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
                FormSubformTreeDTO children = new FormSubformTreeDTO();
                children.setTreeId(UUIDUtil.getUUID());
                children.setTreeCode(subform.getSubformCode());
                children.setTreeName(subform.getSubformName());
                children.setTreeOrder(Integer.valueOf(order++));
                children.setFnId(fnId);
                children.setSubformId(subform.getSubformId());
                children.setFormId(formId);
                if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
                    children.setPageId(page.getPageId());
                    children.setPageUrl(page.getPageUrl());
                    children.setPageName(page.getPageName());
                }
                children.setTreeAbvId(root.getTreeId());
                treeList.add(children);
            }
        }
        if (CollectionUtils.isNotEmpty(treeList)) {
            this.formSubformTreeService.batchInsert(treeList);
        }
        return true;
    }

    private boolean initGuideModel(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo, boolean reCreateFlag, List<FormModelSubformDTO> subFormList) {
        String userId = fnModelInfo.getLoginUserId();
        String subsId = fnModelInfo.getSubsId();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String fnType2 = fnModelInfo.getFnType2();
        String formType = formInfo.getFormType();
        String NAME = "Guide";
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()) + "Guide" + "Add.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String url = String.format("/%s/api/%s/%s", fnModelInfo.getAppCode(), TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()), "addGuide");
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        ArrayList<FormSubformStepDTO> guideList = new ArrayList<FormSubformStepDTO>();
        if (CollectionUtils.isNotEmpty(subFormList)) {
            FnType fnTypeEnum = FnType.get((String)fnType2);
            int order = 1;
            for (FormModelSubformDTO subform : subFormList) {
                FormModelPageDTO pageParam = new FormModelPageDTO();
                pageParam.setPageName(fnTypeEnum.getName() + "\u9875\u9762");
                pageParam.setFormId(subform.getSubformId());
                List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
                FormSubformStepDTO children = new FormSubformStepDTO();
                children.setStepId(UUIDUtil.getUUID());
                children.setStepCode(subform.getSubformCode());
                children.setStepName(subform.getSubformName());
                children.setStepOrder(Integer.valueOf(order++));
                children.setFnId(fnId);
                children.setSubformId(subform.getSubformId());
                children.setFormId(formId);
                if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
                    children.setPageId(page.getPageId());
                    children.setPageUrl(page.getPageUrl());
                    children.setPageName(page.getPageName());
                }
                guideList.add(children);
            }
        }
        if (CollectionUtils.isNotEmpty(guideList)) {
            this.formSubformStepService.batchInsert(guideList);
        }
        return true;
    }

    private boolean initTabModel(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo, boolean reCreateFlag, List<FormModelSubformDTO> subFormList) {
        String userId = fnModelInfo.getLoginUserId();
        String subsId = fnModelInfo.getSubsId();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String fnType2 = fnModelInfo.getFnType2();
        String formType = formInfo.getFormType();
        String NAME = "Tabs";
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()) + "Tabs" + "Add.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String url = String.format("/%s/api/%s/%s", fnModelInfo.getAppCode(), TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()), "addTabs");
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        ArrayList<FormSubformTabDTO> tabList = new ArrayList<FormSubformTabDTO>();
        if (CollectionUtils.isNotEmpty(subFormList)) {
            FnType fnTypeEnum = FnType.get((String)fnType2);
            int order = 1;
            for (FormModelSubformDTO subform : subFormList) {
                FormModelPageDTO pageParam = new FormModelPageDTO();
                pageParam.setPageName(fnTypeEnum.getName() + "\u9875\u9762");
                pageParam.setFormId(subform.getSubformId());
                List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
                FormSubformTabDTO children = new FormSubformTabDTO();
                children.setTabId(UUIDUtil.getUUID());
                children.setTabCode(subform.getSubformCode());
                children.setTabName(subform.getSubformName());
                children.setTabOrder(Integer.valueOf(order++));
                children.setFnId(fnId);
                children.setSubformId(subform.getSubformId());
                children.setFormId(formId);
                if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
                    children.setPageId(page.getPageId());
                    children.setPageUrl(page.getPageUrl());
                    children.setPageName(page.getPageName());
                }
                tabList.add(children);
            }
        }
        if (CollectionUtils.isNotEmpty(tabList)) {
            this.formSubformTabService.batchInsert(tabList);
        }
        return true;
    }

    private boolean initUnionFormModel(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo, boolean reCreateFlag, List<FormModelSubformDTO> subFormList) {
        String userId = fnModelInfo.getLoginUserId();
        String subsId = fnModelInfo.getSubsId();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String fnType2 = fnModelInfo.getFnType2();
        String formType = formInfo.getFormType();
        String NAME = "Union";
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()) + "Union" + "Add.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String url = String.format("/%s/api/%s/%s", fnModelInfo.getAppCode(), TmModelUtil.tableCodeToClassName((String)formInfo.getFormCode()), "addUnion");
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        ArrayList<FormSubformItemDTO> tabList = new ArrayList<FormSubformItemDTO>();
        if (CollectionUtils.isNotEmpty(subFormList)) {
            FnType fnTypeEnum = FnType.get((String)fnType2);
            int order = 1;
            for (FormModelSubformDTO subform : subFormList) {
                FormModelPageDTO pageParam = new FormModelPageDTO();
                pageParam.setPageName(fnTypeEnum.getName() + "\u9875\u9762");
                pageParam.setFormId(subform.getSubformId());
                List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
                FormSubformItemDTO children = new FormSubformItemDTO();
                children.setItemId(UUIDUtil.getUUID());
                children.setItemCode(subform.getSubformCode());
                children.setItemName(subform.getSubformName());
                children.setItemOrder(Integer.valueOf(order++));
                children.setFnId(fnId);
                children.setSubformId(subform.getSubformId());
                children.setFormId(formId);
                if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
                    children.setPageId(page.getPageId());
                    children.setPageUrl(page.getPageUrl());
                    children.setPageName(page.getPageName());
                }
                tabList.add(children);
            }
        }
        if (CollectionUtils.isNotEmpty(tabList)) {
            this.formSubformItemService.batchInsert(tabList);
        }
        return true;
    }

    @Override
    public boolean delete(FnModelInfoDTO fnModelInfo) {
        this.formSubformTreeService.deleteByFormId(fnModelInfo.getFormId(), fnModelInfo.getFnId());
        this.formSubformStepService.deleteByFormId(fnModelInfo.getFormId(), fnModelInfo.getFnId());
        this.formSubformTabService.deleteByFormId(fnModelInfo.getFormId(), fnModelInfo.getFnId());
        this.formSubformItemService.deleteByFormId(fnModelInfo.getFormId(), fnModelInfo.getFnId());
        return true;
    }

    @Override
    public CodeTemplateData generate(FnModelInfoDTO fnModelInfo) {
        CodeTemplateData codeTemplateData = new CodeTemplateData();
        FormModelInfoDTO formModel = new FormModelInfoDTO();
        formModel.setFormId(fnModelInfo.getFormId());
        formModel = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formModel);
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tree.getCode())) {
            return this.generateTree(formModel, fnModelInfo, codeTemplateData);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Guide.getCode())) {
            return this.generateGuide(formModel, fnModelInfo, codeTemplateData);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tab.getCode())) {
            return this.generateTab(formModel, fnModelInfo, codeTemplateData);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.UnionForm.getCode())) {
            return this.generateUnionForm(formModel, fnModelInfo, codeTemplateData);
        }
        return null;
    }

    private CodeTemplateData generateTree(FormModelInfoDTO formModel, FnModelInfoDTO fnModelInfo, CodeTemplateData codeTemplateData) {
        String formCode = formModel.getFormCode();
        String formName = formModel.getFormName();
        String appId = formModel.getAppId();
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String fnType2 = fnModelInfo.getFnType2();
        String userId = fnModelInfo.getLoginUserId();
        codeTemplateData.setTemplateFile("XXXTreeAdd.html");
        codeTemplateData.setPackageName(formModel.getFolderName());
        codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
        codeTemplateData.setClassDesc(formModel.getFormName());
        codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
        CodeTemplateMethod method = new CodeTemplateMethod();
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        List apiList = this.formModelApiService.queryListByPage((Object)formApi);
        if (CollectionUtils.isNotEmpty((Collection)apiList)) {
            formApi = (FormModelApiDTO)apiList.get(0);
            method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            if (codeTemplateData.getParamMap() == null) {
                codeTemplateData.setParamMap(new HashMap());
            }
            codeTemplateData.getParamMap().put("treeUrl", method.getRestfulUrl());
        }
        method.setMethodName("loadAddTreeNodes");
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
            method.setComment(fnModelInfo.getFnDesc());
        } else {
            method.setComment(fnModelInfo.getFnName());
        }
        FormSubformTreeDTO treeParam = new FormSubformTreeDTO();
        treeParam.setFnId(fnId);
        treeParam.setFormId(formId);
        List treeList = this.formSubformTreeService.queryList((Object)treeParam);
        if (CollectionUtils.isNotEmpty((Collection)treeList)) {
            method.setTreeList(new ArrayList(treeList.size()));
            treeList.forEach(tree -> {
                CodeTemplateTree codeTree = new CodeTemplateTree();
                BeanUtility.beanCopy((Object)tree, (Object)codeTree);
                String pagePath = this.formModelPageService.getPageBasePath(tree.getPageId());
                codeTree.setPagePath(pagePath);
                method.getTreeList().add(codeTree);
            });
        }
        codeTemplateData.setMethodList(Arrays.asList(method));
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        List pageList = this.formModelPageService.queryListByPage((Object)formPage);
        if (CollectionUtils.isNotEmpty((Collection)pageList)) {
            FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
            if (CollectionUtils.isEmpty((Collection)codeTemplateData.getButtonList())) {
                codeTemplateData.setButtonList(new ArrayList());
            }
            CodeTemplateButton btn = new CodeTemplateButton();
            BeanUtility.beanCopy((Object)page, (Object)btn);
            btn.setButtonCode("treeAdd");
            btn.setButtonIcon("Plus");
            btn.setFnType(fnType2);
            btn.setButtonName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", ""));
            codeTemplateData.getButtonList().add(btn);
        }
        return codeTemplateData;
    }

    private CodeTemplateData generateGuide(FormModelInfoDTO formModel, FnModelInfoDTO fnModelInfo, CodeTemplateData codeTemplateData) {
        String formCode = formModel.getFormCode();
        String formName = formModel.getFormName();
        String appId = formModel.getAppId();
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String fnType2 = fnModelInfo.getFnType2();
        String userId = fnModelInfo.getLoginUserId();
        String NAME = "Guide";
        codeTemplateData.setTemplateFile("XXXGuideAdd.html");
        codeTemplateData.setPackageName(formModel.getFolderName());
        codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
        codeTemplateData.setClassDesc(formModel.getFormName());
        codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
        CodeTemplateMethod method = new CodeTemplateMethod();
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        List apiList = this.formModelApiService.queryListByPage((Object)formApi);
        if (CollectionUtils.isNotEmpty((Collection)apiList)) {
            formApi = (FormModelApiDTO)apiList.get(0);
            method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            if (codeTemplateData.getParamMap() == null) {
                codeTemplateData.setParamMap(new HashMap());
            }
            codeTemplateData.getParamMap().put("guideUrl", method.getRestfulUrl());
        }
        method.setMethodName("loadAddGuideNodes");
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
            method.setComment(fnModelInfo.getFnDesc());
        } else {
            method.setComment(fnModelInfo.getFnName());
        }
        FormSubformStepDTO treeParam = new FormSubformStepDTO();
        treeParam.setFnId(fnId);
        treeParam.setFormId(formId);
        List list = this.formSubformStepService.queryList((Object)treeParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            method.setStepList(new ArrayList(list.size()));
            list.forEach(el -> {
                CodeTemplateStep item = new CodeTemplateStep();
                BeanUtility.beanCopy((Object)el, (Object)item);
                String pagePath = this.formModelPageService.getPageBasePath(item.getPageId());
                item.setPagePath(pagePath);
                method.getStepList().add(item);
            });
        }
        codeTemplateData.setMethodList(Arrays.asList(method));
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        List pageList = this.formModelPageService.queryListByPage((Object)formPage);
        if (CollectionUtils.isNotEmpty((Collection)pageList)) {
            FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
            if (CollectionUtils.isEmpty((Collection)codeTemplateData.getButtonList())) {
                codeTemplateData.setButtonList(new ArrayList());
            }
            CodeTemplateButton btn = new CodeTemplateButton();
            BeanUtility.beanCopy((Object)page, (Object)btn);
            btn.setButtonCode(StringUtils.uncapitalize((String)"Guide") + "Add");
            btn.setButtonIcon("Plus");
            btn.setFnType(fnType2);
            btn.setButtonName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", ""));
            codeTemplateData.getButtonList().add(btn);
        }
        return codeTemplateData;
    }

    private CodeTemplateData generateTab(FormModelInfoDTO formModel, FnModelInfoDTO fnModelInfo, CodeTemplateData codeTemplateData) {
        String formCode = formModel.getFormCode();
        String formName = formModel.getFormName();
        String appId = formModel.getAppId();
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String fnType2 = fnModelInfo.getFnType2();
        String userId = fnModelInfo.getLoginUserId();
        String NAME = "Tabs";
        codeTemplateData.setTemplateFile("XXXTabsAdd.html");
        codeTemplateData.setPackageName(formModel.getFolderName());
        codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
        codeTemplateData.setClassDesc(formModel.getFormName());
        codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
        CodeTemplateMethod method = new CodeTemplateMethod();
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        List apiList = this.formModelApiService.queryListByPage((Object)formApi);
        if (CollectionUtils.isNotEmpty((Collection)apiList)) {
            formApi = (FormModelApiDTO)apiList.get(0);
            method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            if (codeTemplateData.getParamMap() == null) {
                codeTemplateData.setParamMap(new HashMap());
            }
            codeTemplateData.getParamMap().put("tabUrl", method.getRestfulUrl());
        }
        method.setMethodName("loadAddTabsNodes");
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
            method.setComment(fnModelInfo.getFnDesc());
        } else {
            method.setComment(fnModelInfo.getFnName());
        }
        FormSubformTabDTO itemParam = new FormSubformTabDTO();
        itemParam.setFnId(fnId);
        itemParam.setFormId(formId);
        List list = this.formSubformTabService.queryList((Object)itemParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            method.setTabList(new ArrayList(list.size()));
            list.forEach(el -> {
                CodeTemplateTab item = new CodeTemplateTab();
                BeanUtility.beanCopy((Object)el, (Object)item);
                String pagePath = this.formModelPageService.getPageBasePath(item.getPageId());
                item.setPagePath(pagePath);
                method.getTabList().add(item);
            });
        }
        codeTemplateData.setMethodList(Arrays.asList(method));
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        List pageList = this.formModelPageService.queryListByPage((Object)formPage);
        if (CollectionUtils.isNotEmpty((Collection)pageList)) {
            FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
            if (CollectionUtils.isEmpty((Collection)codeTemplateData.getButtonList())) {
                codeTemplateData.setButtonList(new ArrayList());
            }
            CodeTemplateButton btn = new CodeTemplateButton();
            BeanUtility.beanCopy((Object)page, (Object)btn);
            btn.setButtonCode(StringUtils.uncapitalize((String)"Tabs") + "Add");
            btn.setButtonIcon("Plus");
            btn.setFnType(fnType2);
            btn.setButtonName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", ""));
            codeTemplateData.getButtonList().add(btn);
        }
        return codeTemplateData;
    }

    private CodeTemplateData generateUnionForm(FormModelInfoDTO formModel, FnModelInfoDTO fnModelInfo, CodeTemplateData codeTemplateData) {
        String formCode = formModel.getFormCode();
        String formName = formModel.getFormName();
        String appId = formModel.getAppId();
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String fnType2 = fnModelInfo.getFnType2();
        String userId = fnModelInfo.getLoginUserId();
        String NAME = "UnionForm";
        codeTemplateData.setTemplateFile("XXXUnionFormAdd.html");
        codeTemplateData.setPackageName(formModel.getFolderName());
        codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
        codeTemplateData.setClassDesc(formModel.getFormName());
        codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
        CodeTemplateMethod method = new CodeTemplateMethod();
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setFormId(formId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        List apiList = this.formModelApiService.queryListByPage((Object)formApi);
        if (CollectionUtils.isNotEmpty((Collection)apiList)) {
            formApi = (FormModelApiDTO)apiList.get(0);
            method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            if (codeTemplateData.getParamMap() == null) {
                codeTemplateData.setParamMap(new HashMap());
            }
            codeTemplateData.getParamMap().put("unionFormUrl", method.getRestfulUrl());
        }
        method.setMethodName("loadAddUnionFormNodes");
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
            method.setComment(fnModelInfo.getFnDesc());
        } else {
            method.setComment(fnModelInfo.getFnName());
        }
        FormSubformItemDTO itemParam = new FormSubformItemDTO();
        itemParam.setFnId(fnId);
        itemParam.setFormId(formId);
        List list = this.formSubformItemService.queryList((Object)itemParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            method.setItemList(new ArrayList(list.size()));
            list.forEach(el -> {
                CodeTemplateItem item = new CodeTemplateItem();
                BeanUtility.beanCopy((Object)el, (Object)item);
                method.getItemList().add(item);
            });
        }
        codeTemplateData.setMethodList(Arrays.asList(method));
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setFormId(formId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        List pageList = this.formModelPageService.queryListByPage((Object)formPage);
        if (CollectionUtils.isNotEmpty((Collection)pageList)) {
            FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
            if (CollectionUtils.isEmpty((Collection)codeTemplateData.getButtonList())) {
                codeTemplateData.setButtonList(new ArrayList());
            }
            CodeTemplateButton btn = new CodeTemplateButton();
            BeanUtility.beanCopy((Object)page, (Object)btn);
            btn.setButtonCode(StringUtils.uncapitalize((String)"UnionForm") + "Add");
            btn.setButtonIcon("Plus");
            btn.setFnType(fnType2);
            btn.setButtonName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", ""));
            codeTemplateData.getButtonList().add(btn);
        }
        return codeTemplateData;
    }

    @Override
    public List<String> validate(FnModelInfoDTO fnModelInfo) {
        FormModelInfoDTO formModel = new FormModelInfoDTO();
        formModel.setFormId(fnModelInfo.getFormId());
        formModel = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formModel);
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tree.getCode())) {
            return this.validateTree(formModel, fnModelInfo);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Guide.getCode())) {
            return this.validateGuide(formModel, fnModelInfo);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tab.getCode())) {
            return this.validateTab(formModel, fnModelInfo);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.UnionForm.getCode())) {
            return this.validateUnionForm(formModel, fnModelInfo);
        }
        return Collections.emptyList();
    }

    private List<String> validateTree(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo) {
        FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
        ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
        HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String NAME = "tree";
        List<String> validTypes = Arrays.asList("tree");
        for (String type : validTypes) {
            FnValidateInfoDTO valid = new FnValidateInfoDTO();
            valid.setRecordKeyid(UUIDUtil.getUUID());
            valid.setFnId(fnModelInfo.getFnId());
            valid.setFormId(formId);
            valid.setValidId(formId);
            valid.setCreateUser(fnModelInfo.getLoginUserId());
            valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            valid.setValidType(type);
            validList.add(valid);
            validMap.put(type, valid);
        }
        if (CollectionUtils.isNotEmpty(validList)) {
            fnValidateService.batchInsert(validList);
        }
        FormSubformTreeDTO subformParam = new FormSubformTreeDTO();
        subformParam.setFnId(fnModelInfo.getFnId());
        List list = this.formSubformTreeService.queryList((Object)subformParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Arrays.asList(FormType.nameByCode((String)formInfo.getFormType()) + "\u914d\u7f6e\u4e3a\u7a7a");
        }
        ArrayList<String> failureMessageList = new ArrayList<String>();
        FnValidateInfoDTO tree = (FnValidateInfoDTO)validMap.get("tree");
        for (FormSubformTreeDTO sub : list) {
            if (!StringUtils.isNotBlank((CharSequence)sub.getPageId()) || !CollectionUtils.isNotEmpty((Collection)sub.validate())) continue;
            tree.setValidRe(CheckResult.Fail.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
            tree.setValidMsg(FormType.nameByCode((String)formInfo.getFormType()) + "\u9875\u9762\u914d\u7f6e\u4e0d\u901a\u8fc7");
            failureMessageList.add(tree.getValidMsg());
            break;
        }
        if (StringUtils.isBlank((CharSequence)tree.getValidRe())) {
            tree.setValidRe(CheckResult.Pass.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
        }
        fnValidateService.updateByPk((Object)tree);
        return failureMessageList;
    }

    private List<String> validateGuide(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo) {
        FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
        ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
        HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String NAME = "guide";
        List<String> validTypes = Arrays.asList("guide");
        for (String type : validTypes) {
            FnValidateInfoDTO valid = new FnValidateInfoDTO();
            valid.setRecordKeyid(UUIDUtil.getUUID());
            valid.setFnId(fnModelInfo.getFnId());
            valid.setFormId(formId);
            valid.setValidId(formId);
            valid.setCreateUser(fnModelInfo.getLoginUserId());
            valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            valid.setValidType(type);
            validList.add(valid);
            validMap.put(type, valid);
        }
        if (CollectionUtils.isNotEmpty(validList)) {
            fnValidateService.batchInsert(validList);
        }
        FormSubformStepDTO subformParam = new FormSubformStepDTO();
        subformParam.setFnId(fnModelInfo.getFnId());
        List list = this.formSubformStepService.queryList((Object)subformParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Arrays.asList(FormType.nameByCode((String)formInfo.getFormType()) + "\u914d\u7f6e\u4e3a\u7a7a");
        }
        ArrayList<String> failureMessageList = new ArrayList<String>();
        FnValidateInfoDTO tree = (FnValidateInfoDTO)validMap.get("guide");
        for (FormSubformStepDTO sub : list) {
            if (!CollectionUtils.isNotEmpty((Collection)sub.validate())) continue;
            tree.setValidRe(CheckResult.Fail.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
            tree.setValidMsg(FormType.nameByCode((String)formInfo.getFormType()) + "\u9875\u9762\u914d\u7f6e\u4e0d\u901a\u8fc7");
            failureMessageList.add(tree.getValidMsg());
            break;
        }
        if (StringUtils.isBlank((CharSequence)tree.getValidRe())) {
            tree.setValidRe(CheckResult.Pass.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
        }
        fnValidateService.updateByPk((Object)tree);
        return failureMessageList;
    }

    private List<String> validateTab(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo) {
        FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
        ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
        HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String NAME = "tabs";
        List<String> validTypes = Arrays.asList("tabs");
        for (String type : validTypes) {
            FnValidateInfoDTO valid = new FnValidateInfoDTO();
            valid.setRecordKeyid(UUIDUtil.getUUID());
            valid.setFnId(fnModelInfo.getFnId());
            valid.setFormId(formId);
            valid.setValidId(formId);
            valid.setCreateUser(fnModelInfo.getLoginUserId());
            valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            valid.setValidType(type);
            validList.add(valid);
            validMap.put(type, valid);
        }
        if (CollectionUtils.isNotEmpty(validList)) {
            fnValidateService.batchInsert(validList);
        }
        FormSubformTabDTO subformParam = new FormSubformTabDTO();
        subformParam.setFnId(fnModelInfo.getFnId());
        List list = this.formSubformTabService.queryList((Object)subformParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Arrays.asList(FormType.nameByCode((String)formInfo.getFormType()) + "\u914d\u7f6e\u4e3a\u7a7a");
        }
        ArrayList<String> failureMessageList = new ArrayList<String>();
        FnValidateInfoDTO tree = (FnValidateInfoDTO)validMap.get("tabs");
        for (FormSubformTabDTO sub : list) {
            if (!CollectionUtils.isNotEmpty((Collection)sub.validate())) continue;
            tree.setValidRe(CheckResult.Fail.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
            tree.setValidMsg(FormType.nameByCode((String)formInfo.getFormType()) + "\u9875\u9762\u914d\u7f6e\u4e0d\u901a\u8fc7");
            failureMessageList.add(tree.getValidMsg());
            break;
        }
        if (StringUtils.isBlank((CharSequence)tree.getValidRe())) {
            tree.setValidRe(CheckResult.Pass.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
        }
        fnValidateService.updateByPk((Object)tree);
        return failureMessageList;
    }

    private List<String> validateUnionForm(FormModelInfoDTO formInfo, FnModelInfoDTO fnModelInfo) {
        FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
        ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
        HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
        String formId = fnModelInfo.getFormId();
        String fnId = fnModelInfo.getFnId();
        String NAME = "unionForm";
        List<String> validTypes = Arrays.asList("unionForm");
        for (String type : validTypes) {
            FnValidateInfoDTO valid = new FnValidateInfoDTO();
            valid.setRecordKeyid(UUIDUtil.getUUID());
            valid.setFnId(fnModelInfo.getFnId());
            valid.setFormId(formId);
            valid.setValidId(formId);
            valid.setCreateUser(fnModelInfo.getLoginUserId());
            valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            valid.setValidType(type);
            validList.add(valid);
            validMap.put(type, valid);
        }
        if (CollectionUtils.isNotEmpty(validList)) {
            fnValidateService.batchInsert(validList);
        }
        FormSubformItemDTO subformParam = new FormSubformItemDTO();
        subformParam.setFnId(fnModelInfo.getFnId());
        List list = this.formSubformItemService.queryList((Object)subformParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Arrays.asList(FormType.nameByCode((String)formInfo.getFormType()) + "\u914d\u7f6e\u4e3a\u7a7a");
        }
        ArrayList<String> failureMessageList = new ArrayList<String>();
        FnValidateInfoDTO tree = (FnValidateInfoDTO)validMap.get("unionForm");
        for (FormSubformItemDTO sub : list) {
            if (!CollectionUtils.isNotEmpty((Collection)sub.validate())) continue;
            tree.setValidRe(CheckResult.Fail.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
            tree.setValidMsg(FormType.nameByCode((String)formInfo.getFormType()) + "\u9875\u9762\u914d\u7f6e\u4e0d\u901a\u8fc7");
            failureMessageList.add(tree.getValidMsg());
            break;
        }
        if (StringUtils.isBlank((CharSequence)tree.getValidRe())) {
            tree.setValidRe(CheckResult.Pass.getCode());
            tree.setValidTime(CurrentDateUtil.getTodayDateEx2());
        }
        fnValidateService.updateByPk((Object)tree);
        return failureMessageList;
    }
}

