/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.RdmMenuInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.RdmMenuInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.RdmMenuInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.RdmMenuInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnTrigger;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.allintcp.sdk.bi.acl.repository.RdmModuleInfoRepository;
import com.irdstudio.allintcp.sdk.bi.domain.entity.RdmModuleInfoDO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmMenuInfoServiceImpl")
public class RdmMenuInfoServiceImpl
extends BaseServiceImpl<RdmMenuInfoDTO, RdmMenuInfoDO, RdmMenuInfoRepository>
implements RdmMenuInfoService {
    @Autowired
    private RdmModuleInfoRepository rdmModuleInfoRepository;
    @Autowired
    private SeqInstInfoService seqService;

    public int insert(RdmMenuInfoDTO paramDTO) {
        if (paramDTO.getFnOrder() == null) {
            Integer order = ((RdmMenuInfoRepository)this.getRepository()).queryMaxOrderBySubsId(paramDTO.getSubsId(), paramDTO.getFnAbvId());
            if (order == null) {
                order = 0;
            }
            paramDTO.setFnOrder(Integer.valueOf(order + 1));
        }
        String owner1 = StringUtils.isNotBlank((CharSequence)paramDTO.getSubsId()) ? paramDTO.getSubsId() : paramDTO.getProjectId();
        paramDTO.setFnId(this.seqService.nextAndSave("RDM-MENU-ID", "\u83dc\u5355\u7f16\u53f7", "00", "1", "99999", "1", "08", "0", "{{owner1}}-MNU-{{SEQ}}", "5", "Y", owner1));
        return super.insert((BaseInfo)paramDTO);
    }

    public int deleteByPk(RdmMenuInfoDTO paramDTO) {
        RdmMenuInfoDO rdmMenuInfoDO = new RdmMenuInfoDO();
        this.beanCopy(paramDTO, rdmMenuInfoDO);
        int re = super.deleteByPk((BaseInfo)paramDTO);
        return re += this.recursionDeleteChildren(rdmMenuInfoDO);
    }

    private int recursionDeleteChildren(RdmMenuInfoDO parent) {
        if (StringUtils.isBlank((CharSequence)parent.getFnId())) {
            return 0;
        }
        RdmMenuInfoDO childParam = new RdmMenuInfoDO();
        childParam.setFnAbvId(parent.getFnId());
        List childList = ((RdmMenuInfoRepository)this.getRepository()).queryList((Object)childParam);
        if (CollectionUtils.isNotEmpty((Collection)childList)) {
            childList.forEach(c -> {
                ((RdmMenuInfoRepository)this.getRepository()).deleteByPk(c);
                this.recursionDeleteChildren((RdmMenuInfoDO)c);
            });
        }
        return childList.size();
    }

    public int deleteBySubsId(String subsId) {
        int num = ((RdmMenuInfoRepository)this.getRepository()).deleteBySubsId(subsId);
        return num;
    }

    public int saveExcel(String subsId, String userId, String appId, String comId, List<RdmMenuInfoDTO> list) {
        int num = 0;
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                String now = CurrentDateUtil.getTodayDateEx2();
                HashMap<String, RdmMenuInfoDO> fnMap = new HashMap<String, RdmMenuInfoDO>();
                HashMap<String, RdmMenuInfoDO> appMap = new HashMap<String, RdmMenuInfoDO>();
                HashMap<String, RdmModuleInfoDO> moduleMap = new HashMap<String, RdmModuleInfoDO>();
                List doList = this.beansCopy(list, RdmMenuInfoDO.class);
                for (int i = 0; i < doList.size(); ++i) {
                    RdmMenuInfoDO checkObj;
                    RdmMenuInfoDO fn = (RdmMenuInfoDO)doList.get(i);
                    fnMap.put(fn.getFnName(), fn);
                    fn.setFnId(subsId + fn.getFnCode());
                    fn.setSubsId(subsId);
                    fn.setCreateUser(userId);
                    fn.setUpdateUser(userId);
                    fn.setCreateTime(now);
                    fn.setUpdateTime(now);
                    fn.setFnOrder(Integer.valueOf(i + 1));
                    fn.setFnType(FnType.codeByName((String)fn.getFnType()));
                    fn.setFnTrigger(FnTrigger.codeByName((String)fn.getFnTrigger()));
                    if (StringUtils.isNotBlank((CharSequence)fn.getModuleName())) {
                        RdmModuleInfoDO module = (RdmModuleInfoDO)moduleMap.get(fn.getModuleName());
                        if (module == null) {
                            module = new RdmModuleInfoDO();
                            module.setSubsId(subsId);
                            module.setModuleName(fn.getModuleName());
                            List moduleList = this.rdmModuleInfoRepository.queryListByPage((Object)module);
                            if (CollectionUtils.isNotEmpty((Collection)moduleList)) {
                                module = (RdmModuleInfoDO)moduleList.get(0);
                                moduleMap.put(fn.getModuleName(), module);
                            } else {
                                module.setCreateUser(userId);
                                module.setCreateTime(now);
                                module.setUpdateUser(userId);
                                module.setUpdateTime(now);
                                module.setModuleId(UUIDUtil.getShortUUID());
                                module.setModuleCode(StringUtils.substring((String)fn.getModuleName(), (int)0, (int)31));
                                module.setModuleName(StringUtils.substring((String)fn.getModuleName(), (int)0, (int)80));
                                module.setModuleDesc(fn.getModuleName());
                                this.rdmModuleInfoRepository.insert((Object)module);
                                moduleMap.put(fn.getModuleName(), module);
                            }
                        }
                        fn.setModuleId(module.getModuleId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fn.getAppCode()) || StringUtils.isNotBlank((CharSequence)fn.getAppName())) {
                        String key = "" + fn.getAppCode() + fn.getAppName();
                        RdmMenuInfoDO app = (RdmMenuInfoDO)appMap.get(key);
                        if (app != null) {
                            fn.setAppId(app.getAppId());
                        } else {
                            List appList = ((RdmMenuInfoRepository)this.getRepository()).queryPaasAppInfo(fn);
                            if (CollectionUtils.isNotEmpty((Collection)appList)) {
                                app = (RdmMenuInfoDO)appList.get(0);
                                appMap.put(key, app);
                                fn.setAppId(app.getAppId());
                            } else {
                                app = new RdmMenuInfoDO();
                                appMap.put(key, app);
                            }
                        }
                    }
                    if ((checkObj = (RdmMenuInfoDO)((RdmMenuInfoRepository)this.getRepository()).queryByPk((Object)fn)) != null) {
                        ((RdmMenuInfoRepository)this.getRepository()).updateByPk((Object)fn);
                        continue;
                    }
                    ((RdmMenuInfoRepository)this.getRepository()).insert((Object)fn);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return num;
    }

    public Integer deleteByCond(RdmMenuInfoDTO param) {
        return ((RdmMenuInfoRepository)this.getRepository()).deleteByCond((RdmMenuInfoDO)this.beanCopy(param, RdmMenuInfoDO.class));
    }

    public String queryCodeWithPrefix(String subsId, String fnType2) {
        return ((RdmMenuInfoRepository)this.getRepository()).queryCodeWithPrefix(subsId, fnType2);
    }
}

