/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.web.controller.api;

import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyIssueService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyIssueDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmWeeklyIssueController
extends BaseController<RdmWeeklyIssueDTO, RdmWeeklyIssueService> {
    @RequestMapping(value={"/api/rdm/weekly/issues"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWeeklyIssueDTO>> queryRdmWeeklyIssueAll(RdmWeeklyIssueDTO dto) {
        List outputVo = ((RdmWeeklyIssueService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/issue/{weeklyIssueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWeeklyIssueDTO> queryByPk(@PathVariable(value="weeklyIssueId") String weeklyIssueId) {
        RdmWeeklyIssueDTO inVo = new RdmWeeklyIssueDTO();
        inVo.setWeeklyIssueId(weeklyIssueId);
        RdmWeeklyIssueDTO outputVo = (RdmWeeklyIssueDTO)((RdmWeeklyIssueService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/issue"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmWeeklyIssueDTO inRdmWeeklyIssueDTO) {
        int outputVo = ((RdmWeeklyIssueService)this.getService()).deleteByPk((Object)inRdmWeeklyIssueDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/issue"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmWeeklyIssueDTO inRdmWeeklyIssueDTO) {
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyIssueDTO);
        inRdmWeeklyIssueDTO.setLastUpdateUser(userInfo.getUserId());
        inRdmWeeklyIssueDTO.setLastUpdateTime(now);
        int outputVo = ((RdmWeeklyIssueService)this.getService()).updateByPk((Object)inRdmWeeklyIssueDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/issue"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWeeklyIssue(@RequestBody RdmWeeklyIssueDTO inRdmWeeklyIssueDTO) {
        if (StringUtils.isBlank((CharSequence)inRdmWeeklyIssueDTO.getWeeklyIssueId())) {
            inRdmWeeklyIssueDTO.setWeeklyIssueId(UUIDUtil.getShortUUID());
        }
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyIssueDTO);
        inRdmWeeklyIssueDTO.setCreateUser(userInfo.getUserId());
        inRdmWeeklyIssueDTO.setCreateUserName(userInfo.getUserName());
        inRdmWeeklyIssueDTO.setCreateTime(now);
        inRdmWeeklyIssueDTO.setLastUpdateUser(userInfo.getUserId());
        inRdmWeeklyIssueDTO.setLastUpdateTime(now);
        int outputVo = ((RdmWeeklyIssueService)this.getService()).insert((Object)inRdmWeeklyIssueDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/issue/auto"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> autoFillWeekIssue(@RequestBody RdmWeeklyIssueDTO inRdmWeeklyIssueDTO) {
        int outputVO = ((RdmWeeklyIssueService)this.getService()).autoFillWeekIssue(inRdmWeeklyIssueDTO);
        return this.getResponseData(outputVO);
    }

    @RequestMapping(value={"/client/RdmWeeklyIssueService/deleteByCond"}, method={RequestMethod.POST})
    public int deleteByCond(@RequestBody RdmWeeklyIssueDTO param) {
        return ((RdmWeeklyIssueService)this.getService()).deleteByCond(param);
    }
}

