/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.web.controller.api;

import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyTaskService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyTaskDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmWeeklyTaskController
extends BaseController<RdmWeeklyTaskDTO, RdmWeeklyTaskService> {
    @RequestMapping(value={"/api/rdm/weekly/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWeeklyTaskDTO>> queryRdmWeeklyTaskAll(RdmWeeklyTaskDTO dto) {
        List outputVo = ((RdmWeeklyTaskService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/task/{weeklyTaskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWeeklyTaskDTO> queryByPk(@PathVariable(value="weeklyTaskId") String weeklyTaskId) {
        RdmWeeklyTaskDTO inVo = new RdmWeeklyTaskDTO();
        inVo.setWeeklyTaskId(weeklyTaskId);
        RdmWeeklyTaskDTO outputVo = (RdmWeeklyTaskDTO)((RdmWeeklyTaskService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/task"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmWeeklyTaskDTO inRdmWeeklyTaskDTO) {
        int outputVo = ((RdmWeeklyTaskService)this.getService()).deleteByPk((Object)inRdmWeeklyTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/task"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmWeeklyTaskDTO inRdmWeeklyTaskDTO) {
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyTaskDTO);
        inRdmWeeklyTaskDTO.setLastModifyUser(userInfo.getUserId());
        inRdmWeeklyTaskDTO.setLastModifyTime(now);
        int outputVo = ((RdmWeeklyTaskService)this.getService()).updateByPk((Object)inRdmWeeklyTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/task"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWeeklyTask(@RequestBody RdmWeeklyTaskDTO inRdmWeeklyTaskDTO) {
        if (StringUtils.isBlank((CharSequence)inRdmWeeklyTaskDTO.getWeeklyTaskId())) {
            inRdmWeeklyTaskDTO.setWeeklyTaskId(UUIDUtil.getShortUUID());
        }
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyTaskDTO);
        inRdmWeeklyTaskDTO.setCreateUser(userInfo.getUserId());
        inRdmWeeklyTaskDTO.setCreateUserName(userInfo.getUserName());
        inRdmWeeklyTaskDTO.setCreateTime(now);
        inRdmWeeklyTaskDTO.setLastModifyUser(userInfo.getUserId());
        inRdmWeeklyTaskDTO.setLastModifyTime(now);
        int outputVo = ((RdmWeeklyTaskService)this.getService()).insert((Object)inRdmWeeklyTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/task/auto"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> autoFillWeekTask(@RequestBody RdmWeeklyTaskDTO inRdmWeeklyTaskDTO) {
        int outputVO = ((RdmWeeklyTaskService)this.getService()).autoFillWeekTask(inRdmWeeklyTaskDTO);
        return this.getResponseData(outputVO);
    }

    @RequestMapping(value={"/client/RdmWeeklyTaskService/deleteByCond"}, method={RequestMethod.POST})
    public int deleteByCond(@RequestBody RdmWeeklyTaskDTO param) {
        return ((RdmWeeklyTaskService)this.getService()).deleteByCond(param);
    }
}

