/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.DamTemplateInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DamTemplateInfoDTO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class DamTemplateInfoController
extends BaseController<DamTemplateInfoDTO, DamTemplateInfoService> {
    @Value(value="${tdp.metatask.path:/var/tmp/metatask/}")
    private String tmpDir;

    @RequestMapping(value={"/api/dam/template/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DamTemplateInfoDTO>> queryDamTemplateInfoAll(DamTemplateInfoDTO dto) {
        List outputVo = ((DamTemplateInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dam/template/info/{damTemplateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DamTemplateInfoDTO> queryByPk(@PathVariable(value="damTemplateId") String damTemplateId) {
        DamTemplateInfoDTO inVo = new DamTemplateInfoDTO();
        inVo.setDamTemplateId(damTemplateId);
        DamTemplateInfoDTO outputVo = (DamTemplateInfoDTO)((DamTemplateInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dam/template/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DamTemplateInfoDTO inDamTemplateInfoDTO) {
        int outputVo = ((DamTemplateInfoService)this.getService()).deleteByPk((Object)inDamTemplateInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dam/template/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DamTemplateInfoDTO inDamTemplateInfoDTO) {
        int outputVo = ((DamTemplateInfoService)this.getService()).updateByPk((Object)inDamTemplateInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dam/template/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDamTemplateInfo(@RequestBody DamTemplateInfoDTO inDamTemplateInfoDTO) {
        int outputVo = ((DamTemplateInfoService)this.getService()).insert((Object)inDamTemplateInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/dam/template/info/exec"})
    @ResponseBody
    public ResponseData<String> execTemplateTask(@RequestPart(name="file", required=false) MultipartFile file, @RequestParam(value="damTemplateId") String damTemplateId, HttpServletRequest request) {
        String userId = this.getUserInfo().getUserId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        Enumeration requestParamIterator = request.getParameterNames();
        while (requestParamIterator.hasMoreElements()) {
            String key = (String)requestParamIterator.nextElement();
            String value = request.getParameter(key);
            params.put(key, value);
        }
        DamTemplateInfoDTO damTemplate = new DamTemplateInfoDTO();
        damTemplate.setDamTemplateId(damTemplateId);
        damTemplate = (DamTemplateInfoDTO)((DamTemplateInfoService)this.getService()).queryByPk((Object)damTemplate);
        File uploadFile = null;
        if (file != null) {
            uploadFile = new File(this.tmpDir, UUIDUtil.getUUID() + file.getName());
            try {
                if (!uploadFile.getParentFile().exists()) {
                    uploadFile.getParentFile().mkdirs();
                }
                file.transferTo(uploadFile);
            }
            catch (IOException e) {
                throw new RuntimeException("\u5904\u7406\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25 " + e.getMessage(), e);
            }
        }
        try {
            String message = ((DamTemplateInfoService)this.getService()).execTaskTemplateTask(damTemplate, params, uploadFile);
            return this.getResponseData(message, message, "");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String error = e.getMessage();
            return this.getResponseData(null, "", error);
        }
    }
}

