/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dam.console.facade.DictWordInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictWordInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.DictLogChangeType;
import com.irdstudio.allinrdm.dam.console.types.annotations.DictDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class DictWordInfoController
extends BaseController<DictWordInfoDTO, DictWordInfoService> {
    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="word", itemId="${args[0].wordId}", itemCode="${args[0].wordShortCode}", itemName="${args[0].wordCnDesc}")
    @PostMapping(value={"/api/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> insertDictWordInfo(@RequestBody DictWordInfoDTO inDictWordInfoVo) {
        inDictWordInfoVo.setWordId(UUIDUtil.getUUID());
        inDictWordInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDictWordInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictWordInfoService)this.getService()).insert((Object)inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="word", itemId="${args[0].wordId}", itemCode="${old.wordShortCode}", itemName="${old.wordCnDesc}")
    @DeleteMapping(value={"/api/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictWordInfoDTO inDictWordInfoVo) {
        int outputVo = ((DictWordInfoService)this.getService()).deleteByPk((Object)inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="word", itemId="${args[0].wordId}", itemCode="${args[0].wordShortCode}", itemName="${args[0].wordCnDesc}")
    @PutMapping(value={"/api/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictWordInfoDTO inDictWordInfoVo) {
        inDictWordInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictWordInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictWordInfoService)this.getService()).updateByPk((Object)inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/dict/word/info/{wordId}"})
    @ResponseBody
    public ResponseData<DictWordInfoDTO> queryByPk(@PathVariable(value="wordId") String wordId) {
        DictWordInfoDTO inVo = new DictWordInfoDTO();
        inVo.setWordId(wordId);
        DictWordInfoDTO outputVo = (DictWordInfoDTO)((DictWordInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/word/ss/{word}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<DictWordInfoDTO>> searchByWord(@PathVariable(value="word") String word) {
        DictWordInfoDTO inVo = new DictWordInfoDTO();
        inVo.setWordShortCode(word);
        inVo.setWordCnDesc(word);
        List outputVo = ((DictWordInfoService)this.getService()).queryListByPage((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/my/api/dict/word/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictWordInfoDTO>> queryMyDictWordInfoAll(DictWordInfoDTO dictWordInfo) {
        List outputVo = null;
        this.setUserInfoToVO(dictWordInfo);
        outputVo = ((DictWordInfoService)this.getService()).queryListByPage((Object)dictWordInfo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/word/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictWordInfoDTO>> queryPublicDictWordInfoAll(DictWordInfoDTO dictWordInfo) {
        List outputVo = null;
        this.setUserInfoToVO(dictWordInfo);
        outputVo = ((DictWordInfoService)this.getService()).queryListByPage((Object)dictWordInfo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/dict/word/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, final @RequestParam(value="dslId", required=false) String dslId, @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        try {
            final ArrayList list = new ArrayList();
            final UserInfo userInfo = this.getUserInfo();
            final String createTime = TimeUtil.getCurrentDateTime();
            List<String> HEAD = Arrays.asList("\u540d\u8bcd\u4e2d\u6587\u540d", "\u540d\u79f0\u82f1\u6587\u540d", "\u8bcd\u6839\u7c7b\u578b", "\u6dfb\u52a0/\u4fee\u6539\u65e5\u671f", "\u5907\u6ce8");
            final ArrayList headCellList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), DictWordInfoData.class, (ReadListener)new AnalysisEventListener<DictWordInfoData>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(DictWordInfoData dictWordInfoData, AnalysisContext analysisContext) {
                    DictWordInfoDTO dictWordInfoVO = new DictWordInfoDTO();
                    dictWordInfoVO.setWordId(UUIDUtil.getUUID());
                    dictWordInfoVO.setWordCnDesc(dictWordInfoData.wordCnDesc);
                    dictWordInfoVO.setWordShortCode(dictWordInfoData.wordShortCode);
                    dictWordInfoVO.setWordEnDesc(dictWordInfoData.wordShortCode);
                    dictWordInfoVO.setCreateTime(createTime);
                    dictWordInfoVO.setCreateUser(userInfo.getUserId());
                    dictWordInfoVO.setDslId(dslId);
                    list.add(dictWordInfoVO);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet().headRowNumber(Integer.valueOf(1))).doReadSync();
            if (headCellList.size() != HEAD.size()) {
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 0; i < HEAD.size(); ++i) {
                if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            if (list.size() > 0) {
                ((DictWordInfoService)this.getService()).excelUpload(excelUploadType, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getResponseData("S");
    }

    public static class DictWordInfoData {
        @ExcelProperty(value={"\u540d\u79f0\u82f1\u6587\u540d"})
        private String wordShortCode;
        @ExcelProperty(value={"\u540d\u8bcd\u4e2d\u6587\u540d"})
        private String wordCnDesc;

        public String getWordShortCode() {
            return this.wordShortCode;
        }

        public void setWordShortCode(String wordShortCode) {
            this.wordShortCode = wordShortCode;
        }

        public String getWordCnDesc() {
            return this.wordCnDesc;
        }

        public void setWordCnDesc(String wordCnDesc) {
            this.wordCnDesc = wordCnDesc;
        }
    }
}

