/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.FieldBatchImportDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.SrvFieldFlagService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvFieldFlagDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class ModelTableFieldController
extends BaseController<ModelTableFieldDTO, ModelTableFieldService> {
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
    @Autowired
    private SrvFieldFlagService srvFieldFlagService;

    @PostMapping(value={"/api/model/table/field"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u521b\u5efa\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<String> insertModelTableField(@RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        int orderValue = ((ModelTableFieldService)this.getService()).getCurrentOrderValue(inModelTableFieldVo.getObjectId());
        inModelTableFieldVo.setFieldOrder(Integer.valueOf(orderValue));
        inModelTableFieldVo.setFieldId(UUIDUtil.getUUID());
        inModelTableFieldVo.setCreateUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((ModelTableFieldService)this.getService()).insert((Object)inModelTableFieldVo);
        return this.getResponseData(inModelTableFieldVo.getFieldId());
    }

    @PostMapping(value={"/api/model/table/field/item"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u521b\u5efa\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<String> insertModelTableFieldWithDictItem(@RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        String fieldType = inModelTableFieldVo.getFieldType();
        ResponseData<String> insertFieldResult = this.insertModelTableField(inModelTableFieldVo);
        ModelTableFieldDTO param = new ModelTableFieldDTO();
        param.setFieldId((String)insertFieldResult.getRows());
        ModelTableFieldDTO field = (ModelTableFieldDTO)((ModelTableFieldService)this.getService()).queryByPk((Object)param);
        ((ModelTableFieldService)this.getService()).updateByPk((Object)field);
        return insertFieldResult;
    }

    @AppDevLogAnno(action=LogAction.Update, desc="\u6279\u91cf\u66f4\u65b0\u5b57\u6bb5\u670d\u52a1\u6a21\u578b\u8f93\u5165\u8f93\u51fa\u6807\u5fd7 ${args[0]}", objectId="${args[0]}", srvModelId="${args[1]}")
    @GetMapping(value={"/api/model/table/field/batch/update"})
    @ResponseBody
    public ResponseData<Integer> updateFiledByObjectId(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="srvModelCatalog") String srvModelCatalog, @RequestParam(value="srvModelType") String srvModelType, @RequestParam(value="srvParamFlag") String srvParamFlag) {
        ModelTableFieldDTO fieldVO = new ModelTableFieldDTO();
        fieldVO.setObjectId(objectId);
        List fields = ((ModelTableFieldService)this.getService()).queryList((Object)fieldVO);
        int num = 0;
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            ArrayList<SrvFieldFlagDTO> flagList = new ArrayList<SrvFieldFlagDTO>(fields.size());
            for (ModelTableFieldDTO field : fields) {
                SrvFieldFlagDTO flag = new SrvFieldFlagDTO(field.getFieldId(), field.getObjectId(), srvModelCatalog, srvModelType, srvParamFlag);
                flagList.add(flag);
            }
            this.srvFieldFlagService.batchInsert(flagList);
        }
        return this.getResponseData(num);
    }

    @PutMapping(value={"/api/model/table/field/item"})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> updateWithItem(@RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        String fieldType = inModelTableFieldVo.getFieldType();
        int outputVo = ((ModelTableFieldService)this.getService()).updateByPk((Object)inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/field/batch/import"})
    @ResponseBody
    public ResponseData<String> batchImportFields(@RequestBody FieldBatchImportDTO fbiv) {
        int i;
        ResponseData rsp = new ResponseData();
        ArrayList<ModelTableFieldDTO> fieldList = new ArrayList<ModelTableFieldDTO>();
        String[] lines = fbiv.getContent().split("\n|\r");
        int fieldCodeIdx = 0;
        int fieldNameIdx = 1;
        int fieldTypeIdx = 2;
        String[] props = new String[]{fbiv.getField1(), fbiv.getField2(), fbiv.getField3()};
        for (i = 0; i < props.length; ++i) {
            if (StringUtils.equals((String)"fieldCode", (String)props[i])) {
                fieldCodeIdx = i;
                continue;
            }
            if (StringUtils.equals((String)"fieldName", (String)props[i])) {
                fieldNameIdx = i;
                continue;
            }
            if (!StringUtils.equals((String)"fieldType", (String)props[i])) continue;
            fieldTypeIdx = i;
        }
        for (i = 0; i < lines.length; ++i) {
            if (StringUtils.isEmpty((String)lines[i])) continue;
            String[] fields = StringUtils.split((String)lines[i], (String)fbiv.getSplit());
            if (fields.length < 3) {
                rsp.fail("\u5b57\u6bb5\u4e2a\u6570\u5c11\u4e8e\u6700\u4f4e\u8981\u6c42(3\u4e2a)!");
                return rsp;
            }
            if (fbiv.getSplit().equals(",") && fields.length > 3) {
                fields[fieldTypeIdx] = fields[fieldTypeIdx] + "," + fields[fieldTypeIdx + 1];
            }
            ModelTableFieldDTO mtfv = new ModelTableFieldDTO();
            mtfv.setFieldId(UUIDUtil.getUUID());
            mtfv.setCreateUser(this.getUserInfo().getUserId());
            mtfv.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            mtfv.setFieldCode(fields[fieldCodeIdx]);
            mtfv.setFieldName(fields[fieldNameIdx]);
            String typeStr = fields[fieldTypeIdx];
            if (typeStr.contains("(")) {
                mtfv.setFieldType(typeStr.substring(0, typeStr.indexOf("(")));
                Matcher matcher = pattern.matcher(typeStr);
                if (matcher.matches()) {
                    mtfv.setFieldLength(Integer.valueOf(matcher.group(1)));
                    if (StringUtils.isNotEmpty((String)matcher.group(2))) {
                        mtfv.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                    } else {
                        mtfv.setFieldPrecision(Integer.valueOf(0));
                    }
                }
            } else {
                mtfv.setFieldType(typeStr);
            }
            mtfv.setObjectId(fbiv.getObjectId());
            fieldList.add(mtfv);
        }
        for (ModelTableFieldDTO mtfv : fieldList) {
            try {
                this.insertModelTableField(mtfv);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return this.getResponseData(e.getMessage());
            }
        }
        return this.getResponseData("\u6279\u91cf\u5bfc\u5165\u5b8c\u6210!");
    }

    @DeleteMapping(value={"/api/model/table/field"})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u5b57\u6bb5 ${args[0].fieldId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        int outputVo = ((ModelTableFieldService)this.getService()).deleteByPk((Object)inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/model/table/field"})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[1].fieldName} ${args[1].fieldCode}", objectId="${args[1].objectId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestParam(value="needUpdateIsrv", required=false) String needUpdateIsrv, @RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((ModelTableFieldService)this.getService()).updateByPk((Object)inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/model/table/field/list"})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5\u6392\u5e8f")
    @ResponseBody
    public ResponseData<Integer> updateFieldOrder(@RequestBody List<ModelTableFieldDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (ModelTableFieldDTO field : list) {
                field.setLastModifyUser(this.getUserInfo().getUserId());
                field.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                outputVo += ((ModelTableFieldService)this.getService()).updateByPk(field, false);
            }
        }
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/model/table/field/ioflag"})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[0].fieldId}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> updateIoFlagByPk(@RequestBody ModelTableFieldDTO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((ModelTableFieldService)this.getService()).updateFieldByPk(inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/field/{sourceId}/{targetId}"})
    @ResponseBody
    public ResponseData<Integer> doExchange(@PathVariable(value="sourceId") String sourceId, @PathVariable(value="targetId") String targetId) {
        int outputVo = ((ModelTableFieldService)this.getService()).doExchange(sourceId, targetId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/field/up/{fieldId}"})
    @ResponseBody
    public ResponseData<Integer> fieldSortUp(@PathVariable(value="fieldId") String fieldId) {
        int outputVo = ((ModelTableFieldService)this.getService()).fieldSortUp(fieldId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/field/down/{fieldId}"})
    @ResponseBody
    public ResponseData<Integer> fieldSortDown(@PathVariable(value="fieldId") String fieldId) {
        int outputVo = ((ModelTableFieldService)this.getService()).fieldSortDown(fieldId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/field/{fieldId}"})
    @ResponseBody
    public ResponseData<ModelTableFieldDTO> queryByPk(@PathVariable(value="fieldId") String fieldId, @RequestParam(value="srvModelCatalog", required=false) String srvModelCatalog, @RequestParam(value="srvModelType", required=false) String srvModelType) {
        ModelTableFieldDTO inVo = new ModelTableFieldDTO();
        inVo.setFieldId(fieldId);
        inVo.setSrvModelCatalog(srvModelCatalog);
        inVo.setSrvModelType(srvModelType);
        ModelTableFieldDTO outputVo = (ModelTableFieldDTO)((ModelTableFieldService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/fields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryModelTableFieldAll(ModelTableFieldDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableFieldService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/fields/tb"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryFieldBySysCodeByPage(@RequestBody ModelTableInfoDTO modelTableInfo) {
        List output = ((ModelTableFieldService)this.getService()).queryFieldBySysCodeByPage(modelTableInfo);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/model/table/fields2"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryModelTableFields(ModelTableFieldDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableFieldService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/fields/withflag"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryFieldWithFieldFlag(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelCatalog") String srvModelCatalog, @RequestParam(value="srvModelType") String srvModelType) {
        List outputVo = ((ModelTableFieldService)this.getService()).queryFieldWithFieldFlag(objectId, srvModelCatalog, srvModelType);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/field/quicks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryExistsFieldByPage(ModelTableFieldDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableFieldService)this.getService()).queryExistsFieldByPage(vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/model/table/field/copyfromother"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u4ece\u5176\u5b83\u8868\u590d\u5236\u5b57\u6bb5 ${args[0].fieldName} ${args[0].objectId}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> insertModelTableField(@RequestBody Map<String, Object> copyData) {
        int num = 0;
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        String objectId = MapUtils.getString(copyData, (Object)"objectId");
        List fieldIds = (List)copyData.get("fieldIds");
        if (CollectionUtils.isNotEmpty((Collection)fieldIds)) {
            for (String fieldId : fieldIds) {
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setFieldId(fieldId);
                fieldParam = (ModelTableFieldDTO)((ModelTableFieldService)this.getService()).queryByPk((Object)fieldParam);
                if (fieldParam == null) continue;
                fieldParam.setFieldId(UUIDUtil.getUUID());
                fieldParam.setObjectId(objectId);
                fieldParam.setCreateUser(userId);
                fieldParam.setCreateTime(now);
                fieldParam.setLastModifyUser(userId);
                fieldParam.setLastModifyTime(now);
                num += ((ModelTableFieldService)this.getService()).insert((Object)fieldParam);
            }
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/model/table/field/markcheckdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> markcheckdetail(ModelTableFieldDTO param) {
        List modelTableFieldVOS = ((ModelTableFieldService)this.getService()).queryList((Object)param);
        for (ModelTableFieldDTO modelTableFieldVO : modelTableFieldVOS) {
            modelTableFieldVO.setFieldTypeFormat(ModelTableFieldController.extracted(modelTableFieldVO.getFieldType(), modelTableFieldVO.getFieldLength(), modelTableFieldVO.getFieldPrecision()));
            modelTableFieldVO.setPreFieldTypeFormat(ModelTableFieldController.extracted(modelTableFieldVO.getPreFieldType(), modelTableFieldVO.getPreFieldLength(), modelTableFieldVO.getPreFieldPrecision()));
        }
        return this.getResponseData(modelTableFieldVOS);
    }

    private static String extracted(String fieldType, Integer fieldLength, Integer fieldPrecision) {
        if (fieldLength == null && fieldPrecision == null) {
            return fieldType;
        }
        if (fieldLength != null && fieldPrecision == null) {
            return String.join((CharSequence)"", fieldType, "(", String.valueOf(fieldLength), ")");
        }
        return String.join((CharSequence)"", fieldType, "(", String.valueOf(fieldLength), ",", String.valueOf(fieldPrecision), ")");
    }

    @RequestMapping(value={"/client/ModelTableFieldService/deleteByObjectId"}, method={RequestMethod.GET})
    public int deleteByObjectId(@RequestParam(value="objectId") String objectId) {
        return ((ModelTableFieldService)this.getService()).deleteByObjectId(objectId);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/queryInoutFieldsByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableFieldDTO> queryInoutFieldsByPage_forClient(@RequestBody ModelTableFieldDTO fieldParam) {
        return ((ModelTableFieldService)this.getService()).queryInoutFieldsByPage(fieldParam);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/deleteByObjectIds"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByObjectIds(@RequestBody List<String> objectIds) {
        return ((ModelTableFieldService)this.getService()).deleteByObjectIds(objectIds);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/updateByPk/withFieldName"}, method={RequestMethod.POST})
    @ResponseBody
    public int updateByPk(@RequestBody ModelTableFieldDTO modelTableFieldVo, @RequestParam(value="updateFieldName") boolean updateFieldName) {
        return ((ModelTableFieldService)this.getService()).updateByPk(modelTableFieldVo, updateFieldName);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/batchQueryInoutPkFieldList"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableFieldDTO> batchQueryInoutPkFieldList(@RequestBody List<String> inoutObjectIds, @RequestParam(value="fieldFlag") String fieldFlag, @RequestParam(value="isPk") String isPk) {
        return ((ModelTableFieldService)this.getService()).batchQueryInoutPkFieldList(inoutObjectIds, fieldFlag, isPk);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/queryFieldWithFieldFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableFieldDTO> queryFieldWithFieldFlag_client(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelCatalog") String srvModelCatalog, @RequestParam(value="srvModelType") String srvModelType) {
        return ((ModelTableFieldService)this.getService()).queryFieldWithFieldFlag(objectId, srvModelCatalog, srvModelType);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/updateBatchFieldInfoOnly"}, method={RequestMethod.POST})
    @ResponseBody
    public int updateBatchFieldInfoOnly(@RequestBody List<ModelTableFieldDTO> list) {
        return ((ModelTableFieldService)this.getService()).updateBatchFieldInfoOnly(list);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/fieldRefactorByObjectId"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer fieldRefactorByObjectId(@RequestParam(value="objectId") String objectId, @RequestParam(value="dataMarkFlag") String dataMarkFlag, @RequestParam(value="dslId") String dslId, @RequestParam(value="userId") String userId) {
        return ((ModelTableFieldService)this.getService()).fieldRefactorByObjectId(objectId, dataMarkFlag, dslId, userId);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/queryFieldBySysCodeByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableFieldDTO> queryFieldBySysCodeByPage_client(@RequestBody ModelTableInfoDTO modelTableInfo) {
        return ((ModelTableFieldService)this.getService()).queryFieldBySysCodeByPage(modelTableInfo);
    }

    @RequestMapping(value={"/client/ModelTableFieldService/queryModelTableFieldAllOptions"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableFieldDTO> queryModelTableFieldAllOptions(@RequestParam(value="appId") String appId) {
        return ((ModelTableFieldService)this.getService()).queryModelTableFieldAllOptions(appId);
    }
}

