/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.DirectoryTreeUtil;
import com.irdstudio.allinrdm.dev.console.application.service.utils.FileReplacePattern;
import com.irdstudio.allinrdm.dev.console.application.service.utils.ReplaceDirAndFileBean;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceLogService;
import com.irdstudio.allinrdm.dev.console.facade.CodeTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.CodeTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.bo.CodeProduceInfoBo;
import com.irdstudio.allinrdm.dev.console.facade.bo.CodeTemplateFileBo;
import com.irdstudio.allinrdm.dev.console.facade.bo.CodeTemplateInfoBo;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeProduceInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeProduceLogDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateInfoDTO;
import com.irdstudio.allinrdm.sam.console.application.service.utils.JGitUtil;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SUserDTO;
import com.irdstudio.allintcp.admin.facade.dto.SUserProfileDTO;
import com.irdstudio.sdk.beans.core.spring.SpringPropertyUtils;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class ApiForCodeProduceController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(ApiForCodeProduceController.class);
    @Autowired
    private CodeProduceInfoService codeProduceInfoService;
    @Autowired
    private CodeProduceLogService codeProduceLogService;
    @Autowired
    private CodeTemplateFileService codeTemplateFileService;
    @Autowired
    private CodeTemplateInfoService codeTemplateInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private ModelFolderInfoService modelFolderInfoService;
    @Autowired
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    private FnModelInfoService fnModelInfoService;
    @Autowired
    private ComBaseInfoService comBaseInfoService;
    @Value(value="${facenter.template.path:}")
    private String templatePath;
    @Value(value="${facenter.code.path:}")
    private String codePath;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");

    @GetMapping(value={"/api/code/produce/batch"})
    @ResponseBody
    public ResponseData<Integer> codeProduceBatch(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="produceId", required=false) String produceId, @RequestParam(value="comId", required=false) String comId, @RequestParam(value="fnFlag", required=false) boolean fnFlag) {
        CodeProduceInfoDTO params = new CodeProduceInfoDTO();
        params.setSubsId(subsId);
        params.setAppId(appId);
        params.setComId(comId);
        if (StringUtils.isNotBlank((CharSequence)produceId)) {
            String[] ids = StringUtils.split((String)produceId, (String)",");
            params.setProduceIds(Arrays.asList(ids));
        }
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        if (appInfo != null) {
            AppTemplateRepoPullTask pullTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
            pullTask.syncRun();
        }
        String userId = this.getUserInfo().getUserId();
        List configList = Collections.emptyList();
        String producePath = appId;
        if (fnFlag) {
            FnModelInfoDTO fnParam = new FnModelInfoDTO();
            fnParam.setFnIds(params.getProduceIds());
            fnParam.setSubsId(subsId);
            fnParam.setAppId(appId);
            fnParam.setFnTypes(Arrays.asList(FnType.Create.getCode(), FnType.Update.getCode(), FnType.List.getCode(), FnType.Detail.getCode(), FnType.Remove.getCode(), FnType.Import.getCode(), FnType.Pop.getCode()));
            List fnList = this.fnModelInfoService.queryList((Object)fnParam);
            if (CollectionUtils.isNotEmpty((Collection)fnList)) {
                for (FnModelInfoDTO fnInfo : fnList) {
                    CodeProduceInfoDTO codeProduceInfo = new CodeProduceInfoDTO();
                    codeProduceInfo.setProduceId(fnInfo.getFnId());
                    codeProduceInfo.setCodeTemplateId(fnInfo.getTemplateId());
                    codeProduceInfo.setCodeTemplateName(fnInfo.getTemplateName());
                    codeProduceInfo.setModelTableId(fnInfo.getTableModelId());
                    codeProduceInfo.setModelTableCode(fnInfo.getTableModelCode());
                    codeProduceInfo.setModelTableName(fnInfo.getTableModelName());
                    codeProduceInfo.setAppId(fnInfo.getAppId());
                    codeProduceInfo.setSubsId(fnInfo.getSubsId());
                    configList.add(codeProduceInfo);
                }
            }
        } else {
            configList = this.codeProduceInfoService.queryList((Object)params);
            if (StringUtils.isNotBlank((CharSequence)comId)) {
                producePath = comId;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)producePath)) {
            FileUtils.deleteQuietly((File)new File(this.codePath, producePath));
        }
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty((Collection)configList)) {
            int len = 100;
            if (configList.size() > len) {
                int loop = this.calcLoop(configList.size(), len);
                ArrayList<Future> futureList = new ArrayList<Future>(loop);
                int cur = 0;
                for (int i = 1; i <= loop; ++i) {
                    int end = len * i;
                    if (end > configList.size()) {
                        end = configList.size();
                    }
                    List<CodeProduceInfoDTO> sub = configList.subList(cur, end);
                    cur += len;
                    Future future = this.applicationThreadPool.add((Callable)new BatchGenerateCodeTask(sub, userId, producePath, fnFlag));
                    futureList.add(future);
                }
                while (!futureList.isEmpty()) {
                    ArrayList<Future> newList = new ArrayList<Future>(loop);
                    for (Future f : futureList) {
                        if (f.isDone()) continue;
                        newList.add(f);
                    }
                    futureList = newList;
                }
                outputVo = loop;
            } else {
                for (CodeProduceInfoDTO config : configList) {
                    ResponseData<CodeProduceLogDTO> re = this.codeProduce(config.getModelTableId(), config.getCodeTemplateId(), config.getProduceId(), producePath, true, "T", fnFlag, userId);
                    if (((CodeProduceLogDTO)re.getRows()).getProduceState() != 0) continue;
                    ++outputVo;
                }
            }
        }
        return this.getResponseData(outputVo);
    }

    private int calcLoop(int size, int len) {
        int loop = size / len;
        if (size % len > 0) {
            return loop + 1;
        }
        return loop;
    }

    @GetMapping(value={"/api/code/produce/{modelTableId}/{codeTemplateId}/{produceId}"})
    @ResponseBody
    public ResponseData<CodeProduceLogDTO> codeProduce(@PathVariable(value="modelTableId") String modelTableId, @PathVariable(value="codeTemplateId") String codeTemplateId, @PathVariable(value="produceId") String produceId, @RequestParam(value="producePath", required=false) String producePath, @RequestParam(value="userAppId", required=false) Boolean userAppId, @RequestParam(value="genType", required=false) String genType, @RequestParam(value="fnFlag", required=false) Boolean fnFlag, @RequestParam(value="currentUserId", required=false) String currentUserId) {
        File templateDir;
        File[] templateFiles;
        logger.info("\u4ee3\u7801\u751f\u6210\u5f00\u59cb...");
        if (StringUtils.isBlank((CharSequence)genType)) {
            genType = "T";
        }
        if (userAppId == null) {
            userAppId = Boolean.FALSE;
        }
        String author = currentUserId;
        try {
            if (this.getUserInfo() != null) {
                author = this.getUserInfo().getUserId();
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e0d\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        boolean isReProduce = false;
        CodeProduceInfoBo codeProduceInfo = null;
        if (fnFlag != null && fnFlag.booleanValue()) {
            FnModelInfoDTO fnInfo = new FnModelInfoDTO();
            fnInfo.setFnId(produceId);
            fnInfo = (FnModelInfoDTO)this.fnModelInfoService.queryByPk((Object)fnInfo);
            codeProduceInfo = new CodeProduceInfoBo();
            codeProduceInfo.setProduceId(fnInfo.getFnId());
            codeProduceInfo.setCodeTemplateId(fnInfo.getTemplateId());
            codeProduceInfo.setCodeTemplateName(fnInfo.getTemplateName());
            codeProduceInfo.setModelTableId(fnInfo.getTableModelId());
            codeProduceInfo.setModelTableCode(fnInfo.getTableModelCode());
            codeProduceInfo.setModelTableName(fnInfo.getTableModelName());
            codeProduceInfo.setAppId(fnInfo.getAppId());
            codeProduceInfo.setSubsId(fnInfo.getSubsId());
        } else if (StringUtils.isEmpty((CharSequence)produceId) || "NONE".equals(produceId)) {
            produceId = UUIDUtil.getUUID();
            codeProduceInfo = new CodeProduceInfoBo();
            codeProduceInfo.setProduceId(produceId);
            codeProduceInfo.setProduceType("");
            codeProduceInfo.setModelTableId(modelTableId);
            codeProduceInfo.setCodeTemplateId(codeTemplateId);
        } else {
            isReProduce = true;
            CodeProduceInfoDTO inVo = new CodeProduceInfoDTO();
            inVo.setProduceId(produceId);
            CodeProduceInfoDTO cpiv = (CodeProduceInfoDTO)this.codeProduceInfoService.queryByPk((Object)inVo);
            codeProduceInfo = new CodeProduceInfoBo();
            BeanUtils.copyProperties((Object)cpiv, (Object)codeProduceInfo);
        }
        codeProduceInfo.setUserAppId(userAppId);
        if (userAppId.booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)producePath)) {
                codeProduceInfo.setProducePath(producePath);
            } else {
                codeProduceInfo.setProducePath(codeProduceInfo.getAppId());
            }
        } else {
            FileUtils.deleteQuietly((File)new File(this.codePath, codeProduceInfo.getProduceId()));
        }
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setObjectId(codeProduceInfo.getModelTableId());
        ModelTableInfoDTO modelTableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableParam);
        ModelTableInfoBo tableInfoBo = new ModelTableInfoBo();
        tableInfoBo.setTableId(modelTableInfo.getObjectId());
        tableInfoBo.setComId(modelTableInfo.getComId());
        tableInfoBo.setTableCode(modelTableInfo.getObjectCode());
        tableInfoBo.setTableName(modelTableInfo.getObjectName());
        tableInfoBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)modelTableInfo.getObjectCode()));
        tableInfoBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)modelTableInfo.getObjectCode()));
        if (StringUtils.isNotBlank((CharSequence)modelTableInfo.getFolderId())) {
            ModelFolderInfoDTO packageParam = new ModelFolderInfoDTO();
            packageParam.setFolderId(modelTableInfo.getFolderId());
            ModelFolderInfoDTO tablePackage = (ModelFolderInfoDTO)this.modelFolderInfoService.queryByPk((Object)packageParam);
            if (tablePackage != null) {
                tableInfoBo.setFolderId(tablePackage.getFolderId());
                tableInfoBo.setFolderCode(tablePackage.getFolderCode());
                tableInfoBo.setFolderName(tablePackage.getFolderName());
            }
        }
        ModelTableFieldDTO tableFieldParam = new ModelTableFieldDTO();
        tableFieldParam.setObjectId(codeProduceInfo.getModelTableId());
        List tableFieldList = this.modelTableFieldService.queryList((Object)tableFieldParam);
        ArrayList<ModelTableFieldBo> tableFieldBoList = new ArrayList<ModelTableFieldBo>();
        ArrayList fieldOptionList = new ArrayList();
        for (ModelTableFieldDTO fieldDTO : tableFieldList) {
            ModelTableFieldBo mtfb = new ModelTableFieldBo();
            BeanUtils.copyProperties((Object)fieldDTO, (Object)mtfb);
            String javaPropertyName = TmModelUtil.fieldToProperty((String)fieldDTO.getFieldCode());
            mtfb.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
            mtfb.setJavaPropertyName(javaPropertyName);
            mtfb.setJavaType(TmModelUtil.fieldTypeToJavaType((String)fieldDTO.getFieldType()));
            tableFieldBoList.add(mtfb);
            if (!StringUtils.isNotBlank((CharSequence)fieldDTO.getFieldOption())) continue;
            String dictId = fieldDTO.getDictId();
            DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
            enumParam.setDictId(dictId);
            enumParam.setSubsId(codeProduceInfo.getSubsId());
            List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
            DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
            optionInfo.setDictId(dictId);
            optionInfo.setSubsId(codeProduceInfo.getSubsId());
            if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
            if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                for (DictOptionEnumDTO dict : dictList) {
                    Matcher m;
                    if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                        dict.setOptionEnum(optionEnum);
                    }
                    if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                    String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                    dict.setOptionEnum(optionEnum);
                }
            }
            String oriDictCode = optionInfo.getDictCode();
            optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
            HashMap<String, Object> optionMap = new HashMap<String, Object>();
            optionMap.put("dictCode", optionInfo.getDictCode());
            optionMap.put("dictId", oriDictCode);
            optionMap.put("option", optionInfo);
            optionMap.put("dictList", dictList);
            fieldOptionList.add(optionMap);
        }
        tableInfoBo.setFieldOptionList(fieldOptionList);
        tableInfoBo.setFieldList(tableFieldBoList);
        logger.info("\u8868\u540d\uff1a" + tableInfoBo.getTableCode());
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        if (StringUtils.isNotBlank((CharSequence)modelTableInfo.getComId())) {
            ComBaseInfoDTO comBaseInfoDTO = new ComBaseInfoDTO();
            comBaseInfoDTO.setComId(modelTableInfo.getComId());
            comBaseInfoDTO.setSubsId(codeProduceInfo.getSubsId());
            comBaseInfoDTO = (ComBaseInfoDTO)this.comBaseInfoService.queryByPk((Object)comBaseInfoDTO);
            if (comBaseInfoDTO != null && StringUtils.isNotBlank((CharSequence)comBaseInfoDTO.getAppId())) {
                appInfo.setAppId(comBaseInfoDTO.getAppId());
            }
        } else {
            appInfo.setAppId(codeProduceInfo.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)codeProduceInfo.getAppId())) {
            appInfo.setAppId(modelTableInfo.getAppId());
        }
        PaasAppsInfoDTO paasAppsInfoDTO = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        TmProjectInfoBo tmProjectInfo = new TmProjectInfoBo();
        tmProjectInfo.setProjectId(paasAppsInfoDTO.getAppId());
        tmProjectInfo.setProjectCode(paasAppsInfoDTO.getAppCode());
        tmProjectInfo.setProjectName(paasAppsInfoDTO.getAppName());
        logger.info("\u6570\u636e\u5bf9\u8c61\u5de5\u7a0b\uff1a" + tmProjectInfo.getProjectCode());
        if (!userAppId.booleanValue()) {
            AppTemplateRepoPullTask pullTask = new AppTemplateRepoPullTask(paasAppsInfoDTO.getAppTemplateId());
            pullTask.syncRun();
        }
        CodeTemplateInfoDTO codeTemplateParam = new CodeTemplateInfoDTO();
        codeTemplateParam.setCodeTemplateId(codeProduceInfo.getCodeTemplateId());
        CodeTemplateInfoDTO outputCtiv = (CodeTemplateInfoDTO)this.codeTemplateInfoService.queryByPk((Object)codeTemplateParam);
        CodeTemplateInfoBo codeTemplateInfo = new CodeTemplateInfoBo();
        codeTemplateInfo.setCodeTemplateId(outputCtiv.getCodeTemplateId());
        codeTemplateInfo.setCodeTemplateName(outputCtiv.getCodeTemplateName());
        String codeTemplateName = codeTemplateInfo.getCodeTemplateName();
        logger.info("\u6a21\u677f\u540d\u79f0\uff1a" + codeTemplateName);
        List codeTemplateFileList = this.codeTemplateFileService.getCodeTemplateFile(codeProduceInfo.getCodeTemplateId());
        ArrayList<CodeTemplateFileBo> ctfbList = new ArrayList<CodeTemplateFileBo>();
        for (CodeTemplateFileDTO ctf : codeTemplateFileList) {
            CodeTemplateFileBo ctfb = new CodeTemplateFileBo();
            BeanUtils.copyProperties((Object)ctf, (Object)ctfb);
            ctfbList.add(ctfb);
        }
        String templatePath = null;
        if (StringUtils.isNotBlank((CharSequence)outputCtiv.getAppTemplateId()) && ((templateFiles = (templateDir = new File(templatePath = SdEnvUtil.getTemplatePath((String)outputCtiv.getAppTemplateId()))).listFiles()) == null || templateFiles.length < ctfbList.size())) {
            templatePath = null;
        }
        String errorMsg = "";
        try {
            this.codeProduceInfoService.produceModelBeanCode(templatePath, author, codeProduceInfo, tmProjectInfo, tableInfoBo, ctfbList, userAppId == false);
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            logger.error(e.getMessage(), (Throwable)e);
        }
        CodeProduceLogDTO produceLog = new CodeProduceLogDTO();
        BeanUtility.beanCopy((Object)codeProduceInfo, (Object)produceLog);
        produceLog.setLogId(UUIDUtil.getUUID());
        produceLog.setProduceDesc("\u751f\u6210" + tableInfoBo.getTableCode() + codeTemplateInfo.getCodeTemplateName());
        produceLog.setModelTableCode(tableInfoBo.getTableCode());
        produceLog.setModelTableName(tableInfoBo.getTableName());
        produceLog.setCodeTemplateName(codeTemplateInfo.getCodeTemplateName());
        produceLog.setCreateUser(author);
        produceLog.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        produceLog.setProduceTime(CurrentDateUtil.getTodayDateEx2());
        produceLog.setGenType(genType);
        produceLog.setProduceState(Integer.valueOf(StringUtils.isNotBlank((CharSequence)errorMsg) ? 1 : 0));
        produceLog.setProduceMsg(errorMsg);
        this.codeProduceLogService.insert((Object)produceLog);
        logger.info("\u4ee3\u7801\u751f\u6210\u5b8c\u6210!");
        return this.getResponseData(produceLog);
    }

    @GetMapping(value={"/api/code/view/{produceId}"})
    @ResponseBody
    public ResponseData<String> codeProduce(@PathVariable(value="produceId") String produceId) {
        if (StringUtils.isEmpty((CharSequence)produceId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            return data;
        }
        String codePath = SpringPropertyUtils.getProperty((String)"facenter.code.path") + produceId;
        logger.info("\u4ee3\u7801\u76ee\u5f55\uff1a" + codePath);
        return this.getResponseData(DirectoryTreeUtil.getTreeJson((String)codePath));
    }

    @GetMapping(value={"/api/code/template/preview/{templateId}"})
    @ResponseBody
    public ResponseData<String> codeTemplate(@PathVariable(value="templateId") String templateId) {
        if (StringUtils.isEmpty((CharSequence)templateId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u6a21\u677f\u6807\u8bc6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u6a21\u677f\u6807\u8bc6!");
            return data;
        }
        String templatePath = this.getTemplatePath(templateId);
        logger.info("\u6a21\u677f\u76ee\u5f55\uff1a" + templatePath);
        return this.getResponseData(DirectoryTreeUtil.getTreeJson((String)templatePath));
    }

    private String getTemplatePath(String templateId) {
        CodeTemplateInfoDTO templateParam = new CodeTemplateInfoDTO();
        templateParam.setCodeTemplateId(templateId);
        CodeTemplateInfoDTO codeTemplateInfoVO = (CodeTemplateInfoDTO)this.codeTemplateInfoService.queryByPk((Object)templateParam);
        if (StringUtils.isNotBlank((CharSequence)codeTemplateInfoVO.getAppTemplateId())) {
            String basePath = SpringPropertyUtils.getProperty((String)"facenter.template.path");
            File baseFile = new File(basePath);
            File ParentFile = baseFile.getParentFile();
            String templatePath = ParentFile.getAbsolutePath() + File.separator + codeTemplateInfoVO.getCodeTemplateId();
            return templatePath;
        }
        String templatePath = SpringPropertyUtils.getProperty((String)"facenter.template.path") + File.separator + codeTemplateInfoVO.getCodeTemplateId();
        return templatePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/code/template/file/open"})
    @ResponseBody
    public ResponseData<String> codeTemplateFileOpen(@RequestParam(name="templateId") String templateId, @RequestParam(name="file") String file) {
        if (StringUtils.isEmpty((CharSequence)file)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            return data;
        }
        String codePath = this.getTemplatePath(templateId);
        File basePath = new File(codePath);
        File parentFile = basePath.getParentFile();
        StringBuffer content = new StringBuffer("");
        if (!StringUtils.isEmpty((CharSequence)file)) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(parentFile.getAbsoluteFile() + File.separator + file), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("content", content.toString());
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/code/file/open"})
    @ResponseBody
    public ResponseData<String> codeFileOpen(@RequestParam(name="file") String file) {
        if (StringUtils.isEmpty((CharSequence)file)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            return data;
        }
        String codePath = SpringPropertyUtils.getProperty((String)"facenter.code.path");
        StringBuffer content = new StringBuffer("");
        if (!StringUtils.isEmpty((CharSequence)file)) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(codePath + File.separator + file), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("content", content.toString());
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @GetMapping(value={"/api/code/download/{produceId}"})
    public void codeDownload(@PathVariable(value="produceId") String produceId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)produceId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            return;
        }
        String codeZipFilePath = SpringPropertyUtils.getProperty((String)"facenter.code.path") + produceId + ".zip";
        logger.info(codeZipFilePath);
        logger.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + codeZipFilePath);
        try {
            int j;
            File file = new File(codeZipFilePath);
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + codeZipFilePath);
            response.setContentLength((int)file.length());
            response.setContentType("application/zip");
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream buff = new BufferedInputStream(fis);
            byte[] b = new byte[1024];
            ServletOutputStream myout = response.getOutputStream();
            for (long k = 0L; k < file.length(); k += (long)j) {
                j = buff.read(b, 0, 1024);
                myout.write(b, 0, j);
            }
            myout.flush();
            buff.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/api/code/produce/genAll/{appId}/{codeTemplateId}"})
    @ResponseBody
    public ResponseData<CodeProduceInfoDTO> codeProduceAll(@PathVariable(value="appId") String appId, @PathVariable(value="codeTemplateId") String codeTemplateId, @RequestParam(value="folderId", required=false) String folderId, @RequestParam(value="genType", required=false) String genType) {
        CodeProduceInfoDTO cpiv;
        logger.info("\u4ee3\u7801\u751f\u6210\u5f00\u59cb...");
        String author = this.getUserInfo().getUserId();
        boolean isReProduce = false;
        CodeProduceInfoBo cpib = null;
        String produceId = "NONE";
        if (StringUtils.isEmpty((CharSequence)produceId) || "NONE".equals(produceId)) {
            produceId = UUIDUtil.getUUID();
            cpib = new CodeProduceInfoBo();
            cpib.setProduceId(produceId);
            cpib.setProduceType("");
            cpib.setCodeTemplateId(codeTemplateId);
        }
        cpib.setUserAppId(Boolean.valueOf(false));
        PaasAppsInfoDTO ptiv = new PaasAppsInfoDTO();
        ptiv.setAppId(appId);
        PaasAppsInfoDTO outPtiv = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)ptiv);
        TmProjectInfoBo mpib = new TmProjectInfoBo();
        mpib.setProjectId(outPtiv.getAppId());
        mpib.setProjectCode(outPtiv.getAppCode());
        mpib.setProjectName(outPtiv.getAppName());
        String refDbAppid = "";
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
            refDbAppid = appInfo.getRefDbAppid();
            mpib.setProjectId(appInfo.getAppId());
            mpib.setProjectCode(appInfo.getAppCode());
            mpib.setProjectName(appInfo.getAppName());
        } else {
            mpib.setProjectId(outPtiv.getAppId());
            mpib.setProjectCode(outPtiv.getAppCode());
            mpib.setProjectName(outPtiv.getAppName());
        }
        logger.info("\u6570\u636e\u5bf9\u8c61\u5de5\u7a0b\uff1a" + mpib.getProjectCode());
        logger.info("\u5224\u65ad\u662f\u5426\u6709\u6a21\u677f\u5de5\u7a0b");
        File temlpateProject = new File(this.templatePath + File.separator + codeTemplateId + File.separator + codeTemplateId + "-project");
        if (temlpateProject.exists()) {
            PaasAppsParamService paasAppsParamService = (PaasAppsParamService)SpringContextUtils.getBean(PaasAppsParamService.class);
            PaasAppsParamDTO package_prefix = new PaasAppsParamDTO();
            package_prefix.setAppId(mpib.getProjectId());
            package_prefix.setParamCode("package_prefix");
            package_prefix = (PaasAppsParamDTO)paasAppsParamService.queryByPk((Object)package_prefix);
            Object packagePrefixVal = "com.irdstudio";
            if (package_prefix != null && StringUtils.isNotBlank((CharSequence)package_prefix.getParamValue())) {
                packagePrefixVal = package_prefix.getParamValue();
            }
            logger.info("\u6709\u6a21\u677f\u5de5\u7a0b\uff0c \u751f\u6210\u5de5\u7a0b\u7ed3\u6784");
            this.copyGenProjectStructure(produceId, codeTemplateId, mpib.getProjectCode(), (String)packagePrefixVal);
        }
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appId);
        if (StringUtils.isNotBlank((CharSequence)folderId)) {
            tableParam.setFolderId(folderId);
        } else {
            tableParam.setObjectType(ObjectType.Table.getIntCode());
        }
        tableParam.setObjectCodes(Arrays.asList(ObjectType.Table.getCode()));
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        if (CollectionUtils.isEmpty((Collection)tableList) && StringUtils.isNotBlank((CharSequence)refDbAppid)) {
            tableParam.setRefDbAppid(refDbAppid);
            tableList = this.modelTableInfoService.queryList((Object)tableParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                ModelTableInfoDTO mtInVo = new ModelTableInfoDTO();
                mtInVo.setObjectId(table.getObjectId());
                cpib.setModelTableId(table.getObjectId());
                ModelTableInfoDTO mti = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)mtInVo);
                ModelTableInfoBo mtib = new ModelTableInfoBo();
                mtib.setTableId(mti.getObjectId());
                mtib.setTableCode(mti.getObjectCode());
                mtib.setTableName(mti.getObjectName());
                mtib.setModelClassName(TmModelUtil.tableCodeToClassName((String)mti.getObjectCode()));
                mtib.setJavaPropertyName(TmModelUtil.fieldToProperty((String)mti.getObjectCode()));
                ModelTableFieldDTO mtfv = new ModelTableFieldDTO();
                mtfv.setObjectId(cpib.getModelTableId());
                List mtfvList = this.modelTableFieldService.queryList((Object)mtfv);
                ArrayList<ModelTableFieldBo> mtfbList = new ArrayList<ModelTableFieldBo>();
                for (ModelTableFieldDTO mtf : mtfvList) {
                    ModelTableFieldBo mtfb = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)mtf, (Object)mtfb);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)mtf.getFieldCode());
                    mtfb.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    mtfb.setJavaPropertyName(javaPropertyName);
                    mtfb.setJavaType(TmModelUtil.fieldTypeToJavaType((String)mtf.getFieldType()));
                    mtfbList.add(mtfb);
                }
                mtib.setFieldList(mtfbList);
                logger.info("\u8868\u540d\uff1a" + mtib.getTableCode());
                CodeTemplateInfoDTO ctiv = new CodeTemplateInfoDTO();
                ctiv.setCodeTemplateId(cpib.getCodeTemplateId());
                CodeTemplateInfoDTO outputCtiv = (CodeTemplateInfoDTO)this.codeTemplateInfoService.queryByPk((Object)ctiv);
                CodeTemplateInfoBo ctib = new CodeTemplateInfoBo();
                ctib.setCodeTemplateId(outputCtiv.getCodeTemplateId());
                ctib.setCodeTemplateName(outputCtiv.getCodeTemplateName());
                String codeTemplateName = ctib.getCodeTemplateName();
                logger.info("\u6a21\u677f\u540d\u79f0\uff1a" + codeTemplateName);
                List outputCtfvList = this.codeTemplateFileService.getCodeTemplateFile(cpib.getCodeTemplateId());
                ArrayList<CodeTemplateFileBo> ctfbList = new ArrayList<CodeTemplateFileBo>();
                for (CodeTemplateFileDTO ctf : outputCtfvList) {
                    CodeTemplateFileBo ctfb = new CodeTemplateFileBo();
                    BeanUtils.copyProperties((Object)ctf, (Object)ctfb);
                    ctfbList.add(ctfb);
                }
                this.codeProduceInfoService.produceModelBeanCode(null, author, cpib, mpib, mtib, ctfbList, true);
                cpib.setProduceDesc("\u751f\u6210" + mtib.getTableCode() + ctib.getCodeTemplateName());
                cpib.setModelTableCode(mtib.getTableCode());
                cpib.setModelTableName(mtib.getTableName());
                cpib.setCodeTemplateName(ctib.getCodeTemplateName());
            }
        }
        if (!isReProduce) {
            cpib.setCreateUser(author);
            cpib.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            cpib.setProduceTime(cpib.getCreateTime());
            cpiv = new CodeProduceInfoDTO();
            BeanUtils.copyProperties((Object)cpib, (Object)cpiv);
            cpiv.setGenType(genType);
            this.codeProduceInfoService.insert((Object)cpiv);
        } else {
            cpib.setProduceTime(CurrentDateUtil.getTodayDateEx2());
            cpiv = new CodeProduceInfoDTO();
            BeanUtils.copyProperties((Object)cpib, (Object)cpiv);
            cpiv.setGenType(genType);
            this.codeProduceInfoService.updateByPk((Object)cpiv);
        }
        logger.info("\u4ee3\u7801\u751f\u6210\u5b8c\u6210!");
        cpiv = new CodeProduceInfoDTO();
        BeanUtils.copyProperties((Object)cpib, (Object)cpiv);
        return this.getResponseData(cpiv);
    }

    @GetMapping(value={"/api/code/produce/push/current"})
    @ResponseBody
    public ResponseData<Boolean> currentPathPushToRepo(@RequestParam(value="codePath", required=false) String userThisCodePathId, @RequestParam(value="commitMsg", required=false) String commitMsg, @RequestParam(value="appId") String appId) {
        boolean flag = true;
        String currentUserId = this.getUserInfo().getUserId();
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            return this.getResponseData(null, "", "\u8bf7\u5728\u4e2a\u4eba\u4e2d\u5fc3\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        String gitPassword = userProfile.getGitAccessToken();
        if (StringUtils.isBlank((CharSequence)gitPassword)) {
            gitPassword = userProfile.getGitPassword();
        }
        String gitUser = currentUserId;
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitUsername())) {
            gitUser = userProfile.getGitUsername();
        }
        String userEmail = "admin@unknown.com";
        SUserDTO user = portalClient.querySUserByPk(currentUserId);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
        if (appInfo == null) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String id = userThisCodePathId;
        if (!this.checkAppRepoAndCreate(appInfo, gitUser, userEmail, gitPassword)) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4ed3\u5e93\u68c0\u67e5\u5931\u8d25\uff01");
        }
        String sourcePath = this.codePath + id;
        JGitUtil jGitUtil = new JGitUtil(sourcePath, appInfo.getAppGitUrl(), gitUser, gitPassword);
        try {
            jGitUtil.addAll();
            if (StringUtils.isBlank((CharSequence)commitMsg)) {
                commitMsg = "auto code generate commit on id#" + id;
            }
            jGitUtil.commit(gitUser, userEmail, commitMsg);
            jGitUtil.push(appInfo.getAppGitUrl(), Boolean.valueOf(false));
            jGitUtil.close();
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{userThisCodePathId, appInfo.getAppGitUrl(), e});
            throw new RuntimeException("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38");
        }
        return this.getResponseData(true);
    }

    @GetMapping(value={"/api/code/produce/push"})
    @ResponseBody
    public ResponseData<Boolean> codeProducePushToRepo(@RequestParam(value="produceId", required=false) String produceId, @RequestParam(value="codePath", required=false) String userThisCodePathId, @RequestParam(value="commitMsg", required=false) String commitMsg, @RequestParam(value="userAppId", required=false) Boolean userAppId, @RequestParam(value="appId") String appId) {
        String id;
        boolean flag = true;
        String currentUserId = this.getUserInfo().getUserId();
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            return this.getResponseData(null, "", "\u8bf7\u5728\u4e2a\u4eba\u4e2d\u5fc3\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        String gitPassword = userProfile.getGitAccessToken();
        if (StringUtils.isBlank((CharSequence)gitPassword)) {
            gitPassword = userProfile.getGitPassword();
        }
        String gitUser = currentUserId;
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitUsername())) {
            gitUser = userProfile.getGitUsername();
        }
        String userEmail = "admin@unknown.com";
        SUserDTO user = portalClient.querySUserByPk(currentUserId);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
        if (appInfo == null) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String string = StringUtils.isNotBlank((CharSequence)userThisCodePathId) ? userThisCodePathId : (id = userAppId != false ? appId : produceId);
        if (!this.checkAppRepoAndCreate(appInfo, gitUser, userEmail, gitPassword)) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4ed3\u5e93\u68c0\u67e5\u5931\u8d25\uff01");
        }
        String sourcePath = this.codePath + id;
        String targetPath = this.codePath + id + "-remote";
        String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue();
        JGitUtil jGitUtil = new JGitUtil(targetPath, appInfo.getAppGitUrl(), gitUser, gitPassword);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(targetPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(targetPath, appInfo.getAppGitUrl(), gitUser, gitPassword);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return this.getResponseData(null, "", "\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25\uff01");
                }
            }
        }
        File localProjectDir = new File(sourcePath);
        if (localProjectDir.exists() && localProjectDir.isDirectory()) {
            File[] localSubDir;
            for (File sub : localSubDir = localProjectDir.listFiles()) {
                File target = new File(targetPath, sub.getName());
                if (sub.isDirectory()) {
                    if (sub.getName().equals(".git")) continue;
                    try {
                        FileUtils.copyDirectory((File)sub, (File)target);
                    }
                    catch (IOException e) {
                        logger.error("\u590d\u5236\u4ee3\u7801\u751f\u6210\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, sub.getName(), e});
                    }
                    continue;
                }
                try {
                    FileUtils.copyFile((File)sub, (File)target);
                }
                catch (IOException e) {
                    logger.error("\u590d\u5236\u4ee3\u7801\u751f\u6210\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, sub.getName(), e});
                }
            }
        }
        try {
            jGitUtil.addAll();
            if (StringUtils.isBlank((CharSequence)commitMsg)) {
                commitMsg = "auto code generate commit on id#" + id;
            }
            jGitUtil.commit(gitUser, userEmail, commitMsg);
            jGitUtil.push(appInfo.getAppGitUrl(), Boolean.valueOf(false));
            jGitUtil.close();
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, appInfo.getAppGitUrl(), e});
        }
        return this.getResponseData(true);
    }

    private boolean checkAppRepoAndCreate(PaasAppsInfoDTO appInfo, String gitUser, String userEmail, String gitPassword) {
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String gitHostUrl = paasEnvParamService.queryEnvParamByCodeReturnValue("git.host.url").getParamValue();
        String pushUrl = appInfo.getAppGitUrl();
        if (pushUrl.endsWith("/")) {
            pushUrl = pushUrl.substring(0, pushUrl.length() - 1);
        }
        String projectName = pushUrl.substring(pushUrl.lastIndexOf("/"));
        String group = pushUrl.replace(projectName, "");
        group = group.substring(group.lastIndexOf("/") + 1);
        projectName = projectName.replace(".git", "").substring(1);
        String currentUserId = gitUser;
        logger.info("\u5f53\u524d\u7528\u6237\uff1a " + currentUserId);
        GitLabApi gitLabApi = new GitLabApi(gitHostUrl, gitPassword);
        User gitUserInfo = null;
        try {
            gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        if (gitUserInfo == null) {
            gitUserInfo = new User();
            gitUserInfo.setName(currentUserId);
            gitUserInfo.setUsername(currentUserId);
            gitUserInfo.setEmail(userEmail);
            try {
                gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
            }
            catch (GitLabApiException gitLabApiException) {
                // empty catch block
            }
        }
        GroupApi groupApi = gitLabApi.getGroupApi();
        Group namespace = null;
        try {
            namespace = groupApi.getGroup((Object)group);
        }
        catch (GitLabApiException e) {
            logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
            namespace = null;
        }
        if (namespace == null) {
            try {
                GroupParams createGroupParam = new GroupParams();
                createGroupParam.withName(group);
                createGroupParam.withPath(group);
                createGroupParam.withDescription(appInfo.getSubsName());
                namespace = groupApi.createGroup(createGroupParam);
                logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                try {
                    Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException member) {}
            }
            catch (GitLabApiException e) {
                logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                return false;
            }
        }
        ProjectApi prjApi = gitLabApi.getProjectApi();
        Project prj = null;
        try {
            prj = prjApi.getProject(group, projectName);
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        if (prj == null || prj.getId() == null || prj.getId() < 0L) {
            prj = new Project();
            prj.setName(projectName);
            prj.setPath(projectName);
            prj.setDescription(appInfo.getAppName());
            Project newPrj = null;
            try {
                newPrj = prjApi.createProject(namespace.getId(), prj);
            }
            catch (GitLabApiException gitLabApiException) {
                // empty catch block
            }
            if (newPrj != null) {
                logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                try {
                    Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException gitLabApiException) {}
            } else {
                logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                return false;
            }
            return true;
        }
        logger.info("\u4ed3\u5e93\u5df2\u5b58\u5728");
        try {
            Member member = prjApi.addMember((Object)prj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
            if (member != null) {
                logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
            }
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        return true;
    }

    private void copyGenProjectStructure(String produceId, String templateId, String appCode, String package_prefix) {
        try {
            String outFilePath = this.codePath + produceId;
            String srcFilePath = this.templatePath + File.separator + templateId + File.separator + templateId + "-project";
            String replaceStr = appCode;
            String srcStr = templateId + "-template";
            HashMap<String, String> expRoot = new HashMap<String, String>();
            expRoot.put("appCode", appCode);
            String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
            String replacePackage = package_prefix + "." + newAppCode;
            logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s...", srcFilePath, outFilePath));
            srcFilePath = new File(srcFilePath).getAbsolutePath();
            outFilePath = new File(outFilePath).getAbsolutePath();
            ReplaceDirAndFileBean rdfb = new ReplaceDirAndFileBean(srcFilePath, outFilePath, srcStr, replaceStr);
            rdfb.addFileReplacePattern(new FileReplacePattern("*", templateId + "-template".replace(".", "-"), replaceStr.replaceAll("_|\\.", "-")));
            rdfb.addFileReplacePattern(new FileReplacePattern("*", "xxxxx", replacePackage, "fileContent"));
            rdfb.setIgnorePostfix("html,css,js");
            rdfb.execute();
            logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s\u5b8c\u6210!", srcFilePath, outFilePath));
            String newDirPath = StringUtils.replace((String)replacePackage, (String)".", (String)File.separator);
            File targetFile = new File(outFilePath);
            this.replaceMultipleDir(targetFile, "xxxxx", newDirPath);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6a21\u677f\u5de5\u7a0b\u7ed3\u6784\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
    }

    private void replaceMultipleDir(File root, String srcStr, String targetStr) throws Exception {
        if (root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git") || !subFile.isDirectory()) continue;
                if (StringUtils.equals((CharSequence)srcStr, (CharSequence)subFile.getName())) {
                    File[] list;
                    File newDir = new File(root, targetStr);
                    newDir.mkdirs();
                    for (File f : list = subFile.listFiles()) {
                        FileUtils.moveDirectoryToDirectory((File)f, (File)newDir, (boolean)false);
                    }
                    FileUtils.deleteQuietly((File)subFile);
                    subFile = newDir;
                }
                this.replaceMultipleDir(subFile, srcStr, targetStr);
            }
        }
    }

    public class BatchGenerateCodeTask
    implements Callable<ExecuteRtnInfo> {
        private List<CodeProduceInfoDTO> sub;
        private String userId;
        private String producePath;
        private boolean fnFlag;

        public BatchGenerateCodeTask(List<CodeProduceInfoDTO> sub, String userId, String producePath, boolean fnFlag) {
            this.sub = sub;
            this.userId = userId;
            this.producePath = producePath;
            this.fnFlag = fnFlag;
        }

        @Override
        public ExecuteRtnInfo call() throws Exception {
            int count = 0;
            for (CodeProduceInfoDTO config : this.sub) {
                ResponseData<CodeProduceLogDTO> re = ApiForCodeProduceController.this.codeProduce(config.getModelTableId(), config.getCodeTemplateId(), config.getProduceId(), this.producePath, true, "T", this.fnFlag, this.userId);
                if (((CodeProduceLogDTO)re.getRows()).getProduceState() != 0) continue;
                ++count;
            }
            return null;
        }
    }
}

