/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppResourceDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="appResourceController")
@RequestMapping(value={"/"})
public class AppResourceController
extends BaseController<AppResourceDTO, AppResourceService> {
    @RequestMapping(value={"/api/app/resources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<AppResourceDTO>> queryAppResourceAll(AppResourceDTO vo) {
        List outputVo = ((AppResourceService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/app/resources/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<AppResourceDTO>> queryAllNotPage(AppResourceDTO vo) {
        List outputVo = ((AppResourceService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/app/resource/{resourceid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<AppResourceDTO> queryByPk(@PathVariable(value="resourceid") String resourceid, @RequestParam(value="appId") String appId) {
        AppResourceDTO inVo = new AppResourceDTO();
        inVo.setResourceid(new String(resourceid));
        inVo.setAppId(appId);
        AppResourceDTO outputVo = (AppResourceDTO)((AppResourceService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/app/resource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody AppResourceDTO inAppResourceVo) {
        int outputVo = ((AppResourceService)this.getService()).deleteByPk((Object)inAppResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/app/resource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody AppResourceDTO inAppResourceVo) {
        int outputVo = ((AppResourceService)this.getService()).updateByPk((Object)inAppResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/app/resource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertAppResource(@RequestBody AppResourceDTO inAppResourceVo) {
        int outputVo = ((AppResourceService)this.getService()).insert((Object)inAppResourceVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/app/resource/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="appId") String appId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        try {
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), AppResourceItem.class, (ReadListener)listener).sheet().doRead();
            List<AppResourceDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    ((AppResourceService)this.getService()).deleteByAppId(appId);
                }
                list.stream().forEach(el -> el.setAppId(appId));
                ((AppResourceService)this.getService()).batchInsert(list);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u83dc\u5355\u6e05\u5355\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    public static class AppResourceItem {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private Integer orderid;
        @ExcelProperty(value={"\u8d44\u6e90ID"})
        private String resourceid;
        @ExcelProperty(value={"\u8d44\u6e90\u540d\u79f0"})
        private String cnname;
        @ExcelProperty(value={"\u8d44\u6e90url"})
        private String url;
        @ExcelProperty(value={"\u4e0a\u7ea7\u8d44\u6e90ID"})
        private String parentid;
        @ExcelProperty(value={"\u8d44\u6e90\u56fe\u6807"})
        private String icon;

        public Integer getOrderid() {
            return this.orderid;
        }

        public void setOrderid(Integer orderid) {
            this.orderid = orderid;
        }

        public String getResourceid() {
            return this.resourceid;
        }

        public void setResourceid(String resourceid) {
            this.resourceid = resourceid;
        }

        public String getCnname() {
            return this.cnname;
        }

        public void setCnname(String cnname) {
            this.cnname = cnname;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getParentid() {
            return this.parentid;
        }

        public void setParentid(String parentid) {
            this.parentid = parentid;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }
    }

    public static class AppResourceItemListener
    extends AnalysisEventListener<AppResourceItem> {
        private List<AppResourceDTO> list = new ArrayList<AppResourceDTO>();

        public List<AppResourceDTO> getList() {
            return this.list;
        }

        public void invoke(AppResourceItem data, AnalysisContext context) {
            AppResourceDTO vo = new AppResourceDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

