/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.BpmModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.BpmModelInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class BpmModelInfoController
extends BaseController<BpmModelInfoDTO, BpmModelInfoService> {
    @RequestMapping(value={"/api/bpm/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpmModelInfoDTO>> queryBpmModelInfoAll(BpmModelInfoDTO dto) {
        List outputVo = ((BpmModelInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bpm/model/info/{bpmModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpmModelInfoDTO> queryByPk(@PathVariable(value="bpmModelId") String bpmModelId) {
        BpmModelInfoDTO inVo = new BpmModelInfoDTO();
        inVo.setBpmModelId(bpmModelId);
        BpmModelInfoDTO outputVo = (BpmModelInfoDTO)((BpmModelInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bpm/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpmModelInfoDTO inBpmModelInfoDTO) {
        int outputVo = ((BpmModelInfoService)this.getService()).deleteByPk((Object)inBpmModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bpm/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpmModelInfoDTO inBpmModelInfoDTO) {
        this.setUserInfoToVO(inBpmModelInfoDTO);
        inBpmModelInfoDTO.setLastUpdateUser(inBpmModelInfoDTO.getLoginUserId());
        inBpmModelInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((BpmModelInfoService)this.getService()).updateByPk((Object)inBpmModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bpm/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpmModelInfo(@RequestBody BpmModelInfoDTO inBpmModelInfoDTO) {
        this.setUserInfoToVO(inBpmModelInfoDTO);
        inBpmModelInfoDTO.setCreateUser(inBpmModelInfoDTO.getLoginUserId());
        inBpmModelInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inBpmModelInfoDTO.setLastUpdateUser(inBpmModelInfoDTO.getLoginUserId());
        inBpmModelInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((CharSequence)inBpmModelInfoDTO.getBpmModelId())) {
            inBpmModelInfoDTO.setBpmModelId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((BpmModelInfoService)this.getService()).insert((Object)inBpmModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bpm/model/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<BpmModelInfoDTO> validate(@RequestBody BpmModelInfoDTO dto) {
        dto = (BpmModelInfoDTO)((BpmModelInfoService)this.getService()).queryByPk((Object)dto);
        boolean flag = ((BpmModelInfoService)this.getService()).validate(dto);
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/bpm/model/info/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody BpmModelInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = ((BpmModelInfoService)this.getService()).queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }
}

