/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinapaas.portal.console.facade.PaasTaskHisService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskHisDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelRefactorDTO;
import com.irdstudio.allinrdm.dev.console.types.FormState;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FormModelInfoController
extends BaseController<FormModelInfoDTO, FormModelInfoService> {
    @Autowired
    private PaasTaskHisService paasTaskHisService;
    private static ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();

    @RequestMapping(value={"/api/form/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FormModelInfoDTO>> queryFormModelInfoAll(FormModelInfoDTO dto) {
        this.setUserInfoToVO(dto);
        if (StringUtils.contains((CharSequence)dto.getAppId(), (CharSequence)",")) {
            dto.setAppIdList(Arrays.asList(StringUtils.split((String)dto.getAppId(), (String)",")));
            dto.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getComId(), (CharSequence)",")) {
            dto.setComIdList(Arrays.asList(StringUtils.split((String)dto.getComId(), (String)",")));
            dto.setComId(null);
        }
        List outputVo = ((FormModelInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FormModelInfoDTO>> queryList(FormModelInfoDTO dto) {
        this.setUserInfoToVO(dto);
        List outputVo = ((FormModelInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/info/{formId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FormModelInfoDTO> queryByPk(@PathVariable(value="formId") String formId) {
        FormModelInfoDTO inVo = new FormModelInfoDTO();
        inVo.setFormId(formId);
        FormModelInfoDTO outputVo = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/info/max/order"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> queryMaxOrder() {
        Integer outputVo = ((FormModelInfoService)this.getService()).queryMaxOrder();
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FormModelInfoDTO inFormModelInfoDTO) {
        int outputVo = ((FormModelInfoService)this.getService()).deleteByPk((Object)inFormModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FormModelInfoDTO inFormModelInfoDTO) {
        this.setUserInfoToVO(inFormModelInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inFormModelInfoDTO.setLastModifyUser(inFormModelInfoDTO.getLoginUserId());
        inFormModelInfoDTO.setLastModifyTime(now);
        int outputVo = ((FormModelInfoService)this.getService()).updateByPk((Object)inFormModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertFormModelInfo(@RequestBody FormModelInfoDTO inFormModelInfoDTO) {
        this.setUserInfoToVO(inFormModelInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inFormModelInfoDTO.setCreateUser(inFormModelInfoDTO.getLoginUserId());
        inFormModelInfoDTO.setCreateTime(now);
        inFormModelInfoDTO.setLastModifyUser(inFormModelInfoDTO.getLoginUserId());
        inFormModelInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inFormModelInfoDTO.getFormId())) {
            inFormModelInfoDTO.setFormId(UUIDUtil.getUUID());
        }
        inFormModelInfoDTO.setFormState(FormState.CreatedForm.getCode());
        int outputVo = ((FormModelInfoService)this.getService()).insert((Object)inFormModelInfoDTO);
        return this.getResponseData(inFormModelInfoDTO.getFormId());
    }

    @RequestMapping(value={"/api/form/model/info/initfn"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> formInitFn(@RequestBody FormModelInfoDTO inFormModelInfoDTO) {
        this.setUserInfoToVO(inFormModelInfoDTO);
        int outputVo = ((FormModelInfoService)this.getService()).formInitFn(inFormModelInfoDTO);
        return this.getResponseData(inFormModelInfoDTO.getFormId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/form/model/info/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> batchCreateForm(@RequestBody FormModelInfoDTO inFormModelInfoDTO, @RequestParam(value="allSelected") String allSelected, @RequestParam(value="key") String key) {
        try {
            taskDebounce.put(key, true);
            this.setUserInfoToVO(inFormModelInfoDTO);
            int outputVo = ((FormModelInfoService)this.getService()).batchCreateForm(inFormModelInfoDTO, allSelected);
            ResponseData responseData = this.getResponseData(outputVo);
            return responseData;
        }
        finally {
            taskDebounce.put(key, false);
        }
    }

    @RequestMapping(value={"/api/form/model/info/batch/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> batchCreateFormStat(@RequestParam(value="key") String key) {
        return this.getResponseData(String.valueOf(taskDebounce.get(key)));
    }

    @RequestMapping(value={"/api/form/model/info/generate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> generateFormCode(@RequestBody FormModelInfoDTO inFormModelInfoDTO) {
        FormModelInfoDTO modelInfo = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)inFormModelInfoDTO);
        PaasTaskHisDTO genLog = new PaasTaskHisDTO();
        genLog.setTaskHisId(UUIDUtil.getShortUUID());
        genLog.setTaskId(genLog.getTaskHisId());
        genLog.setTaskName(modelInfo.getFormName() + "\u529f\u80fd\u4ee3\u7801\u751f\u6210");
        genLog.setTaskType("E01001");
        genLog.setTaskCategory("E");
        genLog.setTaskState("1");
        genLog.setSubsId(inFormModelInfoDTO.getSubsId());
        genLog.setAppId(inFormModelInfoDTO.getAppId());
        Date startDate = new Date();
        genLog.setStartTime(CurrentDateUtil.getTodayDateEx2());
        genLog.setCreateUser(this.getUserInfo().getUserId());
        genLog.setLastUpdateUser(this.getUserInfo().getUserId());
        genLog.setModuleId(modelInfo.getModuleId());
        genLog.setModuleName(modelInfo.getModuleName());
        genLog.setObjectKey(modelInfo.getFormId());
        genLog.setObjectName(modelInfo.getFormName());
        boolean outputVo = true;
        try {
            taskDebounce.put("gen" + inFormModelInfoDTO.getFormId(), true);
            this.setUserInfoToVO(inFormModelInfoDTO);
            FileUtils.deleteQuietly((File)new File(SdEnvUtil.PROJECT_PATH, inFormModelInfoDTO.getFormId()));
            outputVo = ((FormModelInfoService)this.getService()).generateFormCode(inFormModelInfoDTO);
            genLog.setTaskState(String.valueOf(6));
        }
        catch (Exception e) {
            genLog.setTaskState(String.valueOf(7));
            genLog.setTaskErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)290));
            throw e;
        }
        finally {
            taskDebounce.put("gen" + inFormModelInfoDTO.getFormId(), false);
            Date endData = new Date();
            genLog.setEndTime(CurrentDateUtil.getTodayDateEx2());
            genLog.setLastUpdateTime(genLog.getEndTime());
            long costTime = endData.getTime() - startDate.getTime();
            BigDecimal re = new BigDecimal(costTime).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
            genLog.setCostTime(re);
            this.paasTaskHisService.insert((Object)genLog);
        }
        return this.getResponseData(String.valueOf(outputVo));
    }

    @RequestMapping(value={"/api/form/model/info/generate/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> generateFormCodeStat(@RequestParam(value="formId") String formId) {
        return this.getResponseData(String.valueOf(taskDebounce.get("gen" + formId)));
    }

    @RequestMapping(value={"/client/FormModelInfoService/generateFormCode"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean generateFormCode_client(@RequestBody FormModelInfoDTO paramDTO) {
        return ((FormModelInfoService)this.getService()).generateFormCode(paramDTO);
    }

    @RequestMapping(value={"/api/form/model/info/gen/refactor"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> generateRefactor(@RequestBody FormModelInfoDTO paramDTO) {
        FormModelInfoDTO formInfo = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)paramDTO);
        this.setUserInfoToVO(formInfo);
        boolean flag = ((FormModelInfoService)this.getService()).generateRefactor(formInfo);
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/api/form/model/info/refactor"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> refactorFormModel(@RequestParam(value="formId") String formId, @RequestBody List<FormModelRefactorDTO> refactorList) {
        FormModelInfoDTO formInfo = new FormModelInfoDTO();
        formInfo.setFormId(formId);
        formInfo = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)formInfo);
        this.setUserInfoToVO(formInfo);
        boolean flag = ((FormModelInfoService)this.getService()).refactorFormModel(formInfo, refactorList);
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/api/form/model/info/change/belong/deletes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBeLongDeleteFiles(FormModelInfoDTO dto) {
        File formDir;
        dto = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)dto);
        if (dto != null && (formDir = new File(SdEnvUtil.PROJECT_PATH, dto.getFormId())).exists()) {
            List files = FileUtil.getDirAllFile((File)formDir);
            ArrayList result = new ArrayList();
            files.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filePath", f.getAbsolutePath().replaceFirst(formDir.getAbsolutePath(), "").replaceAll(File.separator, "/"));
                map.put("fileName", f.getName());
                result.add(map);
            });
            if (CollectionUtils.isNotEmpty(result)) {
                Map map = (Map)result.get(0);
                map.put("total", result.size());
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(Collections.emptyList());
    }

    @RequestMapping(value={"/api/form/model/info/change/belong/deletes/confirm"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<String> beLongDeleteFilesConfirm(@RequestBody FormModelInfoDTO dto) {
        File formDir;
        dto = (FormModelInfoDTO)((FormModelInfoService)this.getService()).queryByPk((Object)dto);
        if (dto != null && (formDir = new File(SdEnvUtil.PROJECT_PATH, dto.getFormId())).exists()) {
            List files = FileUtil.getDirAllFile((File)formDir);
            FileUtils.deleteQuietly((File)formDir);
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(dto.getAppId());
            appRepoPullTask.syncRun();
            String appPath = appRepoPullTask.getAppPath();
            try {
                Files.move(new File(appPath).toPath(), formDir.toPath(), new CopyOption[0]);
                for (File deleteFile : files) {
                    if (!deleteFile.exists()) continue;
                    FileUtils.deleteQuietly((File)deleteFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getResponseData("\u64cd\u4f5c\u6210\u529f");
    }
}

