/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.FormModelSubformService;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelSubformDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FormModelSubformController
extends BaseController<FormModelSubformDTO, FormModelSubformService> {
    @RequestMapping(value={"/api/form/model/subforms"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FormModelSubformDTO>> queryFormModelSubformAll(FormModelSubformDTO dto) {
        List outputVo = ((FormModelSubformService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/subform/{formId}/{subformId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FormModelSubformDTO> queryByPk(@PathVariable(value="formId") String formId, @PathVariable(value="subformId") String subformId) {
        FormModelSubformDTO inVo = new FormModelSubformDTO();
        inVo.setFormId(formId);
        inVo.setSubformId(subformId);
        FormModelSubformDTO outputVo = (FormModelSubformDTO)((FormModelSubformService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/subform"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FormModelSubformDTO inFormModelSubformDTO) {
        int outputVo = ((FormModelSubformService)this.getService()).deleteByPk((Object)inFormModelSubformDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/subform"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FormModelSubformDTO inFormModelSubformDTO) {
        this.setUserInfoToVO(inFormModelSubformDTO);
        inFormModelSubformDTO.setLastModifyUser(inFormModelSubformDTO.getLoginUserId());
        inFormModelSubformDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((FormModelSubformService)this.getService()).updateByPk((Object)inFormModelSubformDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/subform"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFormModelSubform(@RequestBody FormModelSubformDTO inFormModelSubformDTO) {
        this.setUserInfoToVO(inFormModelSubformDTO);
        inFormModelSubformDTO.setCreateUser(inFormModelSubformDTO.getLoginUserId());
        inFormModelSubformDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inFormModelSubformDTO.setLastModifyUser(inFormModelSubformDTO.getLoginUserId());
        inFormModelSubformDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((FormModelSubformService)this.getService()).insert((Object)inFormModelSubformDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/model/subform/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSubformList(@RequestBody List<FormModelSubformDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String userId = this.getUserInfo().getUserId();
            String now = CurrentDateUtil.getTodayDateEx2();
            for (FormModelSubformDTO subform : list) {
                this.setUserInfoToVO(subform);
                subform.setCreateUser(userId);
                subform.setCreateTime(now);
                subform.setLastModifyUser(userId);
                subform.setLastModifyTime(now);
                outputVo += ((FormModelSubformService)this.getService()).insert((Object)subform);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/FormModelSubformService/deleteByFormId"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByFormId(@RequestParam(value="formId") String formId) {
        return ((FormModelSubformService)this.getService()).deleteByFormId(formId);
    }
}

