/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeSectionService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeTableService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelValidateService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeSectionDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeSubmitDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeTableDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelValidateDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.SectionType;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class OsrvArrangeSectionController
extends BaseController<OsrvArrangeSectionDTO, OsrvArrangeSectionService> {
    @Autowired
    @Qualifier(value="osrvArrangeTableServiceImpl")
    private OsrvArrangeTableService osrvArrangeTableService;
    @Autowired
    @Qualifier(value="srvModelValidateServiceImpl")
    private SrvModelValidateService srvModelValidateService;

    @RequestMapping(value={"/api/osrv/arrange/sections"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeSectionDTO>> queryOsrvArrangeSectionAll(OsrvArrangeSectionDTO vo) {
        List outputVo = ((OsrvArrangeSectionService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/sections/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeSectionDTO>> queryOsrvArrangeSectionAllNotPage(OsrvArrangeSectionDTO vo) {
        List outputVo = ((OsrvArrangeSectionService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/section/{sectionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<OsrvArrangeSectionDTO> queryByPk(@PathVariable(value="sectionId") String sectionId) {
        OsrvArrangeSectionDTO inVo = new OsrvArrangeSectionDTO();
        inVo.setSectionId(sectionId);
        OsrvArrangeSectionDTO outputVo = (OsrvArrangeSectionDTO)((OsrvArrangeSectionService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/section"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody OsrvArrangeSectionDTO inOsrvArrangeSectionVo) {
        int outputVo = ((OsrvArrangeSectionService)this.getService()).deleteByPk((Object)inOsrvArrangeSectionVo);
        if (StringUtils.isBlank((CharSequence)inOsrvArrangeSectionVo.getSectionId())) {
            return this.getResponseData(outputVo);
        }
        OsrvArrangeTableDTO deleteTable = new OsrvArrangeTableDTO();
        deleteTable.setSectionId(inOsrvArrangeSectionVo.getSectionId());
        deleteTable.setSrvModelId(inOsrvArrangeSectionVo.getSrvModelId());
        List tableList = this.osrvArrangeTableService.queryList((Object)deleteTable);
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (OsrvArrangeTableDTO delTb : tableList) {
                outputVo += this.osrvArrangeTableService.deleteByPk((Object)delTb);
            }
        }
        if (StringUtils.equals((CharSequence)SectionType.ValidSection.getCode(), (CharSequence)inOsrvArrangeSectionVo.getSectionType())) {
            SrvModelValidateDTO delValidParam = new SrvModelValidateDTO();
            delValidParam.setSectionId(inOsrvArrangeSectionVo.getSectionId());
            List delValidateList = this.srvModelValidateService.queryList((Object)delValidParam);
            if (CollectionUtils.isNotEmpty((Collection)delValidateList)) {
                for (SrvModelValidateDTO validate : delValidateList) {
                    outputVo += this.srvModelValidateService.deleteByPk((Object)validate);
                }
            }
        }
        OsrvArrangeSectionDTO childSection = new OsrvArrangeSectionDTO();
        childSection.setSectionAbvId(inOsrvArrangeSectionVo.getSectionId());
        List childList = ((OsrvArrangeSectionService)this.getService()).queryList((Object)childSection);
        if (CollectionUtils.isNotEmpty((Collection)childList)) {
            for (OsrvArrangeSectionDTO child : childList) {
                ResponseData<Integer> childResp = this.deleteByPk(child);
                outputVo += ((Integer)childResp.getRows()).intValue();
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/section"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody OsrvArrangeSectionDTO inOsrvArrangeSectionVo) {
        int outputVo = ((OsrvArrangeSectionService)this.getService()).updateByPk((Object)inOsrvArrangeSectionVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/section"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertOsrvArrangeSection(@RequestBody OsrvArrangeSectionDTO inOsrvArrangeSectionVo) {
        int outputVo;
        if (StringUtils.isBlank((CharSequence)inOsrvArrangeSectionVo.getSectionId())) {
            inOsrvArrangeSectionVo.setSectionId(UUIDUtil.getUUID());
        }
        if ((outputVo = ((OsrvArrangeSectionService)this.getService()).updateByPk((Object)inOsrvArrangeSectionVo)) == 0) {
            outputVo = ((OsrvArrangeSectionService)this.getService()).insert((Object)inOsrvArrangeSectionVo);
        }
        return this.getResponseData(inOsrvArrangeSectionVo.getSectionId());
    }

    @RequestMapping(value={"/api/osrv/arrange/section/query"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<OsrvArrangeSubmitDTO> queryOsrv(@RequestBody OsrvArrangeSubmitDTO queryData) {
        String appId = queryData.getAppId();
        String srvModelId = queryData.getSrvModelId();
        OsrvArrangeSectionDTO sectionParam = new OsrvArrangeSectionDTO();
        sectionParam.setSrvModelId(srvModelId);
        List sectionList = ((OsrvArrangeSectionService)this.getService()).queryList((Object)sectionParam);
        queryData.setSectionList(sectionList);
        OsrvArrangeTableDTO tableParam = new OsrvArrangeTableDTO();
        tableParam.setSrvModelId(srvModelId);
        List tables = this.osrvArrangeTableService.queryList((Object)tableParam);
        queryData.setTableList(tables);
        SrvModelValidateDTO validParam = new SrvModelValidateDTO();
        validParam.setSrvModelId(queryData.getSrvModelId());
        List validateList = this.srvModelValidateService.queryList((Object)validParam);
        queryData.setValidateList(validateList);
        return this.getResponseData(queryData);
    }

    @RequestMapping(value={"/api/osrv/arrange/section/save"}, method={RequestMethod.POST})
    @AppDevLogAnno(action=LogAction.Update, desc="\u670d\u52a1\u7f16\u6392\u8868\u683c\u4fdd\u5b58 ${args[0].srvModelId}", appId="${args[0].appId}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Boolean> saveOsrv(@RequestBody OsrvArrangeSubmitDTO submitData) {
        boolean flag = true;
        try {
            String appId = submitData.getAppId();
            String srvModelId = submitData.getSrvModelId();
            flag = ((OsrvArrangeSectionService)this.getService()).saveSectionList(appId, srvModelId, submitData.getSectionList());
            if (flag) {
                flag = this.osrvArrangeTableService.saveTableList(appId, srvModelId, submitData.getTableList());
            }
            if (flag) {
                flag = this.srvModelValidateService.saveValidateList(appId, srvModelId, submitData.getValidateList());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            flag = false;
        }
        return this.getResponseData(flag);
    }
}

