/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeSectionService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeVarDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class OsrvArrangeVarController
extends BaseController<OsrvArrangeVarDTO, OsrvArrangeVarService> {
    @Autowired
    @Qualifier(value="osrvArrangeSectionServiceImpl")
    private OsrvArrangeSectionService osrvArrangeSectionService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="srvModelInoutServiceImpl")
    private SrvModelInoutService srvModelInoutService;

    @RequestMapping(value={"/api/osrv/arrange/vars"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeVarDTO>> queryOsrvArrangeVarAll(OsrvArrangeVarDTO vo) {
        if (StringUtils.contains((CharSequence)vo.getDomainVarType(), (CharSequence)",")) {
            vo.setDomainVarTypes(Arrays.asList(StringUtils.split((String)vo.getDomainVarType(), (String)",")));
            vo.setDomainVarType(null);
        }
        List outputVo = ((OsrvArrangeVarService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/var/{domainVarId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<OsrvArrangeVarDTO> queryByPk(@PathVariable(value="domainVarId") String domainVarId) {
        OsrvArrangeVarDTO inVo = new OsrvArrangeVarDTO();
        inVo.setDomainVarId(domainVarId);
        OsrvArrangeVarDTO outputVo = (OsrvArrangeVarDTO)((OsrvArrangeVarService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/var"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody OsrvArrangeVarDTO inOsrvArrangeVarVo) {
        int outputVo = ((OsrvArrangeVarService)this.getService()).deleteByPk((Object)inOsrvArrangeVarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/var/tableModelId"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByTableModelId(@RequestBody OsrvArrangeVarDTO inOsrvArrangeVarVo) {
        List list = ((OsrvArrangeVarService)this.getService()).queryList((Object)inOsrvArrangeVarVo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            int outputVo = 0;
            for (OsrvArrangeVarDTO var : list) {
                outputVo += ((OsrvArrangeVarService)this.getService()).deleteByPk((Object)var);
            }
            return this.getResponseData(outputVo);
        }
        return this.getResponseData(0);
    }

    @RequestMapping(value={"/api/osrv/arrange/var"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody OsrvArrangeVarDTO inOsrvArrangeVarVo) {
        int outputVo = ((OsrvArrangeVarService)this.getService()).updateByPk((Object)inOsrvArrangeVarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/var"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertOsrvArrangeVar(@RequestBody OsrvArrangeVarDTO inOsrvArrangeVarVo) {
        if (StringUtils.isBlank((CharSequence)inOsrvArrangeVarVo.getDomainVarId())) {
            inOsrvArrangeVarVo.setDomainVarId(UUIDUtil.getUUID());
        }
        int outputVo = ((OsrvArrangeVarService)this.getService()).insert((Object)inOsrvArrangeVarVo);
        return this.getResponseData(inOsrvArrangeVarVo.getDomainVarId());
    }

    @RequestMapping(value={"/api/osrv/arrange/var/d"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeVarDTO>> insertOsrvArrangeVarDReturnList(@RequestParam(value="rowOpTargetId") String rowOpTargetId, @RequestBody OsrvArrangeVarDTO inOsrvArrangeVarVo) {
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(rowOpTargetId);
        inoutParam.setIoType(IOType.Output.getCode());
        List srvModelOutputs = this.srvModelInoutService.queryList((Object)inoutParam);
        if (CollectionUtils.isNotEmpty((Collection)srvModelOutputs)) {
            for (int i = 0; i < srvModelOutputs.size(); ++i) {
                SrvModelInoutDTO inout = (SrvModelInoutDTO)srvModelOutputs.get(i);
                if (StringUtils.isBlank((CharSequence)inout.getTableModelName())) {
                    ModelTableInfoDTO tbParam = new ModelTableInfoDTO();
                    tbParam.setObjectId(inout.getTableModelId());
                    tbParam = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tbParam);
                    inout.setTableModelName(tbParam.getObjectName());
                }
                OsrvArrangeVarDTO checkParam = new OsrvArrangeVarDTO();
                checkParam.setSrvModelId(inOsrvArrangeVarVo.getSrvModelId());
                checkParam.setTableModelId(inout.getTableModelId());
                checkParam.setDomainVarType(DomainVarType.Var.getCode());
                checkParam.setTableRowId(inOsrvArrangeVarVo.getTableRowId());
                List checkList = ((OsrvArrangeVarService)this.getService()).queryListByPage((Object)checkParam);
                if (CollectionUtils.isEmpty((Collection)checkList)) {
                    inOsrvArrangeVarVo.setDomainVarId(UUIDUtil.getUUID());
                    inOsrvArrangeVarVo.setDomainVarCode(String.format("%s%s", inout.getTableModelCode(), inOsrvArrangeVarVo.getTableRowNo()));
                    inOsrvArrangeVarVo.setDomainVarName(String.format("[%s] [\u5e8f\u53f7%s\u51fa\u53c2]", inout.getTableModelName(), inOsrvArrangeVarVo.getTableRowNo()));
                    inOsrvArrangeVarVo.setTableModelId(inout.getTableModelId());
                    inOsrvArrangeVarVo.setListFlag(inout.getListFlag());
                    ((OsrvArrangeVarService)this.getService()).insert((Object)inOsrvArrangeVarVo);
                    continue;
                }
                OsrvArrangeVarDTO updateObj = (OsrvArrangeVarDTO)checkList.get(0);
                updateObj.setTableRowId(inOsrvArrangeVarVo.getTableRowId());
                updateObj.setDomainVarCode(String.format("%s%s", inout.getTableModelCode(), inOsrvArrangeVarVo.getTableRowNo()));
                updateObj.setDomainVarName(String.format("[%s] [\u5e8f\u53f7%s\u51fa\u53c2]", inout.getTableModelName(), inOsrvArrangeVarVo.getTableRowNo()));
                updateObj.setTableModelId(inout.getTableModelId());
                updateObj.setListFlag(inout.getListFlag());
                ((OsrvArrangeVarService)this.getService()).updateByPk((Object)updateObj);
            }
        }
        OsrvArrangeVarDTO param = new OsrvArrangeVarDTO();
        param.setSrvModelId(inOsrvArrangeVarVo.getSrvModelId());
        List outputVo = ((OsrvArrangeVarService)this.getService()).queryList((Object)param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/allvars"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySrvModelAllVars(@RequestParam(value="srvModelId") String srvModelId, @RequestParam(name="listFlag", required=false) String listFlag, @RequestParam(name="queryTb", required=false, defaultValue="false") Boolean queryTb) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        OsrvArrangeVarDTO varParam = new OsrvArrangeVarDTO();
        varParam.setSrvModelId(srvModelId);
        if (StringUtils.isNotBlank((CharSequence)listFlag)) {
            varParam.setListFlag(listFlag);
        }
        List vars = ((OsrvArrangeVarService)this.getService()).queryAllVars(varParam);
        ArrayList<OsrvArrangeVarDTO> inputs = new ArrayList<OsrvArrangeVarDTO>();
        ArrayList<OsrvArrangeVarDTO> outputs = new ArrayList<OsrvArrangeVarDTO>();
        ArrayList<OsrvArrangeVarDTO> dvars = new ArrayList<OsrvArrangeVarDTO>();
        ArrayList<OsrvArrangeVarDTO> middels = new ArrayList<OsrvArrangeVarDTO>();
        HashMap<String, List> fieldsMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)vars)) {
            for (OsrvArrangeVarDTO v : vars) {
                if (v.getDomainVarType().equals(DomainVarType.Input.getCode())) {
                    inputs.add(v);
                } else if (v.getDomainVarType().equals(DomainVarType.Output.getCode())) {
                    outputs.add(v);
                } else if (v.getDomainVarType().equals(DomainVarType.Var.getCode())) {
                    dvars.add(v);
                } else if (v.getDomainVarType().equals(DomainVarType.MiddleVar.getCode())) {
                    middels.add(v);
                }
                if (!queryTb.booleanValue() || !StringUtils.isNotBlank((CharSequence)v.getTableModelId())) continue;
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(v.getTableModelId());
                List fields = this.modelTableFieldService.queryList((Object)fieldParam);
                fieldsMap.put(v.getTableModelId(), fields);
            }
        }
        result.put(DomainVarType.Input.getCode(), inputs);
        result.put(DomainVarType.Output.getCode(), outputs);
        result.put(DomainVarType.Var.getCode(), dvars);
        result.put(DomainVarType.MiddleVar.getCode(), middels);
        result.put("fields", fieldsMap);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/osrv/arrange/var/fields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> querySrvModelAllVars(@RequestBody OsrvArrangeVarDTO varVO) {
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(varVO.getTableModelId());
        List fields = this.modelTableFieldService.queryList((Object)fieldParam);
        return this.getResponseData(fields);
    }

    @RequestMapping(value={"/api/osrv/arrange/vars/without/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeVarDTO>> queryOsrvArrangeVarWithoutPage(@RequestBody OsrvArrangeVarDTO vo) {
        List outputVo = ((OsrvArrangeVarService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }
}

