/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageModelPackageController
extends BaseController<PageModelPackageDTO, PageModelPackageService> {
    @RequestMapping(value={"/api/page/model/packages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageModelPackageDTO>> queryPageModelPackageAll(PageModelPackageDTO vo) {
        List outputVo = ((PageModelPackageService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/package/{packageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageModelPackageDTO> queryByPk(@PathVariable(value="packageId") String packageId, @RequestParam(value="appId") String appId) {
        PageModelPackageDTO inVo = new PageModelPackageDTO();
        inVo.setPackageId(packageId);
        inVo.setAppId(appId);
        PageModelPackageDTO outputVo = (PageModelPackageDTO)((PageModelPackageService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/package"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageModelPackageDTO inPageModelPackageVo) {
        int outputVo = ((PageModelPackageService)this.getService()).deleteByPk((Object)inPageModelPackageVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/package"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageModelPackageDTO inPageModelPackageVo) {
        this.setUserInfoToVO(inPageModelPackageVo);
        inPageModelPackageVo.setLastUpdateUser(inPageModelPackageVo.getLoginUserId());
        inPageModelPackageVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageModelPackageService)this.getService()).updateByPk((Object)inPageModelPackageVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/package"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageModelPackage(@RequestBody PageModelPackageDTO inPageModelPackageVo) {
        this.setUserInfoToVO(inPageModelPackageVo);
        if (StringUtils.isBlank((CharSequence)inPageModelPackageVo.getPackageId())) {
            inPageModelPackageVo.setPackageId(UUIDUtil.getUUID());
        }
        inPageModelPackageVo.setCreateUser(inPageModelPackageVo.getLoginUserId());
        inPageModelPackageVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageModelPackageService)this.getService()).insert((Object)inPageModelPackageVo);
        return this.getResponseData(outputVo);
    }
}

