/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateParamService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateParamDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@RestController
@RequestMapping(value={"/api"})
public class PageParamController
extends AbstractController {
    @Autowired
    @Qualifier(value="pageTemplateParamServiceImpl")
    private PageTemplateParamService pageTemplateParamService;
    @Autowired
    @Qualifier(value="pageModelParamServiceImpl")
    private PageModelParamService pageModelParamService;

    @RequestMapping(value={"/page/model/param/yaml"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertParamYAML(@RequestBody PageModelParamDTO inPageModelParamVo) {
        this.setUserInfoToVO(inPageModelParamVo);
        int outputVo = 0;
        String pageModelId = inPageModelParamVo.getPageModelId();
        String pageTemplateId = inPageModelParamVo.getPageTemplateId();
        String fileId = inPageModelParamVo.getFileId();
        String userId = inPageModelParamVo.getLoginUserId();
        String yamlContent = inPageModelParamVo.getParamValue();
        Yaml yaml = new Yaml();
        Map root = (Map)yaml.loadAs(yamlContent, Map.class);
        Map<String, String> prop = this.convertYamlToProperties(root);
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        if (prop.size() > 0) {
            PageModelParamDTO deleteParam = new PageModelParamDTO();
            deleteParam.setPageModelId(pageModelId);
            deleteParam.setFileId(fileId);
            this.pageModelParamService.deleteByModelId(deleteParam);
            for (Map.Entry<String, String> entry : prop.entrySet()) {
                PageModelParamDTO param = new PageModelParamDTO();
                param.setParamId(UUIDUtil.getUUID());
                param.setCreateUser(userId);
                param.setCreateTime(nowTime);
                param.setPageModelId(pageModelId);
                param.setPageTemplateId(pageTemplateId);
                param.setFileId(fileId);
                param.setParamCode(entry.getKey());
                param.setParamValue(entry.getValue());
                param.setNeedState("Y");
                this.pageModelParamService.insert((Object)param);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/page/template/param/yaml"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertTemplateParamYAML(@RequestBody PageTemplateParamDTO inPageTemplateParamVo) {
        this.setUserInfoToVO(inPageTemplateParamVo);
        int outputVo = 0;
        String pageTemplateId = inPageTemplateParamVo.getPageTemplateId();
        String fileId = inPageTemplateParamVo.getFileId();
        String userId = inPageTemplateParamVo.getLoginUserId();
        String yamlContent = inPageTemplateParamVo.getParamValue();
        Yaml yaml = new Yaml();
        Map root = (Map)yaml.loadAs(yamlContent, Map.class);
        Map<String, String> prop = this.convertYamlToProperties(root);
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        if (prop.size() > 0) {
            PageTemplateParamDTO deleteParam = new PageTemplateParamDTO();
            deleteParam.setPageTemplateId(pageTemplateId);
            deleteParam.setFileId(fileId);
            this.pageTemplateParamService.deleteByTemplateId(deleteParam);
            for (Map.Entry<String, String> entry : prop.entrySet()) {
                PageTemplateParamDTO param = new PageTemplateParamDTO();
                param.setParamId(UUIDUtil.getUUID());
                param.setCreateUser(userId);
                param.setCreateTime(nowTime);
                param.setPageTemplateId(pageTemplateId);
                param.setFileId(fileId);
                param.setParamCode(entry.getKey());
                param.setParamValue(entry.getValue());
                param.setNeedState("Y");
                this.pageTemplateParamService.insert((Object)param);
            }
        }
        return this.getResponseData(outputVo);
    }

    private Map<String, String> convertYamlToProperties(Map<String, Object> root) {
        HashMap<String, String> prop = new HashMap<String, String>();
        if (root != null && root.size() > 0) {
            for (Map.Entry<String, Object> entry : root.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", entry.getKey(), i);
                        Map value = (Map)list.get(i);
                        this.recursionConvert(prop, key, value);
                    }
                    continue;
                }
                prop.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return prop;
    }

    private void recursionConvert(Map<String, String> prop, String parentKey, Map<String, Object> parentValue) {
        if (parentValue != null && parentValue.size() > 0) {
            for (Map.Entry<String, Object> entry : parentValue.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(parentKey + "." + entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, parentKey + "." + entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", parentKey + "." + entry.getKey(), i);
                        Map value = (Map)list.get(i);
                        this.recursionConvert(prop, key, value);
                    }
                    continue;
                }
                prop.put(parentKey + "." + entry.getKey(), entry.getValue().toString());
            }
        }
    }

    @RequestMapping(value={"/page/model/params/yaml"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> showMeModelYml(@RequestBody PageModelParamDTO vo) {
        vo.setSize(Integer.valueOf(1000));
        List paramList = this.pageModelParamService.queryList((Object)vo);
        Map<String, Object> root = this.prepareParam(paramList);
        Yaml yaml = new Yaml();
        String yml = yaml.dumpAs(root, null, DumperOptions.FlowStyle.BLOCK);
        return this.getResponseData(yml);
    }

    @RequestMapping(value={"/page/template/params/yaml"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> showMeTemplateYml(@RequestBody PageTemplateParamDTO vo) throws Exception {
        List templateParamList = this.pageTemplateParamService.queryList((Object)vo);
        List<PageModelParamDTO> paramList = this.beansCopy(templateParamList, PageModelParamDTO.class);
        Map<String, Object> root = this.prepareParam(paramList);
        Yaml yaml = new Yaml();
        String yml = yaml.dumpAs(root, null, DumperOptions.FlowStyle.BLOCK);
        return this.getResponseData(yml);
    }

    <T> List<T> beansCopy(List<? extends Object> srcBeans, Class<T> targetBean) throws Exception {
        if (Objects.isNull(srcBeans)) {
            return null;
        }
        return srcBeans.stream().map(s -> this.beanCopy(s, this.newInstance(targetBean))).collect(Collectors.toList());
    }

    <T> T beanCopy(Object srcBean, Object targetBean) {
        if (Objects.nonNull(targetBean) && Objects.nonNull(srcBean)) {
            BeanCopier beanCopier = BeanCopier.create(srcBean.getClass(), targetBean.getClass(), (boolean)false);
            beanCopier.copy(srcBean, targetBean, null);
            return (T)targetBean;
        }
        return null;
    }

    Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Class\u7c7b\u5bf9\u8c61:" + clazz.getName() + "\u5b9e\u4f8b\u5316\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> prepareParam(List<PageModelParamDTO> paramList) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    private String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }
}

