/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageTemplateFileController
extends BaseController<PageTemplateFileDTO, PageTemplateFileService> {
    @RequestMapping(value={"/api/page/template/files"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageTemplateFileDTO>> queryPageTemplateFileAll(PageTemplateFileDTO vo) {
        List outputVo = ((PageTemplateFileService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/file/{fileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageTemplateFileDTO> queryByPk(@PathVariable(value="fileId") String fileId) {
        PageTemplateFileDTO inVo = new PageTemplateFileDTO();
        inVo.setFileId(fileId);
        PageTemplateFileDTO outputVo = (PageTemplateFileDTO)((PageTemplateFileService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/file"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageTemplateFileDTO inPageTemplateFileVo) {
        int outputVo = ((PageTemplateFileService)this.getService()).deleteByPk((Object)inPageTemplateFileVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/file"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageTemplateFileDTO inPageTemplateFileVo) {
        this.setUserInfoToVO(inPageTemplateFileVo);
        inPageTemplateFileVo.setLastUpdateUser(inPageTemplateFileVo.getLoginUserId());
        inPageTemplateFileVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageTemplateFileService)this.getService()).updateByPk((Object)inPageTemplateFileVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/file"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageTemplateFile(@RequestBody PageTemplateFileDTO inPageTemplateFileVo) {
        this.setUserInfoToVO(inPageTemplateFileVo);
        if (StringUtils.isBlank((CharSequence)inPageTemplateFileVo.getFileId())) {
            inPageTemplateFileVo.setFileId(UUIDUtil.getUUID());
        }
        inPageTemplateFileVo.setCreateUser(inPageTemplateFileVo.getLoginUserId());
        inPageTemplateFileVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageTemplateFileService)this.getService()).insert((Object)inPageTemplateFileVo);
        return this.getResponseData(outputVo);
    }
}

