/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.QryModelCondService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelCondDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelCondController
extends BaseController<QryModelCondDTO, QryModelCondService> {
    @RequestMapping(value={"/api/qry/model/conds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelCondDTO>> queryQryModelCondAll(QryModelCondDTO vo) {
        List outputDTO = ((QryModelCondService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/cond/{condId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelCondDTO> queryByPk(@PathVariable(value="condId") String condId, @RequestParam(value="qryId") String qryId) {
        QryModelCondDTO inDTO = new QryModelCondDTO();
        inDTO.setCondId(condId);
        inDTO.setQryId(qryId);
        QryModelCondDTO outputDTO = (QryModelCondDTO)((QryModelCondService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/cond"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelCondDTO inQryModelCondDTO) {
        int outputDTO = ((QryModelCondService)this.getService()).deleteByPk((Object)inQryModelCondDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/cond"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelCondDTO inQryModelCondDTO) {
        inQryModelCondDTO.setLastUpdateUser(inQryModelCondDTO.getLoginUserId());
        inQryModelCondDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelCondService)this.getService()).updateByPk((Object)inQryModelCondDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/cond"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelCond(@RequestBody QryModelCondDTO inQryModelCondDTO) {
        if (StringUtils.isBlank((CharSequence)inQryModelCondDTO.getCondId())) {
            inQryModelCondDTO.setCondId(UUIDUtil.getUUID());
            inQryModelCondDTO.setCreateUser(inQryModelCondDTO.getLoginUserId());
            inQryModelCondDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            int outputDTO = ((QryModelCondService)this.getService()).insert((Object)inQryModelCondDTO);
            return this.getResponseData(outputDTO);
        }
        return this.updateByPk(inQryModelCondDTO);
    }

    @RequestMapping(value={"/api/qry/model/cond/batchadd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> batchInsertField(@RequestBody List<QryModelCondDTO> list) {
        int outputDTO = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String qryId = list.get(0).getQryId();
            Integer orderValue = ((QryModelCondService)this.getService()).queryCondMaxOrder(qryId);
            for (QryModelCondDTO vo : list) {
                orderValue = orderValue + 1;
                vo.setCondOrder(orderValue);
                vo.setCondId(UUIDUtil.getUUID());
                vo.setCreateUser(vo.getLoginUserId());
                vo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            }
            outputDTO = ((QryModelCondService)this.getService()).batchInsert(list);
        }
        return this.getResponseData(outputDTO);
    }
}

