/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.QryModelInfoDevService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelInfoDevController
extends BaseController<QryModelInfoDTO, QryModelInfoDevService> {
    @RequestMapping(value={"/api/qry/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelInfoDTO>> queryQryModelInfoAll(QryModelInfoDTO dto) {
        List outputDTO = ((QryModelInfoDevService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/info/{qryId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelInfoDTO> queryByPk(@PathVariable(value="qryId") String qryId) {
        QryModelInfoDTO inDTO = new QryModelInfoDTO();
        inDTO.setQryId(qryId);
        QryModelInfoDTO outputDTO = (QryModelInfoDTO)((QryModelInfoDevService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelInfoDTO inQryModelInfoDTO) {
        int outputDTO = ((QryModelInfoDevService)this.getService()).deleteByPk((Object)inQryModelInfoDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelInfoDTO inQryModelInfoDTO) {
        inQryModelInfoDTO.setLastUpdateUser(inQryModelInfoDTO.getLoginUserId());
        inQryModelInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelInfoDevService)this.getService()).updateByPk((Object)inQryModelInfoDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelInfo(@RequestBody QryModelInfoDTO inQryModelInfoDTO) {
        if (StringUtils.isBlank((CharSequence)inQryModelInfoDTO.getQryId())) {
            SeqInstInfoService seqInstInfoService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            String qyrId = seqInstInfoService.nextSequence("QRY-MODEL-ID", null);
            inQryModelInfoDTO.setQryId(qyrId);
            inQryModelInfoDTO.setCreateUser(inQryModelInfoDTO.getLoginUserId());
            inQryModelInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            int outputDTO = ((QryModelInfoDevService)this.getService()).insert((Object)inQryModelInfoDTO);
            return this.getResponseData(outputDTO);
        }
        QryModelInfoDTO checkObj = (QryModelInfoDTO)((QryModelInfoDevService)this.getService()).queryByPk((Object)inQryModelInfoDTO);
        if (checkObj != null) {
            return this.updateByPk(inQryModelInfoDTO);
        }
        inQryModelInfoDTO.setCreateUser(inQryModelInfoDTO.getLoginUserId());
        inQryModelInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelInfoDevService)this.getService()).insert((Object)inQryModelInfoDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/client/QryModelInfoService/deleteAllAppDataByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteAllAppDataByCond(@RequestBody QryModelInfoDTO param) {
        return ((QryModelInfoDevService)this.getService()).deleteAllAppDataByCond(param);
    }

    @RequestMapping(value={"/api/qry/model/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<QryModelInfoDTO> validate(@RequestBody QryModelInfoDTO dto) {
        dto = (QryModelInfoDTO)((QryModelInfoDevService)this.getService()).queryByPk((Object)dto);
        boolean flag = ((QryModelInfoDevService)this.getService()).validate(dto);
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/qry/model/info/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody QryModelInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = ((QryModelInfoDevService)this.getService()).queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }
}

