/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.RptModelItemService;
import com.irdstudio.allinrdm.dev.console.facade.dto.RptModelItemDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintcp.sdk.report.facade.operation.RptModelInfoService;
import com.irdstudio.allintcp.sdk.report.facade.operation.dto.RptModelInfoDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.util.validation.Validation;
import net.sf.jsqlparser.util.validation.feature.DatabaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RptDevInfoController
extends AbstractController {
    @Autowired
    private RptModelInfoService rptModelInfoService;
    @Autowired
    private RptModelItemService rptModelItemService;
    @Autowired
    private ComBaseInfoService comBaseInfoService;
    @Autowired
    private RdmModuleInfoService rdmModuleInfoService;

    @RequestMapping(value={"/client/RptDevInfoService/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer insert_client(@RequestBody RptModelInfoDTO paramDTO) {
        int num = this.rptModelInfoService.insert((Object)paramDTO);
        return num;
    }

    @RequestMapping(value={"/client/RptDevInfoService/batchInsert"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer batchInsert_client(@RequestBody List<RptModelInfoDTO> paramDOList) {
        int num = this.rptModelInfoService.batchInsert(paramDOList);
        return num;
    }

    @RequestMapping(value={"/client/RptDevInfoService/updateByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer updateByPk_client(@RequestBody RptModelInfoDTO paramDTO) {
        int num = this.rptModelInfoService.updateByPk(paramDTO);
        return num;
    }

    @RequestMapping(value={"/client/RptDevInfoService/deleteByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByPk_client(@RequestBody RptModelInfoDTO paramDTO) {
        int num = this.rptModelInfoService.deleteByPk(paramDTO);
        return num;
    }

    @RequestMapping(value={"/client/RptDevInfoService/queryByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public RptModelInfoDTO queryByPk_client(@RequestBody RptModelInfoDTO paramDTO) {
        RptModelInfoDTO outputVO = this.rptModelInfoService.queryByPk(paramDTO);
        return outputVO;
    }

    @RequestMapping(value={"/client/RptDevInfoService/queryListByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<RptModelInfoDTO> queryListByPage_client(@RequestBody RptModelInfoDTO paramDTO) {
        List outputVO = this.rptModelInfoService.queryListByPage((Object)paramDTO);
        return outputVO;
    }

    @RequestMapping(value={"/client/RptDevInfoService/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public List<RptModelInfoDTO> queryList_client(@RequestBody RptModelInfoDTO paramDTO) {
        List outputVO = this.rptModelInfoService.queryList(paramDTO);
        return outputVO;
    }

    @RequestMapping(value={"/api/rpt/dev/info/gen/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> rptGenPagePath(@RequestBody RptModelInfoDTO paramDTO) {
        String rptModelId = paramDTO.getRptModelId();
        String appCode = paramDTO.getAppCode();
        String comFeatureCodePackage = "";
        RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
        moduleInfo.setModuleId(paramDTO.getModuleId());
        moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
        comFeatureCodePackage = moduleInfo != null ? moduleInfo.getFeatureCode() : appCode;
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("rptModelId", rptModelId);
        expMap.put("appCode", appCode);
        expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
        String page = ExpressionUtil.parse((String)"page/${comFeatureCodePackage}/${rptModelId}RptPage.html", expMap);
        return this.getResponseData(page);
    }

    @RequestMapping(value={"/api/rpt/dev/info/change/belong/deletes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBeLongDeleteFiles(RptModelInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getRptModelId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            ArrayList result = new ArrayList();
            files.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filePath", f.getAbsolutePath().replaceFirst(dir.getAbsolutePath(), "").replaceAll(File.separator, "/"));
                map.put("fileName", f.getName());
                result.add(map);
            });
            if (CollectionUtils.isNotEmpty(result)) {
                Map map = (Map)result.get(0);
                map.put("total", result.size());
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(Collections.emptyList());
    }

    @RequestMapping(value={"/api/rpt/dev/info/change/belong/deletes/confirm"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<String> beLongDeleteFilesConfirm(@RequestBody RptModelInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getRptModelId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            FileUtils.deleteQuietly((File)dir);
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(dto.getAppId());
            appRepoPullTask.syncRun();
            String appPath = appRepoPullTask.getAppPath();
            try {
                Files.move(new File(appPath).toPath(), dir.toPath(), new CopyOption[0]);
                for (File deleteFile : files) {
                    if (!deleteFile.exists()) continue;
                    FileUtils.deleteQuietly((File)deleteFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getResponseData("\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/api/rpt/dev/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<RptModelInfoDTO> validate(@RequestBody RptModelInfoDTO dto) {
        dto = this.rptModelInfoService.queryByPk(dto);
        RptModelItemDTO itemParam = new RptModelItemDTO();
        itemParam.setRptModelId(dto.getRptModelId());
        List itemList = this.rptModelItemService.queryList((Object)itemParam);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            ArrayList<String> modelErrors = new ArrayList<String>();
            Pattern pattern = Pattern.compile("[\\#\\$]\\{\\S+\\}");
            for (RptModelItemDTO item : itemList) {
                String sql = item.getRptItemSql();
                Matcher matcher = pattern.matcher(sql);
                sql = matcher.replaceAll("?");
                Validation validation = new Validation(Arrays.asList(DatabaseType.MYSQL), new String[]{sql});
                List errors = validation.validate();
                if (!CollectionUtils.isNotEmpty((Collection)errors)) continue;
                String error = String.format("%s\u62a5\u8868\u5361\u7247SQL\u8bed\u6cd5\u9519\u8bef", item.getRptItemTitle());
                modelErrors.add(error);
            }
            if (modelErrors.isEmpty()) {
                dto.setModelStat(ModelStat.Validated.getCode());
                this.rptModelInfoService.updateByPk(dto);
            } else {
                dto.setAll(StringUtils.join(modelErrors, (String)","));
            }
        }
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/rpt/dev/info/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody RptModelInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = this.rptModelInfoService.queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }
}

