/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.SrvModelExpvarService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelExpvarDTO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SrvModelExpvarController
extends BaseController<SrvModelExpvarDTO, SrvModelExpvarService> {
    @RequestMapping(value={"/api/srv/model/expvars"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelExpvarDTO>> querySrvModelExpvarAll(SrvModelExpvarDTO vo) {
        List outputVo = ((SrvModelExpvarService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvars/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelExpvarDTO>> querySrvModelExpvarAllNotPage(@RequestBody SrvModelExpvarDTO vo) {
        List outputVo = ((SrvModelExpvarService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvar/{expvarId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvModelExpvarDTO> queryByPk(@PathVariable(value="expvarId") String expvarId) {
        SrvModelExpvarDTO inVo = new SrvModelExpvarDTO();
        inVo.setExpvarId(expvarId);
        SrvModelExpvarDTO outputVo = (SrvModelExpvarDTO)((SrvModelExpvarService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvar"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvModelExpvarDTO inSrvModelExpvarVo) {
        int outputVo = ((SrvModelExpvarService)this.getService()).deleteByPk((Object)inSrvModelExpvarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvar"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvModelExpvarDTO inSrvModelExpvarVo) {
        int outputVo = ((SrvModelExpvarService)this.getService()).updateByPk((Object)inSrvModelExpvarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvar"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSrvModelExpvar(@RequestBody SrvModelExpvarDTO inSrvModelExpvarVo) {
        if (StringUtils.isBlank((CharSequence)inSrvModelExpvarVo.getExpvarId())) {
            inSrvModelExpvarVo.setExpvarId(UUIDUtil.getUUID());
        }
        int outputVo = ((SrvModelExpvarService)this.getService()).insert((Object)inSrvModelExpvarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/expvar/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveCondList(@RequestBody List<SrvModelExpvarDTO> expVarList) {
        try {
            UserInfo userInfo = this.getUserInfo();
            int outputVo = ((SrvModelExpvarService)this.getService()).saveVarList(expVarList, userInfo.getUserId());
            return this.getResponseData(outputVo);
        }
        catch (Exception e) {
            return this.getResponseData(-1);
        }
    }
}

