/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoExcelDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoTableExcelDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class SrvModelInfoController
extends BaseController<SrvModelInfoDTO, SrvModelInfoService> {
    public static final ConcurrentMap<String, String> taskDebounce = new ConcurrentHashMap<String, String>();
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    @Qualifier(value="osrvArrangeVarServiceImpl")
    private OsrvArrangeVarService osrvArrangeVarService;
    @Autowired
    @Qualifier(value="srvModelInoutServiceImpl")
    private SrvModelInoutService srvModelInoutService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;

    @RequestMapping(value={"/api/srv/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> querySrvModelInfoAll(SrvModelInfoDTO vo) {
        if (StringUtils.contains((CharSequence)vo.getSrvModelCatalog(), (CharSequence)",")) {
            String[] catalogs = StringUtils.split((String)vo.getSrvModelCatalog(), (String)",");
            vo.setSrvModelCatalogs(Arrays.asList(catalogs));
            vo.setSrvModelCatalog(null);
        }
        if (StringUtils.contains((CharSequence)vo.getSrvModelType(), (CharSequence)",")) {
            String[] srvModelTypes = StringUtils.split((String)vo.getSrvModelType(), (String)",");
            vo.setSrvModelTypes(Arrays.asList(srvModelTypes));
            vo.setSrvModelType(null);
        }
        List outputVo = this.srvModelInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos/sys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> querySrvModelOnSysCodeByPage(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.querySrvModelOnSysCodeByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos/not/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> querySrvModelInfos(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos2"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> querySrvModelInfoAll2(@RequestBody SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.queryModelSrvByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos2/tableModelId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SrvModelInfoDTO> querySrvModelInfoByTableModelId(@RequestBody SrvModelInfoDTO vo) {
        SrvModelInfoDTO outputVo = this.srvModelInfoService.queryByTableModelId(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info/{srvModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvModelInfoDTO> queryByPk(@PathVariable(value="srvModelId") String srvModelId) {
        SrvModelInfoDTO inVo = new SrvModelInfoDTO();
        inVo.setSrvModelId(srvModelId);
        SrvModelInfoDTO outputVo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info/regenerate/{srvModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> regenerateDomainServices(@PathVariable(value="srvModelId") String srvModelId) {
        boolean ss = this.srvModelInfoService.regenerateDomainServices(srvModelId);
        return this.getResponseData(ss);
    }

    @RequestMapping(value={"/api/srv/model/info"}, method={RequestMethod.DELETE})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u670d\u52a1 ${args[0].srvModelName} ${args[0].srvModelCode}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvModelInfoDTO inAppModelInfoVo) {
        int outputVo = this.srvModelInfoService.deleteByPk((Object)inAppModelInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info/tableModelId"}, method={RequestMethod.DELETE})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u6839\u636e\u8868\u6a21\u578bobjectId\u5220\u9664\u670d\u52a1 ${args[0].srvModelName} ${args[0].tableModelId}", objectId="${args[0].tableModelId}", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<Integer> deleteByObjectId(@RequestBody SrvModelInfoDTO inAppModelInfoVo) {
        List delModelList = this.srvModelInfoService.queryList((Object)inAppModelInfoVo);
        int num = 0;
        for (SrvModelInfoDTO model : delModelList) {
            num += this.srvModelInfoService.deleteByPk((Object)model);
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/srv/model/info"}, method={RequestMethod.PUT})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u670d\u52a1 ${args[0].srvModelName} ${args[0].srvModelCode}", appId="${args[0].appId}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvModelInfoDTO srvModelInfo) {
        this.setUserInfoToVO(srvModelInfo);
        srvModelInfo.setLastUpdateUser(srvModelInfo.getLoginUserId());
        srvModelInfo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        SrvModelInfoDTO oldSrvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
        int outputVo = this.srvModelInfoService.updateByPk((Object)srvModelInfo);
        srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
        if (srvModelInfo.getSrvModelCatalog().equals(SrvModelCatalogEnum.ComponentServer.getCode()) || srvModelInfo.getSrvModelCatalog().equals(SrvModelCatalogEnum.TradeServer.getCode()) || srvModelInfo.getSrvModelCatalog().equals(SrvModelCatalogEnum.BackServer.getCode())) {
            this.srvModelInfoService.updateOsrvVarModel(srvModelInfo, oldSrvModelInfo);
        } else if (srvModelInfo.getSrvModelCatalog().equals(SrvModelCatalogEnum.SrvServer.getCode())) {
            this.srvModelInfoService.updateIsrvInoutModel(srvModelInfo, oldSrvModelInfo);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info/batch"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> batchUpdateSrvModelOpen(@RequestBody List<SrvModelInfoDTO> modelList) {
        Integer outputVo = this.srvModelInfoService.batchUpdateSrvModelOpen(modelList);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info"}, method={RequestMethod.POST})
    @AppDevLogAnno(action=LogAction.Add, desc="\u521b\u5efa\u670d\u52a1 ${args[0].srvModelName} ${args[0].srvModelCode}", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<String> insertSrvModelInfo(@RequestBody SrvModelInfoDTO inSrvModelInfoVo, @RequestParam(value="dId", required=false) String dId) {
        this.setUserInfoToVO(inSrvModelInfoVo);
        String srvModelId = UUIDUtil.getUUID();
        inSrvModelInfoVo.setCreateUser(inSrvModelInfoVo.getLoginUserId());
        inSrvModelInfoVo.setCreateTime(TimeUtil.getCurrentDateTime());
        inSrvModelInfoVo.setLastUpdateUser(inSrvModelInfoVo.getLoginUserId());
        inSrvModelInfoVo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        inSrvModelInfoVo.setSrvModelId(srvModelId);
        int outputVo = 0;
        try {
            SrvModelInfoDTO checkRepeat = new SrvModelInfoDTO();
            checkRepeat.setSrvModelCatalog(inSrvModelInfoVo.getSrvModelCatalog());
            checkRepeat.setSrvModelCode(inSrvModelInfoVo.getSrvModelCode());
            checkRepeat.setSrvModelMethod(inSrvModelInfoVo.getSrvModelMethod());
            checkRepeat.setTableModelCode(inSrvModelInfoVo.getTableModelCode());
            checkRepeat.setAppId(inSrvModelInfoVo.getAppId());
            checkRepeat.setSize(Integer.valueOf(1));
            List repeatList = this.srvModelInfoService.queryList((Object)checkRepeat);
            if (CollectionUtils.isNotEmpty((Collection)repeatList)) {
                ResponseData resp = this.getResponseData(null);
                resp.setMessage("\u751f\u5b58\u91cd\u540d\u670d\u52a1\uff01");
                return resp;
            }
            if (StringUtils.isNotBlank((CharSequence)dId)) {
                SrvModelInfoDTO dServiceVO = new SrvModelInfoDTO();
                dServiceVO.setSrvModelId(dId);
                dServiceVO = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)dServiceVO);
                SrvModelInfoDTO dService = new SrvModelInfoDTO();
                BeanUtility.beanCopy((Object)dServiceVO, (Object)dService);
                PaasAppsInfoDTO appInfoVO = new PaasAppsInfoDTO();
                appInfoVO.setAppId(dServiceVO.getAppId());
                appInfoVO = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfoVO);
                ConcurrentHashMap cachedMap = new ConcurrentHashMap();
                outputVo = this.srvModelInfoService.insertSrvModelInfo(inSrvModelInfoVo, dService, appInfoVO, cachedMap);
            } else {
                outputVo = this.srvModelInfoService.insert((Object)inSrvModelInfoVo);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u670d\u52a1\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            outputVo = -1;
        }
        if (outputVo == 1) {
            return this.getResponseData(srvModelId);
        }
        return this.getResponseData(null);
    }

    @RequestMapping(value={"/api/srv/model/info/order/{order}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> dealWithSrvOrder(@PathVariable(value="order") String order, @RequestParam(value="firstId") String firstId, @RequestParam(value="secondId") String secondId) {
        SrvModelInfoDTO firstVO = new SrvModelInfoDTO();
        firstVO.setSrvModelId(firstId);
        firstVO = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)firstVO);
        if (firstVO == null) {
            return this.getResponseData("\u6392\u5e8f\u5931\u8d25");
        }
        SrvModelInfoDTO seconDTO = new SrvModelInfoDTO();
        seconDTO.setSrvModelId(secondId);
        seconDTO = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)seconDTO);
        if (seconDTO == null) {
            return this.getResponseData("\u6392\u5e8f\u5931\u8d25");
        }
        if (firstVO.getOrderValue() == null || seconDTO.getOrderValue() == null) {
            SrvModelInfoDTO srvParam = new SrvModelInfoDTO();
            srvParam.setAppId(firstVO.getAppId());
            srvParam.setPackageId(firstVO.getPackageId());
            srvParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
            srvParam.setSize(Integer.valueOf(1000));
            List srvList = this.srvModelInfoService.queryList((Object)srvParam);
            int orderVal = 1;
            for (SrvModelInfoDTO srv : srvList) {
                srv.setOrderValue(Integer.valueOf(orderVal++));
                this.srvModelInfoService.updateByPk((Object)srv);
                if (srv.getSrvModelId().equals(firstId)) {
                    firstVO.setOrderValue(srv.getOrderValue());
                    continue;
                }
                if (!srv.getSrvModelId().equals(secondId)) continue;
                seconDTO.setOrderValue(srv.getOrderValue());
            }
        }
        int orderValTmp = firstVO.getOrderValue();
        firstVO.setOrderValue(seconDTO.getOrderValue());
        seconDTO.setOrderValue(Integer.valueOf(orderValTmp));
        this.srvModelInfoService.updateByPk((Object)firstVO);
        this.srvModelInfoService.updateByPk((Object)seconDTO);
        return this.getResponseData("\u6392\u5e8f\u6210\u529f");
    }

    @PostMapping(value={"/api/sd/app/init/create/{appModelCatalog}/{appId}"})
    @ResponseBody
    public ResponseData<Boolean> initBizModel(@PathVariable(value="appId") String appId, @PathVariable(value="appModelCatalog") String appModelCatalog, @RequestParam(value="coverFlag") String coverFlag, @RequestParam(value="srvModelType") String srvModelType, @RequestBody SrvModelInfoDTO inAppModelInfoVo) {
        boolean flag = false;
        this.setUserInfoToVO(inAppModelInfoVo);
        inAppModelInfoVo.setCreateUser(inAppModelInfoVo.getLoginUserId());
        inAppModelInfoVo.setCreateTime(TimeUtil.getCurrentDateTime());
        inAppModelInfoVo.setSrvModelId(UUIDUtil.getUUID());
        if (appModelCatalog.equals(SrvModelCatalogEnum.SrvServer.getCode())) {
            Boolean coverFlagbl = Boolean.parseBoolean(coverFlag);
            PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
            appParam.setAppId(appId);
            PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appParam);
            flag = this.srvModelInfoService.initDataServiceModel(appId, inAppModelInfoVo, coverFlagbl, Boolean.valueOf(false), srvModelType);
        }
        return this.getResponseData(flag);
    }

    @GetMapping(value={"/api/srv/model/info/init/create"})
    @ResponseBody
    public ResponseData<Boolean> initSrvBizModel(@RequestParam(value="appId") String appId, @RequestParam(value="coverFlag") String coverFlag, @RequestParam(value="srvModelType") String srvModelType) {
        boolean flag = false;
        PaasAppsInfoDTO param = new PaasAppsInfoDTO();
        param.setAppId(appId);
        PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)param);
        if (appInfo == null) {
            return this.getResponseData(false);
        }
        String projectId = appInfo.getAppId();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Table.getCode())));
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                SrvModelInfoDTO creatSrvModelParam = new SrvModelInfoDTO();
                creatSrvModelParam.setAppId(appId);
                creatSrvModelParam.setTableModelId(table.getObjectId());
                creatSrvModelParam.setTableModelCode(table.getObjectCode());
                creatSrvModelParam.setTableModelName(table.getObjectName());
                this.setUserInfoToVO(creatSrvModelParam);
                creatSrvModelParam.setCreateUser(creatSrvModelParam.getLoginUserId());
                creatSrvModelParam.setCreateTime(TimeUtil.getCurrentDateTime());
                creatSrvModelParam.setSrvModelId(UUIDUtil.getUUID());
                Boolean coverFlagbl = Boolean.parseBoolean(coverFlag);
                PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
                appParam.setAppId(appId);
                flag = this.srvModelInfoService.initDataServiceModel(appId, creatSrvModelParam, coverFlagbl, Boolean.valueOf(false), srvModelType);
                if (flag) continue;
                break;
            }
        }
        return this.getResponseData(flag);
    }

    @PostMapping(value={"/sd/app/project/init/create/{appModelCatalog}"})
    @ResponseBody
    public ResponseData<Boolean> initAppBizModel(@PathVariable(value="appModelCatalog") String appModelCatalog, @RequestParam(value="appId") String appId, @RequestParam(value="projectId") String projectId, @RequestParam(value="coverFlag") String coverFlag, @RequestParam(value="srvModelType") String srvModelType, @RequestBody SrvModelInfoDTO inAppModelInfoVo) {
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(ObjectType.Table.getIntCode());
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                SrvModelInfoDTO initParam = new SrvModelInfoDTO();
                initParam.setAppId(appId);
                initParam.setTableModelId(table.getObjectId());
                initParam.setTableModelCode(table.getObjectCode());
                initParam.setTableModelName(table.getObjectName());
                this.initBizModel(appId, appModelCatalog, coverFlag, srvModelType, initParam);
            }
        }
        return this.getResponseData(true);
    }

    @PostMapping(value={"/api/srv/model/info/thumbnail"})
    @ResponseBody
    public ResponseData<List> queryThumbnailList(@RequestBody SrvModelInfoDTO inAppModelInfoVo) {
        ArrayList result = new ArrayList(inAppModelInfoVo.getSize());
        List srvModelInfoList = this.srvModelInfoService.queryList((Object)inAppModelInfoVo);
        int total = 0;
        ArrayList empty = new ArrayList(0);
        if (CollectionUtils.isNotEmpty((Collection)srvModelInfoList)) {
            total = ((SrvModelInfoDTO)srvModelInfoList.get(0)).getTotal();
            SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
            for (SrvModelInfoDTO vo : srvModelInfoList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                result.add(map);
                map.put("info", vo);
                inoutParam.setSrvModelId(vo.getSrvModelId());
                inoutParam.setIoType(IOType.Input.getCode());
                List inputs = this.srvModelInoutService.querySrvInoutsWithoutParamSet(inoutParam);
                map.put(DomainVarType.Input.getCode(), inputs);
                inoutParam.setSrvModelId(vo.getSrvModelId());
                inoutParam.setIoType(IOType.Output.getCode());
                List outpus = this.srvModelInoutService.querySrvInoutsWithoutParamSet(inoutParam);
                map.put(DomainVarType.Output.getCode(), outpus);
            }
        }
        ResponseData output = this.getResponseData(result);
        output.setTotal(total);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/srv/model/info/excel/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "SrvModelInfoTemplate.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u670d\u52a1\u5b9a\u4e49\u5bfc\u5165\u6a21\u677f.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/srv/model/info/A01/excel"})
    @ResponseBody
    public ResponseData<Map<String, String>> uploadExcel(@RequestParam(value="appId") String appId, @RequestPart(value="file") MultipartFile file) {
        final Pattern paramHeadRegPattern = Pattern.compile("\u8f93[\u5165|\u51fa][\\(|\uff08](\\S+)\\s+(\\S+)[\\)|\uff09]");
        HashMap<String, String> resp = new HashMap<String, String>();
        try {
            final ArrayList interfaceList = new ArrayList();
            final HashMap interfaceMap = new HashMap();
            EasyExcel.read((InputStream)file.getInputStream(), ModelInfoExcel.class, (ReadListener)new AnalysisEventListener<ModelInfoExcel>(){

                public void invoke(ModelInfoExcel data, AnalysisContext context) {
                    logger.info("\u63a5\u53e3\u76ee\u5f55\u9879 {}", (Object)data.getSrvModelCode());
                    SrvModelInfoExcelDTO dto = new SrvModelInfoExcelDTO();
                    BeanUtility.beanCopy((Object)data, (Object)dto);
                    dto.setTableList(new ArrayList());
                    dto.setCurrentIdx(-1);
                    interfaceList.add(dto);
                    interfaceMap.put(dto.getSrvModelCode(), dto);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                    logger.info("\u63a5\u53e3\u76ee\u5f55\u8bfb\u53d6\u603b\u6570 {}", (Object)interfaceList.size());
                }
            }).sheet(Integer.valueOf(0)).doReadSync();
            ExcelReader excelReader = ((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).headRowNumber(Integer.valueOf(4))).build();
            List sheets = excelReader.excelExecutor().sheetList();
            if (CollectionUtils.isNotEmpty((Collection)sheets)) {
                sheets = sheets.subList(1, sheets.size());
                HashMap<String, ReadSheet> sheetMap = new HashMap<String, ReadSheet>(sheets.size());
                for (ReadSheet sheet : sheets) {
                    String sheetName = sheet.getSheetName();
                    sheetMap.put(sheetName, sheet);
                }
                for (SrvModelInfoExcelDTO intf : interfaceList) {
                    if (sheetMap.get(intf.getSrvModelCode()) != null) continue;
                    resp.put("flag", "C");
                    this.getResponseData(resp);
                }
                ((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream(), (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                    public void invoke(Map<Integer, String> data, AnalysisContext context) {
                        String sheetName = context.readSheetHolder().getSheetName();
                        SrvModelInfoExcelDTO modelData = (SrvModelInfoExcelDTO)interfaceMap.get(sheetName);
                        if (modelData == null) {
                            return;
                        }
                        if (modelData.readFlag != null && modelData.readFlag.equals("end")) {
                            return;
                        }
                        logger.info("\u8bfb\u53d6\u63a5\u53e3 {} \u53c2\u6570\u660e\u7ec6", (Object)sheetName);
                        String firstCell = MapUtils.getString(data, (Object)0, (String)"");
                        Matcher m = paramHeadRegPattern.matcher(firstCell);
                        if (m.matches()) {
                            String objectCode = m.group(2);
                            String objectName = m.group(1);
                            SrvModelInfoTableExcelDTO tableExcel = new SrvModelInfoTableExcelDTO();
                            tableExcel.getTable().setObjectType(Integer.valueOf(ObjectType.Inout.getCode()));
                            tableExcel.getTable().setObjectCode(objectCode);
                            tableExcel.getTable().setObjectName(objectName);
                            modelData.getTableList().add(tableExcel);
                            modelData.setCurrentIdx(modelData.getTableList().size() - 1);
                            if (firstCell.startsWith("\u8f93\u5165")) {
                                modelData.readFlag = "input";
                                tableExcel.setVarType(IOType.Input.getCode());
                            } else if (firstCell.startsWith("\u8f93\u51fa")) {
                                modelData.readFlag = "output";
                                tableExcel.setVarType(IOType.Output.getCode());
                            }
                        } else if (firstCell.startsWith("\u9519\u8bef\u7801") || firstCell.startsWith("\u63a5\u53e3\u8bf4\u660e")) {
                            modelData.readFlag = "end";
                        } else if (!firstCell.startsWith("\u5e8f\u53f7")) {
                            SrvModelInfoTableExcelDTO tableExcel = modelData.getCurrentTable();
                            ModelTableFieldDTO field = this.generateField(data);
                            if (modelData.readFlag.equals("input")) {
                                tableExcel.getFields().add(field);
                            } else if (modelData.readFlag.equals("output")) {
                                tableExcel.getFields().add(field);
                            }
                        }
                    }

                    public ModelTableFieldDTO generateField(Map<Integer, String> data) {
                        String len;
                        ModelTableFieldDTO field = new ModelTableFieldDTO();
                        field.setFieldOrder(Integer.valueOf(NumberUtils.toInt((String)data.get(0), (int)1)));
                        field.setFieldName(data.get(1));
                        field.setFieldCode(data.get(2));
                        String type = MapUtils.getString(data, (Object)3, (String)"String");
                        if (type.equals("String")) {
                            field.setFieldType("varchar");
                            len = data.get(4);
                            Integer lenNum = NumberUtils.toInt((String)len, (int)1000);
                            field.setFieldLength(lenNum);
                        } else if (type.equals("Decimal")) {
                            field.setFieldType("decimal");
                            len = data.get(4);
                            String[] lenA = StringUtils.split((String)len.replaceAll("\uff0c", ","), (String)",");
                            Integer lenNum = NumberUtils.toInt((String)lenA[0], (int)16);
                            field.setFieldLength(lenNum);
                            if (lenA.length > 1) {
                                Integer precisionNum = NumberUtils.toInt((String)lenA[1], (int)0);
                                field.setFieldPrecision(precisionNum);
                            }
                        }
                        String fieldDesc = data.get(6);
                        if (StringUtils.isNotBlank((CharSequence)fieldDesc) && fieldDesc.length() > 250) {
                            fieldDesc = fieldDesc.substring(0, 250) + "...";
                        }
                        field.setFieldDesc(fieldDesc);
                        String allowNull = MapUtils.getString(data, (Object)7, (String)"O");
                        if (allowNull.equals("\u662f")) {
                            allowNull = "Y";
                            field.setIsAllowNull(allowNull);
                        } else if (allowNull.equals("\u5426")) {
                            allowNull = "N";
                            field.setIsAllowNull(allowNull);
                        } else {
                            field.setIsAllowNull(allowNull.equals("M") ? "Y" : "N");
                        }
                        return field;
                    }

                    public void doAfterAllAnalysed(AnalysisContext context) {
                        String sheetName = context.readSheetHolder().getSheetName();
                        logger.info("\u8bfb\u53d6\u63a5\u53e3 {} \u5b8c\u6210", (Object)sheetName);
                    }
                }).headRowNumber(Integer.valueOf(4))).doReadAllSync();
                logger.info("\u5f00\u59cb\u8c03\u7528\u670d\u52a1\u4fdd\u5b58\u5165\u5e93");
                HashMap<String, SrvModelInfoTableExcelDTO> tbMap = new HashMap<String, SrvModelInfoTableExcelDTO>();
                for (SrvModelInfoExcelDTO intfExcel : interfaceList) {
                    List tableExcels = intfExcel.getTableList();
                    if (CollectionUtils.isNotEmpty((Collection)tableExcels)) continue;
                    for (SrvModelInfoTableExcelDTO tableExcel : tableExcels) {
                        SrvModelInfoTableExcelDTO tmp = (SrvModelInfoTableExcelDTO)tbMap.get(tableExcel.getTable().getObjectCode().trim());
                        if (tmp == null) {
                            tbMap.put(tableExcel.getTable().getObjectCode().trim(), tableExcel);
                            continue;
                        }
                        List tOneFields = tmp.getFields();
                        List tTwoFields = tableExcel.getFields();
                        HashMap<String, ModelTableFieldDTO> fMap = new HashMap<String, ModelTableFieldDTO>();
                        for (ModelTableFieldDTO f : tOneFields) {
                            fMap.put(f.getFieldCode().trim(), f);
                        }
                        for (ModelTableFieldDTO f : tTwoFields) {
                            ModelTableFieldDTO tmpF = (ModelTableFieldDTO)fMap.get(f.getFieldCode().trim());
                            if (tmpF != null) continue;
                            tOneFields.add(f);
                        }
                    }
                }
                this.srvModelInfoService.saveImportExcelData(appId, null, this.getUserInfo(), interfaceList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resp.put("flag", "F");
            resp.put("msg", e.getCause().getMessage());
            ResponseData responseData = this.getResponseData(resp);
            return responseData;
        }
        finally {
            try {
                IOUtils.closeQuietly((InputStream)file.getInputStream());
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u5165\u5f02\u5e38", (Throwable)e);
            }
        }
        resp.put("flag", "S");
        resp.put("msg", "\u6210\u529f");
        return this.getResponseData(resp);
    }

    @RequestMapping(value={"/api/srv/model/infos/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> querySrvModelInfoRefList(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.querySrvModelInfoRefByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos/func/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> queryFuncInfoRefByPage(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.queryFuncInfoRefByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/infos/table/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> queryTableRefSrvRefByPage(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.queryTableRefSrvRefByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/info/gen/middle"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> generateA10MiddleVarModel(@RequestBody SrvModelInfoDTO vo) {
        vo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)vo);
        String objectId = this.srvModelInfoService.generateOsrvVarModel(vo, true);
        return this.getResponseData(objectId);
    }

    @RequestMapping(value={"/api/srv/model/info/isolates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInfoDTO>> queryAllIsolateSrvByPage(SrvModelInfoDTO vo) {
        List outputVo = this.srvModelInfoService.queryAllIsolateSrvByPage(vo);
        return this.getResponseData(outputVo);
    }

    @AppDevLogAnno(action=LogAction.Delete, desc="\u4e00\u952e\u6e05\u9664\u65e0\u6548\u5173\u8054\u6570\u636e ${args[0].appId}", appId="${args[0].appId}")
    @RequestMapping(value={"/api/srv/model/info/isolate/clean"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> cleanIsolateData(@RequestBody SrvModelInfoDTO vo) {
        try {
            int num = this.srvModelInfoService.cleanIsolateData(vo.getAppId());
            return this.getResponseData(num);
        }
        catch (Exception e) {
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @GetMapping(value={"/api/srv/model/info/init/b/create"})
    @ResponseBody
    public ResponseData<Integer> batchCreateBService(final @RequestParam(value="appId") String appId, final @RequestParam(value="coverFlag") String coverFlag, final @RequestParam(value="srvModelType") String srvModelType) {
        if (taskDebounce.get(appId + "RS") != null && ((String)taskDebounce.get(appId + "RS")).equals("R")) {
            ResponseData resp = this.getResponseData(1);
            resp.setRows((Object)-2);
            resp.setMessage("R");
            return resp;
        }
        taskDebounce.put(appId + "RS", "R");
        try {
            final String userId = this.getUserInfo().getUserId();
            int num = 0;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    logger.error("==================================== start " + start);
                    int num = SrvModelInfoController.this.srvModelInfoService.batchCreateBService(appId, coverFlag, srvModelType, userId);
                    taskDebounce.put(appId, String.valueOf(num));
                    taskDebounce.put(appId + "RS", "D");
                    logger.error("==================================== end " + (System.currentTimeMillis() - start));
                }
            }).start();
            return this.getResponseData(num);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u521b\u5efa\u540e\u7ba1\u670d\u52a1\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @GetMapping(value={"/api/srv/model/info/init/b/create/result"})
    @ResponseBody
    public ResponseData<Integer> batchCreateBService(@RequestParam(value="appId") String appId) {
        if (taskDebounce.get(appId + "RS") != null && ((String)taskDebounce.get(appId + "RS")).equals("R")) {
            ResponseData resp = this.getResponseData(1);
            resp.setRows((Object)-2);
            resp.setMessage("R");
            return resp;
        }
        if (taskDebounce.get(appId + "RS") != null && ((String)taskDebounce.get(appId + "RS")).equals("D") && taskDebounce.get(appId) != null) {
            taskDebounce.remove(appId + "RS");
            String str = (String)taskDebounce.get(appId);
            ResponseData resp = this.getResponseData(Integer.valueOf(str));
            resp.setMessage("D");
            return resp;
        }
        ResponseData resp = this.getResponseData(0);
        resp.setMessage("N");
        return resp;
    }

    @RequestMapping(value={"/client/SrvModelInfoService/initDataServiceModel"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean initDataServiceModel(@RequestParam(value="appId") String appId, @RequestBody SrvModelInfoDTO srvModelInfo, @RequestParam(value="coverFlag") Boolean coverFlag, @RequestParam(value="addFlag") Boolean addFlag, @RequestParam(value="srvModelType") String srvModelType) {
        return ((SrvModelInfoService)this.getService()).initDataServiceModel(appId, srvModelInfo, coverFlag, addFlag, srvModelType);
    }

    @RequestMapping(value={"/client/SrvModelInfoService/deleteSrvCompileDataById"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteSrvCompileDataById(@RequestParam(value="srvModelId") String srvModelId) {
        return ((SrvModelInfoService)this.getService()).deleteSrvCompileDataById(srvModelId);
    }

    @RequestMapping(value={"/client/SrvModelInfoService/initBsServiceFormDs"}, method={RequestMethod.POST})
    @ResponseBody
    public int initBsServiceFormDs(@RequestBody SrvModelInfoDTO inAppModelInfoVo, @RequestParam(value="dsId") String dsId, @RequestParam(value="appId") String appId) {
        return ((SrvModelInfoService)this.getService()).initBsServiceFormDs(inAppModelInfoVo, dsId, appId);
    }

    @RequestMapping(value={"/client/SrvModelInfoService/deleteAllAppData"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteAllAppData(@RequestBody SrvModelInfoDTO param) {
        return ((SrvModelInfoService)this.getService()).deleteAllAppData(param);
    }

    @RequestMapping(value={"/api/srv/model/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SrvModelInfoDTO> validate(@RequestBody SrvModelInfoDTO dto) {
        dto = (SrvModelInfoDTO)((SrvModelInfoService)this.getService()).queryByPk((Object)dto);
        boolean flag = ((SrvModelInfoService)this.getService()).validate(dto);
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/srv/model/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody SrvModelInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = ((SrvModelInfoService)this.getService()).queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }

    @RequestMapping(value={"/api/srv/model/info/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryAppsIndexSummary(@RequestBody PaasAppsInfoDTO param) {
        Map outputVo = ((SrvModelInfoService)this.getService()).queryAppsIndexSummary(param.getAppId());
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/SrvModelInfoService/queryAppsIndexSummary"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryAppsIndexSummary(@RequestParam(value="appId") String appId) {
        return ((SrvModelInfoService)this.getService()).queryAppsIndexSummary(appId);
    }

    static class ModelInfoExcel {
        @ExcelProperty(value={"\u63a5\u53e3\u540d\u79f0"})
        private String srvModelCode;
        @ExcelProperty(value={"\u63a5\u53e3\u540d\u79f0-\u4e2d\u6587"})
        private String srvModelName;
        @ExcelProperty(value={"\u63a5\u53e3\u8bf4\u660e"})
        private String srvModelDesc;
        @ExcelProperty(value={"\u76ee\u5f55"})
        private String packageName;

        ModelInfoExcel() {
        }

        public String getSrvModelCode() {
            return this.srvModelCode;
        }

        public void setSrvModelCode(String srvModelCode) {
            this.srvModelCode = srvModelCode;
        }

        public String getSrvModelName() {
            return this.srvModelName;
        }

        public void setSrvModelName(String srvModelName) {
            this.srvModelName = srvModelName;
        }

        public String getSrvModelDesc() {
            return this.srvModelDesc;
        }

        public void setSrvModelDesc(String srvModelDesc) {
            this.srvModelDesc = srvModelDesc;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }
}

