/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.project.console.facade.RdmIssueInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmIssueInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.IssueCategory;
import com.irdstudio.allinrdm.project.console.types.IssuePriority;
import com.irdstudio.allinrdm.project.console.types.IssueState;
import com.irdstudio.allinrdm.project.console.types.IssueType;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.DateUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class RdmIssueInfoController
extends BaseController<RdmIssueInfoDTO, RdmIssueInfoService> {
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;
    @Autowired
    protected SSubsInfoService sSubsInfoService;
    @Autowired
    protected PaasAppsInfoService paasAppsInfoService;
    @Autowired
    protected RdmProjectInfoService rdmProjectInfoService;

    @RequestMapping(value={"/api/rdm/issue/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmIssueInfoDTO>> queryRdmIssueInfoAll(RdmIssueInfoDTO dto) {
        List outputVo = ((RdmIssueInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/issue/info/{issueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmIssueInfoDTO> queryByPk(@PathVariable(value="issueId") String issueId) {
        RdmIssueInfoDTO inVo = new RdmIssueInfoDTO();
        inVo.setIssueId(issueId);
        RdmIssueInfoDTO outputVo = (RdmIssueInfoDTO)((RdmIssueInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/issue/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmIssueInfoDTO inRdmIssueInfoDTO) {
        int outputVo = ((RdmIssueInfoService)this.getService()).deleteByPk((Object)inRdmIssueInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/issue/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmIssueInfoDTO inRdmIssueInfoDTO) {
        this.setUserInfoToVO(inRdmIssueInfoDTO);
        inRdmIssueInfoDTO.setLastUpdateUser(inRdmIssueInfoDTO.getLoginUserId());
        inRdmIssueInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RdmIssueInfoService)this.getService()).updateByPk((Object)inRdmIssueInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/issue/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmIssueInfo(@RequestBody RdmIssueInfoDTO inRdmIssueInfoDTO) {
        if (StringUtils.isBlank((CharSequence)inRdmIssueInfoDTO.getIssueId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inRdmIssueInfoDTO.setIssueId(seqService.nextSequence("RDM-RSK-SEQ", inRdmIssueInfoDTO.getProjectId()));
        }
        this.setUserInfoToVO(inRdmIssueInfoDTO);
        inRdmIssueInfoDTO.setCreateUser(inRdmIssueInfoDTO.getLoginUserId());
        inRdmIssueInfoDTO.setCreateUserName(inRdmIssueInfoDTO.getLoginUserName());
        inRdmIssueInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inRdmIssueInfoDTO.setLastUpdateUser(inRdmIssueInfoDTO.getLoginUserId());
        inRdmIssueInfoDTO.setLastUpdateTime(inRdmIssueInfoDTO.getCreateTime());
        int outputVo = ((RdmIssueInfoService)this.getService()).insert((Object)inRdmIssueInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/issue/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxId() {
        return this.getResponseData(((RdmIssueInfoService)this.getService()).queryMaxId());
    }

    @RequestMapping(value={"/api/rdm/issue/info/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmIssueSummaryByPage(RdmIssueInfoDTO param) {
        List homePageVOList = ((RdmIssueInfoService)this.getService()).queryRdmIssueSummaryByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/issue/info/incharge/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmIssueInchargeByPage(RdmIssueInfoDTO param) {
        List homePageVOList = ((RdmIssueInfoService)this.getService()).queryRdmIssueInchargeByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/client/RdmIssueInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody RdmIssueInfoDTO param) {
        return ((RdmIssueInfoService)this.getService()).deleteByCond(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/rdm/issue/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadUpdateExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", "\u4e0d\u7b26\u5408\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String subsName = "";
            String projectName = "";
            String appName = "";
            if (StringUtils.isNotBlank((CharSequence)subsId)) {
                SSubsInfoDTO sSubsInfoDTO = new SSubsInfoDTO();
                sSubsInfoDTO.setSubsId(subsId);
                sSubsInfoDTO = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfoDTO);
                if (sSubsInfoDTO != null) {
                    subsName = sSubsInfoDTO.getSubsName();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                RdmProjectInfoDTO rdmProjectInfoDTO = new RdmProjectInfoDTO();
                rdmProjectInfoDTO.setProjectId(projectId);
                rdmProjectInfoDTO = (RdmProjectInfoDTO)this.rdmProjectInfoService.queryByPk((Object)rdmProjectInfoDTO);
                if (rdmProjectInfoDTO != null) {
                    projectName = rdmProjectInfoDTO.getProjectName();
                }
            }
            String userId = this.getUserInfo().getUserId();
            String key = UUIDUtil.getShortUUID();
            IssueExcelItemListener listener = new IssueExcelItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmIssueInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(tmp -> {
                    tmp.setSubsId(subsId);
                    tmp.setProjectId(projectId);
                });
                ((RdmIssueInfoService)this.getService()).saveExcel(userId, subsId, subsName, projectId, projectName, excelUploadType, list);
            }
            responseData = this.getResponseData(key, "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    @RequestMapping(value={"/api/rdm/issue/info/incharges"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmIssueInchargeGroupByPage(RdmIssueInfoDTO param) {
        List outputVo = ((RdmIssueInfoService)this.getService()).queryRdmIssueInchargeGroupByPage(param);
        return this.getResponseData(outputVo);
    }

    public static class CellItem {
        @ExcelProperty(value={"\u7f16\u53f7"})
        private String seq;
        @ExcelProperty(value={"\u7c7b\u522b"})
        private String issueCategory;
        @ExcelProperty(value={"\u7c7b\u578b"})
        private String issueType;
        @ExcelProperty(value={"\u4f18\u5148\u7ea7"})
        private String issuePriority;
        @ExcelProperty(value={"\u63cf\u8ff0"})
        private String issueContent;
        @ExcelProperty(value={"\u5f71\u54cd\u8303\u56f4"})
        private String issueInfluence;
        @ExcelProperty(value={"\u63d0\u51fa\u4eba"})
        private String proposerName;
        @ExcelProperty(value={"\u8d23\u4efb\u4eba"})
        private String inchargeName;
        @ExcelProperty(value={"\u63d0\u51fa\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5")
        private String issueStarted;
        @ExcelProperty(value={"\u89e3\u51b3\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5")
        private String issueDeadline;
        @ExcelProperty(value={"\u72b6\u6001"})
        private String issueState;
        @ExcelProperty(value={"\u5904\u7406\u60c5\u51b5\u8bf4\u660e"})
        private String issueHandleDesc;

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getIssueCategory() {
            return this.issueCategory;
        }

        public void setIssueCategory(String issueCategory) {
            this.issueCategory = issueCategory;
        }

        public String getIssueType() {
            return this.issueType;
        }

        public void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public String getIssuePriority() {
            return this.issuePriority;
        }

        public void setIssuePriority(String issuePriority) {
            this.issuePriority = issuePriority;
        }

        public String getIssueContent() {
            return this.issueContent;
        }

        public void setIssueContent(String issueContent) {
            this.issueContent = issueContent;
        }

        public String getIssueInfluence() {
            return this.issueInfluence;
        }

        public void setIssueInfluence(String issueInfluence) {
            this.issueInfluence = issueInfluence;
        }

        public String getProposerName() {
            return this.proposerName;
        }

        public void setProposerName(String proposerName) {
            this.proposerName = proposerName;
        }

        public String getInchargeName() {
            return this.inchargeName;
        }

        public void setInchargeName(String inchargeName) {
            this.inchargeName = inchargeName;
        }

        public String getIssueStarted() {
            return this.issueStarted;
        }

        public void setIssueStarted(String issueStarted) {
            this.issueStarted = issueStarted;
        }

        public String getIssueDeadline() {
            return this.issueDeadline;
        }

        public void setIssueDeadline(String issueDeadline) {
            this.issueDeadline = issueDeadline;
        }

        public String getIssueState() {
            return this.issueState;
        }

        public void setIssueState(String issueState) {
            this.issueState = issueState;
        }

        public String getIssueHandleDesc() {
            return this.issueHandleDesc;
        }

        public void setIssueHandleDesc(String issueHandleDesc) {
            this.issueHandleDesc = issueHandleDesc;
        }
    }

    public static class IssueExcelItemListener
    extends AnalysisEventListener<CellItem> {
        private List<RdmIssueInfoDTO> list = new ArrayList<RdmIssueInfoDTO>();

        public List<RdmIssueInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            RdmIssueInfoDTO vo = new RdmIssueInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setIssueCategory(IssueCategory.codeByName((String)data.getIssueCategory()));
            vo.setIssueType(IssueType.codeByName((String)data.getIssueType()));
            vo.setIssuePriority(IssuePriority.codeByName((String)data.getIssuePriority()));
            vo.setIssueState(IssueState.codeByName((String)data.getIssueState()));
            vo.setIssueStarted(DateUtility.parseExcelUploadDateString((String)vo.getIssueStarted(), null));
            vo.setIssueDeadline(DateUtility.parseExcelUploadDateString((String)vo.getIssueDeadline(), null));
            vo.setIssueName(StringUtils.substring((String)vo.getIssueContent(), (int)0, (int)250));
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

