/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmProjectInfoController
extends BaseController<RdmProjectInfoDTO, RdmProjectInfoService> {
    @RequestMapping(value={"/api/rdm/project/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmProjectInfoDTO>> queryRdmProjectInfoAll(RdmProjectInfoDTO dto) {
        this.setUserInfoToVO(dto);
        List outputVo = ((RdmProjectInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/info/{projectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmProjectInfoDTO> queryByPk(@PathVariable(value="projectId") String projectId) {
        RdmProjectInfoDTO inVo = new RdmProjectInfoDTO();
        inVo.setProjectId(projectId);
        RdmProjectInfoDTO outputVo = (RdmProjectInfoDTO)((RdmProjectInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmProjectInfoDTO inRdmProjectInfoDTO) {
        int outputVo = ((RdmProjectInfoService)this.getService()).deleteByPk((Object)inRdmProjectInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmProjectInfoDTO inRdmProjectInfoDTO) {
        int outputVo = ((RdmProjectInfoService)this.getService()).updateByPk((Object)inRdmProjectInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertRdmProjectInfo(@RequestBody RdmProjectInfoDTO inRdmProjectInfoDTO) {
        if (StringUtils.isBlank((CharSequence)inRdmProjectInfoDTO.getProjectId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inRdmProjectInfoDTO.setProjectId(seqService.nextSequence("RDM-PRJ-SEQ", inRdmProjectInfoDTO.getProjectType()));
        }
        this.setUserInfoToVO(inRdmProjectInfoDTO);
        int outputVo = ((RdmProjectInfoService)this.getService()).insert((Object)inRdmProjectInfoDTO);
        return this.getResponseData(inRdmProjectInfoDTO.getProjectId());
    }

    @RequestMapping(value={"/api/rdm/project/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxId() {
        String outputVo = ((RdmProjectInfoService)this.getService()).queryMaxId();
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmSummary(RdmProjectInfoDTO param) {
        List homePageVOList = ((RdmProjectInfoService)this.getService()).queryRdmSummary(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/project/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmProjectSummary(RdmProjectInfoDTO param) {
        List homePageVOList = ((RdmProjectInfoService)this.getService()).queryRdmProjectSummary(param);
        return this.getResponseData(homePageVOList);
    }
}

