/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.sam.console.facade.RdmMenuInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.RdmMenuInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.MenuLevel;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class RdmMenuInfoController
extends BaseController<RdmMenuInfoDTO, RdmMenuInfoService> {
    @RequestMapping(value={"/api/rdm/menu/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmMenuInfoDTO>> queryRdmMenuInfoAll(RdmMenuInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getAppId(), (CharSequence)",")) {
            dto.setAppIdList(Arrays.asList(StringUtils.split((String)dto.getAppId(), (String)",")));
            dto.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getComId(), (CharSequence)",")) {
            dto.setComIdList(Arrays.asList(StringUtils.split((String)dto.getComId(), (String)",")));
            dto.setComId(null);
        }
        List outputVo = ((RdmMenuInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/menu/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmMenuInfoDTO>> queryList(RdmMenuInfoDTO dto) {
        List outputVo = ((RdmMenuInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/menu/info/{fnId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmMenuInfoDTO> queryByPk(@PathVariable(value="fnId") String fnId) {
        RdmMenuInfoDTO inVo = new RdmMenuInfoDTO();
        inVo.setFnId(fnId);
        RdmMenuInfoDTO outputVo = (RdmMenuInfoDTO)((RdmMenuInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/menu/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmMenuInfoDTO inRdmMenuInfoDTO) {
        int outputVo = ((RdmMenuInfoService)this.getService()).deleteByPk((Object)inRdmMenuInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/menu/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmMenuInfoDTO inRdmMenuInfoDTO) {
        this.setUserInfoToVO(inRdmMenuInfoDTO);
        inRdmMenuInfoDTO.setUpdateUser(inRdmMenuInfoDTO.getLoginUserId());
        inRdmMenuInfoDTO.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RdmMenuInfoService)this.getService()).updateByPk((Object)inRdmMenuInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/menu/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertRdmMenuInfo(@RequestBody RdmMenuInfoDTO inRdmMenuInfoDTO) {
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmMenuInfoDTO);
        inRdmMenuInfoDTO.setCreateUser(userId);
        inRdmMenuInfoDTO.setCreateTime(now);
        inRdmMenuInfoDTO.setUpdateUser(userId);
        inRdmMenuInfoDTO.setUpdateTime(now);
        int re = ((RdmMenuInfoService)this.getService()).insert((Object)inRdmMenuInfoDTO);
        return this.getResponseData(inRdmMenuInfoDTO.getFnId());
    }

    @PostMapping(value={"/api/rdm/menu/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="comId", required=false) String comId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        try {
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmMenuInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    ((RdmMenuInfoService)this.getService()).deleteBySubsId(subsId);
                }
                ((RdmMenuInfoService)this.getService()).saveExcel(subsId, this.getUserInfo().getUserId(), appId, comId, list);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(" \u83dc\u5355\u70b9\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    @RequestMapping(value={"/client/RdmMenuInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody RdmMenuInfoDTO param) {
        return ((RdmMenuInfoService)this.getService()).deleteByCond(param);
    }

    @RequestMapping(value={"/api/rdm/menu/info/code"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryCodeWithSubsId(@RequestParam(value="subsId") String subsId, @RequestParam(value="fnType2", required=false) String fnType2) {
        String outputVo = ((RdmMenuInfoService)this.getService()).queryCodeWithPrefix(subsId, fnType2);
        return this.getResponseData(outputVo);
    }

    public static class CellItem {
        @ExcelProperty(value={"\u6a21\u5757"})
        private String moduleName;
        @ExcelProperty(value={"\u83dc\u5355\u7f16\u53f7"})
        private String fnCode;
        @ExcelProperty(value={"\u83dc\u5355\u540d\u79f0"})
        private String fnName;
        @ExcelProperty(value={"\u83dc\u5355\u5c42\u7ea7"})
        private String fnLevelName;
        @ExcelProperty(value={"\u4e0a\u7ea7\u83dc\u5355"})
        private String fnAbvName;
        @ExcelProperty(value={"\u83dc\u5355\u63cf\u8ff0"})
        private String fnDesc;
        @ExcelProperty(value={"\u83dc\u5355\u6392\u5e8f"})
        private Integer fnOrder;
        @ExcelProperty(value={"\u83dc\u5355\u94fe\u63a5"})
        private String fnUrl;
        @ExcelProperty(value={"\u5e94\u7528\u6807\u8bc6"})
        private String appId;
        @ExcelProperty(value={"\u5e94\u7528\u7b80\u79f0"})
        private String appCode;
        @ExcelProperty(value={"\u5e94\u7528\u540d\u79f0"})
        private String appName;
        @ExcelProperty(value={"\u7ec4\u4ef6\u7f16\u53f7"})
        private String comId;
        @ExcelProperty(value={"\u7ec4\u4ef6\u540d\u79f0"})
        private String comName;

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getFnCode() {
            return this.fnCode;
        }

        public void setFnCode(String fnCode) {
            this.fnCode = fnCode;
        }

        public String getFnName() {
            return this.fnName;
        }

        public void setFnName(String fnName) {
            this.fnName = fnName;
        }

        public String getFnLevelName() {
            return this.fnLevelName;
        }

        public void setFnLevelName(String fnLevelName) {
            this.fnLevelName = fnLevelName;
        }

        public String getFnAbvName() {
            return this.fnAbvName;
        }

        public void setFnAbvName(String fnAbvName) {
            this.fnAbvName = fnAbvName;
        }

        public String getFnDesc() {
            return this.fnDesc;
        }

        public void setFnDesc(String fnDesc) {
            this.fnDesc = fnDesc;
        }

        public Integer getFnOrder() {
            return this.fnOrder;
        }

        public void setFnOrder(Integer fnOrder) {
            this.fnOrder = fnOrder;
        }

        public String getFnUrl() {
            return this.fnUrl;
        }

        public void setFnUrl(String fnUrl) {
            this.fnUrl = fnUrl;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getComId() {
            return this.comId;
        }

        public void setComId(String comId) {
            this.comId = comId;
        }

        public String getComName() {
            return this.comName;
        }

        public void setComName(String comName) {
            this.comName = comName;
        }
    }

    public static class AppResourceItemListener
    extends AnalysisEventListener<CellItem> {
        private List<RdmMenuInfoDTO> list = new ArrayList<RdmMenuInfoDTO>();

        public List<RdmMenuInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            RdmMenuInfoDTO vo = new RdmMenuInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setFnLevel(Integer.valueOf(NumberUtils.toInt((String)MenuLevel.codeByName((String)data.getFnLevelName()))));
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

