/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.SdkComFileService;
import com.irdstudio.allinrdm.sam.console.facade.dto.SdkComFileDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SdkComFileController
extends BaseController<SdkComFileDTO, SdkComFileService> {
    @RequestMapping(value={"/api/sdk/com/sources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SdkComFileDTO>> querySdkComFileAll(SdkComFileDTO dto) {
        List outputVo = ((SdkComFileService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/sources/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SdkComFileDTO>> queryList(SdkComFileDTO dto) {
        List outputVo = ((SdkComFileService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/file/{sourceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SdkComFileDTO> queryByPk(@PathVariable(value="sourceId") String sourceId) {
        SdkComFileDTO inVo = new SdkComFileDTO();
        inVo.setSourceId(sourceId);
        SdkComFileDTO outputVo = (SdkComFileDTO)((SdkComFileService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/file"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SdkComFileDTO inSdkComFileDTO) {
        int outputVo = ((SdkComFileService)this.getService()).deleteByPk((Object)inSdkComFileDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/file"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SdkComFileDTO inSdkComFileDTO) {
        this.setUserInfoToVO(inSdkComFileDTO);
        inSdkComFileDTO.setUpdateUser(inSdkComFileDTO.getLoginUserId());
        inSdkComFileDTO.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((SdkComFileService)this.getService()).updateByPk((Object)inSdkComFileDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/file"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSdkComFile(@RequestBody SdkComFileDTO inSdkComFileDTO) {
        if (StringUtils.isBlank((CharSequence)inSdkComFileDTO.getSourceId())) {
            inSdkComFileDTO.setSourceId(UUIDUtil.getUUID());
        }
        this.setUserInfoToVO(inSdkComFileDTO);
        inSdkComFileDTO.setCreateUser(inSdkComFileDTO.getLoginUserId());
        inSdkComFileDTO.setUpdateUser(inSdkComFileDTO.getLoginUserId());
        inSdkComFileDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inSdkComFileDTO.setUpdateTime(inSdkComFileDTO.getCreateTime());
        int outputVo = ((SdkComFileService)this.getService()).insert((Object)inSdkComFileDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sdk/com/file/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSdkComFileList(@RequestParam(value="comId") String comId, @RequestBody List<SdkComFileDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            ((SdkComFileService)this.getService()).deleteByCommId(comId);
            String userId = this.getUserInfo().getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            for (SdkComFileDTO source : list) {
                if (StringUtils.isBlank((CharSequence)source.getSourceId())) {
                    source.setSourceId(UUIDUtil.getUUID());
                }
                source.setCreateUser(userId);
                source.setUpdateUser(userId);
                source.setCreateTime(nowTime);
                source.setUpdateTime(nowTime);
            }
            int outputVo = ((SdkComFileService)this.getService()).batchInsert(list);
            return this.getResponseData(outputVo);
        }
        return this.getResponseData(0);
    }

    @RequestMapping(value={"/client/SdkComFileService/deleteByCommId"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer deleteByCommId(@RequestParam(value="comId") String comId) {
        return ((SdkComFileService)this.getService()).deleteByCommId(comId);
    }
}

