/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.StdFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class StdFolderInfoController
extends BaseController<StdFolderInfoDTO, StdFolderInfoService> {
    @RequestMapping(value={"/api/std/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<StdFolderInfoDTO>> queryStdFolderInfoAll(StdFolderInfoDTO dto) {
        List outputVo = ((StdFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<StdFolderInfoDTO>> queryList(StdFolderInfoDTO dto) {
        List outputVo = ((StdFolderInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<StdFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        StdFolderInfoDTO inVo = new StdFolderInfoDTO();
        inVo.setFolderId(folderId);
        StdFolderInfoDTO outputVo = (StdFolderInfoDTO)((StdFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody StdFolderInfoDTO inStdFolderInfoDTO) {
        int outputVo = ((StdFolderInfoService)this.getService()).deleteByPk((Object)inStdFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody StdFolderInfoDTO inStdFolderInfoDTO) {
        this.setUserInfoToVO(inStdFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdFolderInfoDTO.setLastModifyUser(userId);
        inStdFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((StdFolderInfoService)this.getService()).updateByPk((Object)inStdFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertStdFolderInfo(@RequestBody StdFolderInfoDTO inStdFolderInfoDTO) {
        this.setUserInfoToVO(inStdFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdFolderInfoDTO.setCreateUser(userId);
        inStdFolderInfoDTO.setCreateTime(now);
        inStdFolderInfoDTO.setLastModifyUser(userId);
        inStdFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inStdFolderInfoDTO.getFolderId())) {
            inStdFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((StdFolderInfoService)this.getService()).insert((Object)inStdFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/std/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody StdFolderInfoDTO paramDTO, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((StdFolderInfoService)this.getService()).folderMerge(paramDTO, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/std/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody StdFolderInfoDTO paramDTO) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((StdFolderInfoService)this.getService()).folderMove(paramDTO);
        return this.getResponseData(outputVo);
    }
}

