/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.web.controller.api;

import com.irdstudio.allinrdm.wiki.console.facade.WikiSubsPageService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsPageDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WikiSubsPageController
extends BaseController<WikiSubsPageDTO, WikiSubsPageService> {
    @Autowired
    @Qualifier(value="wikiSubsPageServiceImpl")
    private WikiSubsPageService wikiSubsPageService;

    @RequestMapping(value={"/api/wiki/subs/pages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiSubsPageDTO>> queryWikiSubsPageAll(WikiSubsPageDTO vo) {
        List outputVo = this.wikiSubsPageService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page/{docId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<WikiSubsPageDTO> queryByPk(@PathVariable(value="docId") String docId) {
        WikiSubsPageDTO inVo = new WikiSubsPageDTO();
        inVo.setDocId(docId);
        WikiSubsPageDTO outputVo = (WikiSubsPageDTO)this.wikiSubsPageService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        int outputVo = this.wikiSubsPageService.deleteByPk((Object)inWikiSubsPageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        int outputVo = this.wikiSubsPageService.updateByPk((Object)inWikiSubsPageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page/score"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateScoreByPk(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        WikiSubsPageDTO dbObj = (WikiSubsPageDTO)this.wikiSubsPageService.queryByPk((Object)inWikiSubsPageDTO);
        BigDecimal oldScore = dbObj.getDocScore();
        if (oldScore == null || oldScore.compareTo(BigDecimal.ZERO) == 0) {
            oldScore = inWikiSubsPageDTO.getDocScore();
        }
        BigDecimal newScore = inWikiSubsPageDTO.getDocScore();
        BigDecimal avgScore = oldScore.add(newScore).divide(new BigDecimal(2), 1, 4);
        inWikiSubsPageDTO.setDocScore(avgScore);
        int outputVo = this.wikiSubsPageService.updateByPk((Object)inWikiSubsPageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertWikiSubsPage(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        if (StringUtils.isBlank((CharSequence)inWikiSubsPageDTO.getDocId())) {
            inWikiSubsPageDTO.setDocId(UUIDUtil.getUUID());
        }
        inWikiSubsPageDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inWikiSubsPageDTO.setCreateUser(this.getUserInfo().getUserId());
        inWikiSubsPageDTO.setDocVersion("V1.0.0");
        if (StringUtils.isNotBlank((CharSequence)inWikiSubsPageDTO.getWikiId()) && StringUtils.isBlank((CharSequence)inWikiSubsPageDTO.getSubsId())) {
            inWikiSubsPageDTO.setSubsId(inWikiSubsPageDTO.getWikiId());
        }
        int outputVo = this.wikiSubsPageService.insert((Object)inWikiSubsPageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSubPage(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        Object checkObj = new WikiSubsPageDTO();
        checkObj.setDocTitle(inWikiSubsPageDTO.getDocTitle());
        checkObj.setDirId(inWikiSubsPageDTO.getDirId());
        checkObj.setSubsCode(inWikiSubsPageDTO.getSubsCode());
        checkObj.setDocType(inWikiSubsPageDTO.getDocType());
        List checkList = this.wikiSubsPageService.queryListByPage(checkObj);
        checkObj = CollectionUtils.isNotEmpty((Collection)checkList) ? (WikiSubsPageDTO)checkList.get(0) : null;
        int outputVo = 0;
        if (checkObj != null) {
            inWikiSubsPageDTO.setDocId(checkObj.getDocId());
            inWikiSubsPageDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inWikiSubsPageDTO.setCreateUser(inWikiSubsPageDTO.getLoginUserId());
            outputVo = this.wikiSubsPageService.updateByPk((Object)inWikiSubsPageDTO);
        } else {
            if (StringUtils.isBlank((CharSequence)inWikiSubsPageDTO.getDocId())) {
                inWikiSubsPageDTO.setDocId(UUIDUtil.getUUID());
            }
            inWikiSubsPageDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inWikiSubsPageDTO.setCreateUser(inWikiSubsPageDTO.getLoginUserId());
            inWikiSubsPageDTO.setDocVersion("V1.0.0");
            outputVo = this.wikiSubsPageService.insert((Object)inWikiSubsPageDTO);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/WikiSubsPageService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody WikiSubsPageDTO param) {
        return ((WikiSubsPageService)this.getService()).deleteByCond(param);
    }
}

