/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.web.controller.api;

import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyInfoService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmWeeklyInfoController
extends BaseController<RdmWeeklyInfoDTO, RdmWeeklyInfoService> {
    @RequestMapping(value={"/api/rdm/weekly/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWeeklyInfoDTO>> queryRdmWeeklyInfoAll(RdmWeeklyInfoDTO dto) {
        List outputVo = ((RdmWeeklyInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/info/{reportId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWeeklyInfoDTO> queryByPk(@PathVariable(value="reportId") String reportId) {
        RdmWeeklyInfoDTO inVo = new RdmWeeklyInfoDTO();
        inVo.setReportId(reportId);
        RdmWeeklyInfoDTO outputVo = (RdmWeeklyInfoDTO)((RdmWeeklyInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmWeeklyInfoDTO inRdmWeeklyInfoDTO) {
        int outputVo = ((RdmWeeklyInfoService)this.getService()).deleteByPk((Object)inRdmWeeklyInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmWeeklyInfoDTO inRdmWeeklyInfoDTO) {
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyInfoDTO);
        inRdmWeeklyInfoDTO.setLastModifyUser(userInfo.getUserId());
        inRdmWeeklyInfoDTO.setLastModifyTime(now);
        int outputVo = ((RdmWeeklyInfoService)this.getService()).updateByPk((Object)inRdmWeeklyInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWeeklyInfo(@RequestBody RdmWeeklyInfoDTO inRdmWeeklyInfoDTO) {
        UserInfo userInfo = this.getUserInfo();
        String now = CurrentDateUtil.getTodayDateEx2();
        this.setUserInfoToVO(inRdmWeeklyInfoDTO);
        if (StringUtils.isBlank((CharSequence)inRdmWeeklyInfoDTO.getReportId())) {
            inRdmWeeklyInfoDTO.setReportId(UUIDUtil.getShortUUID());
        } else {
            RdmWeeklyInfoDTO weeklyInfo = (RdmWeeklyInfoDTO)((RdmWeeklyInfoService)this.getService()).queryByPk((Object)inRdmWeeklyInfoDTO);
            if (weeklyInfo != null) {
                inRdmWeeklyInfoDTO.setLastModifyUser(userInfo.getUserId());
                inRdmWeeklyInfoDTO.setLastModifyTime(now);
                int outputVo = ((RdmWeeklyInfoService)this.getService()).updateByPk((Object)inRdmWeeklyInfoDTO);
                return this.getResponseData(outputVo);
            }
        }
        inRdmWeeklyInfoDTO.setCreateUser(userInfo.getUserId());
        inRdmWeeklyInfoDTO.setCreateUserName(userInfo.getUserName());
        inRdmWeeklyInfoDTO.setCreateTime(now);
        inRdmWeeklyInfoDTO.setLastModifyUser(userInfo.getUserId());
        inRdmWeeklyInfoDTO.setLastModifyTime(now);
        int outputVo = ((RdmWeeklyInfoService)this.getService()).insert((Object)inRdmWeeklyInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryReportId() {
        return this.getResponseData(UUIDUtil.getShortUUID());
    }

    @RequestMapping(value={"/api/rdm/weekly/info/thisweek"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> initThisWeekReport(@RequestParam(value="date") String date) {
        int output = ((RdmWeeklyInfoService)this.getService()).initThisWeekReport(date);
        return this.getResponseData(output, "\u7528\u6237\u5468\u62a5\u521d\u59cb\u5316\u5b8c\u6210", "\u7528\u6237\u5468\u62a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    @RequestMapping(value={"/client/RdmWeeklyInfoService/initThisWeekReport"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer initThisWeekReportForClient(@RequestParam(value="date") String date) {
        return ((RdmWeeklyInfoService)this.getService()).initThisWeekReport(date);
    }

    @RequestMapping(value={"/api/rdm/weekly/info/thisweek/project"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> initThisWeekProjectReport(@RequestParam(value="projectId") String projectId, @RequestParam(value="genOption") String genOption, @RequestParam(value="weekId") String weekId, @RequestParam(value="overrideFlag") String overrideFlag) {
        int output = ((RdmWeeklyInfoService)this.getService()).initThisWeekProjectReport(projectId, genOption, weekId, overrideFlag);
        return this.getResponseData(output, "\u9879\u76ee\u6210\u5458\u5468\u62a5\u521d\u59cb\u5316\u5b8c\u6210", "\u9879\u76ee\u6210\u5458\u5468\u62a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    @RequestMapping(value={"/client/RdmWeeklyInfoService/initThisWeekProjectReport"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer initThisWeekProjectReport_client(@RequestParam(value="projectId") String projectId, @RequestParam(value="genOption") String genOption, @RequestParam(value="weekId") String weekId, @RequestParam(value="overrideFlag") String overrideFlag) {
        return ((RdmWeeklyInfoService)this.getService()).initThisWeekProjectReport(projectId, genOption, weekId, overrideFlag);
    }

    @RequestMapping(value={"/client/RdmWeeklyInfoService/queryMessageSummary"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryMessageSummary(@RequestBody RdmWeeklyInfoDTO param) {
        return ((RdmWeeklyInfoService)this.getService()).queryMessageSummary(param);
    }

    @RequestMapping(value={"/api/rdm/weekly/info/fill"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> autoFillWeek(@RequestBody RdmWeeklyInfoDTO rdmWeeklyInfoDTO) {
        RdmWeeklyInfoDTO weeklyInfo = (RdmWeeklyInfoDTO)((RdmWeeklyInfoService)this.getService()).queryByPk((Object)rdmWeeklyInfoDTO);
        if (weeklyInfo == null) {
            UserInfo userInfo = this.getUserInfo();
            String now = CurrentDateUtil.getTodayDateEx2();
            this.setUserInfoToVO(rdmWeeklyInfoDTO);
            rdmWeeklyInfoDTO.setCreateUser(userInfo.getUserId());
            rdmWeeklyInfoDTO.setCreateUserName(userInfo.getUserName());
            rdmWeeklyInfoDTO.setCreateTime(now);
            rdmWeeklyInfoDTO.setLastModifyUser(userInfo.getUserId());
            rdmWeeklyInfoDTO.setLastModifyTime(now);
            int n = ((RdmWeeklyInfoService)this.getService()).insert((Object)rdmWeeklyInfoDTO);
        }
        int outputVO = ((RdmWeeklyInfoService)this.getService()).autoFillWeek(rdmWeeklyInfoDTO);
        return this.getResponseData(outputVO);
    }
}

