/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinrdm.dam.console.facade.DictCategoryInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictDevLogService;
import com.irdstudio.allinrdm.dam.console.facade.DictItemInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictDevLogDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictItemInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DamDictInfoController
extends AbstractController {
    @Value(value="${tdp.docs.path:}")
    private String DOCS_PATH;
    @Autowired
    private DictDevLogService dictDevLogService;
    @Autowired
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    private DictCategoryInfoService dictCategoryInfoService;
    @Autowired
    private DictItemInfoService dictItemInfoService;
    private final int loadPageSize = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/dict/item/info/download"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            String today = CurrentDateUtil.getTodayDate();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + "xlsx" + File.separator + "\u6570\u636e\u6807\u51c6_\u57fa\u7840\u6570\u636e\u6807\u51c6-\u6a21\u677f.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            String downloadFileName = String.format("\u6570\u636e\u5f00\u53d1\u5e73\u53f0_\u6570\u636e\u6807\u51c6_%s.xlsx", today);
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(downloadFileName.getBytes(), "iso-8859-1"));
            File targetFile = new File(this.DOCS_PATH, downloadFileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet indexSheet = EasyExcel.writerSheet((Integer)0, (String)"\u5c01\u9762").build();
            IndexExcelData indexData = new IndexExcelData();
            indexData.setToday(today);
            excelWriter.fill((Object)indexData, indexSheet);
            WriteSheet devLogSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u5386\u53f2\u53d8\u66f4\u8bb0\u5f55").head(DictDevLogDTO.class)).build();
            this.devLogData(excelWriter, devLogSheet);
            WriteSheet optionSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)2, (String)"\u516c\u5171\u4ee3\u7801\u9879").head(DictOptionEnumDTO.class)).build();
            this.optionData(excelWriter, optionSheet);
            WriteSheet itemSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)3, (String)"\u6570\u636e\u6807\u51c6\u9879").head(DictItemInfoDTO.class)).build();
            this.itemData(excelWriter, itemSheet);
            excelWriter.finish();
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(targetFile));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    public void devLogData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictDevLogDTO param = new DictDevLogDTO();
        param.setSize(Integer.valueOf(500));
        List list = this.dictDevLogService.queryListByPage((Object)param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.dictDevLogService.queryListByPage((Object)param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void optionData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictOptionEnumDTO param = new DictOptionEnumDTO();
        param.setSize(Integer.valueOf(500));
        List list = this.dictOptionEnumService.queryAllOptionForExcel(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.dictOptionEnumService.queryAllOptionForExcel(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void itemData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictItemInfoDTO param = new DictItemInfoDTO();
        param.setSize(Integer.valueOf(500));
        List list = this.dictItemInfoService.queryAllForExcelByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.dictItemInfoService.queryAllForExcelByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public static class IndexExcelData {
        private String today;

        public String getToday() {
            return this.today;
        }

        public void setToday(String today) {
            this.today = today;
        }
    }
}

