/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelJoinDetailService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisFieldExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisIndexExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisTableExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TablePropertyUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class ModelTableInfoController
extends BaseController<ModelTableInfoDTO, ModelTableInfoService> {
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
    @Autowired
    private ModelFolderInfoService modelFolderInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private ModelTableIndexService modelTableIndexService;
    @Autowired
    private ModelJoinDetailService modelJoinDetailService;

    @PostMapping(value={"/api/model/table/info"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u65b0\u5efa\u8868\u6a21\u578b ${args[0].objectCode} ${args[0].objectName}", objectId="${args[0].objectId}", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<String> insertModelTableInfo(@RequestBody ModelTableInfoDTO inModelTableInfoVo) {
        if (StringUtils.isBlank((CharSequence)inModelTableInfoVo.getObjectId())) {
            inModelTableInfoVo.setObjectId(UUIDUtil.getUUID());
        }
        inModelTableInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inModelTableInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inModelTableInfoVo.setObjectCode(StringUtils.trim((String)inModelTableInfoVo.getObjectCode()));
        if (!StringUtil.isJavaIdentifier((String)inModelTableInfoVo.getObjectCode())) {
            ResponseData res = this.getResponseData("-1");
            res.setMessage("\u8868\u6a21\u578b\u4ee3\u7801\u547d\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
            return res;
        }
        int outputVo = ((ModelTableInfoService)this.getService()).insert((Object)inModelTableInfoVo);
        return this.getResponseData(inModelTableInfoVo.getObjectId());
    }

    @DeleteMapping(value={"/api/model/table/info"})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u8868\u6a21\u578b ${args[0].objectId}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelTableInfoDTO inModelTableInfoVo) {
        this.modelTableFieldService.deleteByObjectId(inModelTableInfoVo.getObjectId());
        this.modelTableIndexService.deleteByObjectId(inModelTableInfoVo.getObjectId());
        int outputVo = ((ModelTableInfoService)this.getService()).deleteByPk((Object)inModelTableInfoVo);
        this.modelJoinDetailService.deleteByJoinDetailId(inModelTableInfoVo.getObjectId());
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/model/table/info"})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u8868\u6a21\u578b ${args[0].objectCode} ${args[0].objectName} ", objectId="${args[0].objectId}", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ModelTableInfoDTO inModelTableInfoVo) {
        inModelTableInfoVo.setObjectCode(StringUtils.trim((String)inModelTableInfoVo.getObjectCode()));
        this.setUserInfoToVO(inModelTableInfoVo);
        inModelTableInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        if (!StringUtil.isJavaIdentifier((String)inModelTableInfoVo.getObjectCode())) {
            ResponseData res = this.getResponseData(-1);
            res.setMessage("\u8868\u6a21\u578b\u4ee3\u7801\u547d\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
            return res;
        }
        int outputVo = ((ModelTableInfoService)this.getService()).updateByPk((Object)inModelTableInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/info/{objectId}"})
    @ResponseBody
    public ResponseData<ModelTableInfoDTO> queryByPk(@PathVariable(value="objectId") String objectId) {
        ModelTableInfoDTO inVo = new ModelTableInfoDTO();
        inVo.setObjectId(objectId);
        ModelTableInfoDTO outputVo = (ModelTableInfoDTO)((ModelTableInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/merge"})
    @ResponseBody
    public ResponseData<Integer> mergeToTargetTable(@RequestParam(value="objectId") String objectId, @RequestParam(value="srcObjectId") String srcObjectId) {
        try {
            int rs = this.modelTableFieldService.mergeModelTableField(objectId, srcObjectId);
            return this.getResponseData(rs);
        }
        catch (Exception e) {
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @GetMapping(value={"/api/model/table/copy/tb/template"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u6309\u8868\u6a21\u677f\u521b\u5efa ${args[0]}  ${args[1]}", objectId="${args[0]}", appId="${args[1]}")
    @ResponseBody
    public ResponseData<String> copyTbTemplateTo(@RequestParam(value="objectId") String objectId, @RequestParam(value="baAppId") String baAppId, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="folderId") String folderId, @RequestParam(value="objectType") int objectType) {
        ModelTableInfoDTO inVo = new ModelTableInfoDTO();
        inVo.setObjectId(objectId);
        ModelTableInfoDTO modelTableInfo = (ModelTableInfoDTO)((ModelTableInfoService)this.getService()).queryByPk((Object)inVo);
        modelTableInfo.setObjectId(UUIDUtil.getUUID());
        modelTableInfo.setCreateUser(this.getUserInfo().getUserId());
        modelTableInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        ModelFolderInfoDTO targetFolder = new ModelFolderInfoDTO();
        targetFolder.setFolderId(folderId);
        targetFolder = (ModelFolderInfoDTO)this.modelFolderInfoService.queryByPk((Object)targetFolder);
        if (targetFolder != null) {
            modelTableInfo.setObjectLocation(targetFolder.getFolderLocation());
            modelTableInfo.setAppId(targetFolder.getAppId());
        }
        modelTableInfo.setFolderId(folderId);
        modelTableInfo.setObjectType(Integer.valueOf(objectType));
        modelTableInfo.setObjectCode(modelTableInfo.getObjectCode());
        modelTableInfo.setAppId(appId);
        modelTableInfo.setBaAppId(baAppId);
        modelTableInfo.setSubsId(subsId);
        int num = ((ModelTableInfoService)this.getService()).insert((Object)modelTableInfo);
        num = this.modelTableFieldService.copyModelTableField(objectId, modelTableInfo.getObjectId());
        num = this.modelTableIndexService.copyModelTableIndex(objectId, modelTableInfo.getObjectId());
        return this.getResponseData(modelTableInfo.getObjectId());
    }

    @GetMapping(value={"/api/model/table/copy/tb"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u590d\u5236\u8868\u6a21\u578b\u521b\u5efa ${args[0]}  ${args[1]}", objectId="${args[0]}", appId="${args[1]}")
    @ResponseBody
    public ResponseData<String> copyTo(@RequestParam(value="objectId") String objectId, @RequestParam(value="baAppId") String baAppId, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="folderId") String folderId, @RequestParam(value="objectType") int objectType) {
        ModelTableInfoDTO inVo = new ModelTableInfoDTO();
        inVo.setObjectId(objectId);
        ModelTableInfoDTO modelTableInfo = (ModelTableInfoDTO)((ModelTableInfoService)this.getService()).queryByPk((Object)inVo);
        modelTableInfo.setObjectId(UUIDUtil.getUUID());
        modelTableInfo.setCreateUser(this.getUserInfo().getUserId());
        modelTableInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        ModelFolderInfoDTO targetFolder = new ModelFolderInfoDTO();
        targetFolder.setFolderId(folderId);
        targetFolder = (ModelFolderInfoDTO)this.modelFolderInfoService.queryByPk((Object)targetFolder);
        if (targetFolder != null) {
            modelTableInfo.setObjectLocation(targetFolder.getFolderLocation());
            modelTableInfo.setAppId(targetFolder.getAppId());
        }
        modelTableInfo.setFolderId(folderId);
        modelTableInfo.setObjectType(Integer.valueOf(objectType));
        modelTableInfo.setObjectCode("copyOf" + modelTableInfo.getObjectCode());
        modelTableInfo.setAppId(appId);
        modelTableInfo.setBaAppId(baAppId);
        modelTableInfo.setSubsId(subsId);
        int num = ((ModelTableInfoService)this.getService()).insert((Object)modelTableInfo);
        num = this.modelTableFieldService.copyModelTableField(objectId, modelTableInfo.getObjectId());
        num = this.modelTableIndexService.copyModelTableIndex(objectId, modelTableInfo.getObjectId());
        return this.getResponseData(modelTableInfo.getObjectId());
    }

    @RequestMapping(value={"/api/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryModelTableInfoAll(ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableInfoService)this.getService()).queryListByPage((Object)vo);
        if (Objects.nonNull(outputVo) && outputVo.size() > 0 && StringUtils.isBlank((CharSequence)vo.getGroupBy())) {
            for (ModelTableInfoDTO infoVO : outputVo) {
                infoVO.setTableModelId(TablePropertyUtil.tableName2TableModelId((String)infoVO.getObjectCode()));
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/info/isolates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryAllIsolateTableByPage(ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableInfoService)this.getService()).queryAllIsolateTableByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/info/not/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryModelTableInfoAllNotPage(ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableInfoService)this.getService()).queryList((Object)vo);
        if (Objects.nonNull(outputVo) && outputVo.size() > 0) {
            for (ModelTableInfoDTO infoVO : outputVo) {
                infoVO.setTableModelId(TablePropertyUtil.tableName2TableModelId((String)infoVO.getObjectCode()));
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/project/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryProjectModelTableInfoAll(ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((ModelTableInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/all/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryAllModelTableInfo(@RequestBody ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        if (StringUtils.contains((CharSequence)vo.getAppId(), (CharSequence)",")) {
            vo.setAppIdList(Arrays.asList(StringUtils.split((String)vo.getAppId(), (String)",")));
            vo.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)vo.getComId(), (CharSequence)",")) {
            vo.setComIdList(Arrays.asList(StringUtils.split((String)vo.getComId(), (String)",")));
            vo.setComId(null);
        }
        if (StringUtils.contains((CharSequence)vo.getTableDataCycle(), (CharSequence)",")) {
            String[] arr = StringUtils.split((String)vo.getTableDataCycle(), (String)",");
            vo.setTableDataCycles(Arrays.asList(arr));
            vo.setTableDataCycle(null);
        }
        outputVo = ((ModelTableInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/infos/srv"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryAllModelTableInfoWithSrv(ModelTableInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        if (vo.getObjectType() != null && vo.getObjectType().equals(2001)) {
            vo.setObjectTypes(Arrays.asList("2001", "2003", "2004"));
            vo.setObjectType(null);
        } else if (StringUtils.contains((CharSequence)vo.getObjectTypeStr(), (CharSequence)",")) {
            vo.setObjectTypes(Arrays.asList(StringUtils.split((String)vo.getObjectTypeStr(), (String)",")));
        }
        if (StringUtils.contains((CharSequence)vo.getTableDataCycle(), (CharSequence)",")) {
            String[] arr = StringUtils.split((String)vo.getTableDataCycle(), (String)",");
            vo.setTableDataCycles(Arrays.asList(arr));
            vo.setTableDataCycle(null);
        }
        outputVo = ((ModelTableInfoService)this.getService()).queryListWithSrvByPage(vo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/model/table/info/sort"})
    @ResponseBody
    public ResponseData<Integer> tableSort(@RequestParam(value="objectId") String objectId, @RequestParam(value="upFlag") Boolean upFlag) {
        ModelTableInfoDTO tableVO = new ModelTableInfoDTO();
        tableVO.setObjectId(objectId);
        this.setUserInfoToVO(tableVO);
        int outputVo = ((ModelTableInfoService)this.getService()).updateTableOrder(tableVO, upFlag.booleanValue());
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/item/byrefs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<ModelTableFieldDTO>> queryModelTableInfoByItemId(ModelTableFieldDTO paramVO) {
        List outputVo = null;
        outputVo = ((ModelTableInfoService)this.getService()).queryAllByItemId(paramVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/model/table/option/byrefs/{dictId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryModelTableInfoByDictId(@PathVariable(value="dictId") String dictId) {
        List outputVo = null;
        outputVo = ((ModelTableInfoService)this.getService()).queryAllByDictId(dictId);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/copyModelTableInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO copyModelTableInfo(@RequestBody ModelTableInfoDTO copyTable) {
        ModelTableInfoDTO copyTb = ((ModelTableInfoService)this.getService()).copyModelTableInfo(copyTable);
        return copyTb;
    }

    @RequestMapping(value={"/api/model/table/sql"}, method={RequestMethod.POST})
    @AppDevLogAnno(action=LogAction.Add, desc="\u4eceSQL\u521b\u5efa\u8868\u6a21\u578b", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<ModelTableInfoDTO> createModelTableInfoBySQL(@RequestBody Map<String, String> param) {
        String appId = param.get("appId");
        String baAppId = param.get("baAppId");
        String subsId = param.get("subsId");
        String folderId = param.get("folderId");
        String objectType = param.get("objectType");
        String sql = param.get("sql");
        String userId = this.getUserInfo().getUserId();
        ModelTableInfoDTO tb = ((ModelTableInfoService)this.getService()).createModelTableInfoBySQL(subsId, baAppId, appId, folderId, objectType, userId, sql);
        if (tb == null) {
            ResponseData res = this.getResponseData(tb);
            res.setMessage("\u521b\u5efa\u5931\u8d25");
            return res;
        }
        return this.getResponseData(tb);
    }

    @RequestMapping(value={"/api/model/table/sql/update"}, method={RequestMethod.POST})
    @AppDevLogAnno(action=LogAction.Update, desc="\u6839\u636e\u5efa\u8868\u8bed\u53e5\u66f4\u65b0\u8868\u6a21\u578b", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<ModelTableInfoDTO> updateModelTableInfoBySQL(@RequestBody Map<String, String> param) {
        String appId = param.get("appId");
        String objectId = param.get("objectId");
        String sql = param.get("sql");
        String userId = this.getUserInfo().getUserId();
        ModelTableInfoDTO tb = ((ModelTableInfoService)this.getService()).updateModelTableInfoBySQL(appId, objectId, userId, sql);
        if (tb == null) {
            ResponseData res = this.getResponseData(tb);
            res.setMessage("\u66f4\u65b0\u5931\u8d25");
            return res;
        }
        return this.getResponseData(tb);
    }

    @RequestMapping(value={"/api/model/table/infos/init/common/table"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> initCommonTable(@RequestParam(value="appId") String appId) {
        ((ModelTableInfoService)this.getService()).generateIsrvRspInfo(appId);
        ((ModelTableInfoService)this.getService()).generateUserTokenInfo(appId);
        ((ModelTableInfoService)this.getService()).generatePageInfo(appId);
        ((ModelTableInfoService)this.getService()).generateDateData(appId);
        ((ModelTableInfoService)this.getService()).generateGivenData(appId);
        ((ModelTableInfoService)this.getService()).generateRandomData(appId);
        return this.getResponseData("\u521d\u59cb\u5316\u6210\u529f");
    }

    @RequestMapping(value={"/api/model/table/com/ref"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> createModelTableInfoBySQL(@RequestParam(value="allSelected") String allSelected, @RequestBody ModelTableInfoDTO param) {
        int outputVo = ((ModelTableInfoService)this.getService()).updateModelTableInfoRefComId(param);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/model/table/excel"})
    @AppDevLogAnno(action=LogAction.Add, desc="\u4eceExcel\u4e2d\u5bfc\u5165\u8868\u6a21\u578b", appId="${args[0].appId}")
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="subsId") String subsId, @RequestParam(value="baAppId", required=false) String baAppId, @RequestParam(value="appId") String appId, @RequestParam(value="folderId") String folderId, @RequestParam(value="objectType") String objectType, @RequestParam(value="comId", required=false) String comId, @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        try {
            final ModelTableInfoDTO tableInfo = new ModelTableInfoDTO();
            final ArrayList fields = new ArrayList();
            final ArrayList indexs = new ArrayList();
            final AtomicInteger indexLen = new AtomicInteger(0);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ModelTableIndexData.class, (ReadListener)new AnalysisEventListener<ModelTableIndexData>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    logger.info(headMap.toString());
                    if (headMap.get(0).equals("\u7269\u7406\u8868\u540d\u79f0")) {
                        tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(2)));
                        tableInfo.setObjectName(headMap.get(4));
                        tableInfo.setObjectDesc(headMap.get(4));
                    } else if (headMap.get(0).equals("\u7269\u7406\u8868\u540d")) {
                        tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(1)));
                        tableInfo.setObjectName(headMap.get(3));
                        tableInfo.setObjectDesc(headMap.get(3));
                    } else if (headMap.get(0).equals("\u6240\u5c5e\u4e3b\u9898\u57df") && headMap.get(2) != null) {
                        tableInfo.setSubjectId(headMap.get(2));
                    } else if (headMap.get(0).equals("\u4e3b\u952e") && headMap.get(1) != null) {
                        ModelTableIndexDTO primary = new ModelTableIndexDTO();
                        primary.setIndexFields(StringUtils.lowerCase((String)headMap.get(1)));
                        primary.setIndexName("PK_" + tableInfo.getObjectCode());
                        primary.setIndexTypePrimary("Y");
                        primary.setIndexTypeUnique("N");
                        indexs.add(primary);
                    }
                }

                public void invoke(ModelTableIndexData data, AnalysisContext context) {
                    logger.info(data.getIndexName());
                    if (StringUtils.isNotEmpty((CharSequence)data.getIndexName()) && (data.getIndexName().equals("\u5e8f\u53f7") || data.getIndexName().equals("\u5b57\u6bb5\u63cf\u8ff0") || data.getIndexName().equals("\u5b57\u6bb5\u540d\u79f0") || data.getIndexName().equals("\u5b57\u6bb5\u540d"))) {
                        int fieldIndex = context.readRowHolder().getRowIndex();
                        indexLen.set(fieldIndex + 1);
                        return;
                    }
                    if (StringUtils.isEmpty((CharSequence)data.getIndexName())) {
                        return;
                    }
                    ModelTableIndexDTO index = new ModelTableIndexDTO();
                    index.setIndexName(data.getIndexName());
                    index.setIndexFields(StringUtils.lowerCase((String)data.getIndexFields()));
                    if (StringUtils.isNotBlank((CharSequence)data.getIndexType()) && data.getIndexType().equals("\u4e3b\u952e\u7d22\u5f15")) {
                        index.setIndexTypePrimary("Y");
                        index.setIndexTypeUnique("N");
                    } else if (StringUtils.isNotBlank((CharSequence)data.getIndexType()) && data.getIndexType().equals("\u552f\u4e00\u7d22\u5f15")) {
                        index.setIndexTypeUnique("Y");
                        index.setIndexTypePrimary("N");
                    } else {
                        index.setIndexTypePrimary("N");
                        index.setIndexTypeUnique("N");
                    }
                    indexs.add(index);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                }

                public boolean hasNext(AnalysisContext context) {
                    String value = ((ReadCellData)context.readRowHolder().getCellMap().get(0)).getStringValue();
                    return value == null || !value.equals("\u5e8f\u53f7") && !value.equals("\u5b57\u6bb5\u63cf\u8ff0") && !value.equals("\u5b57\u6bb5\u540d\u79f0") && !value.equals("\u5b57\u6bb5\u540d");
                }
            }).sheet().headRowNumber(Integer.valueOf(3))).doReadSync();
            ModelTableIndexDTO primaryKey = null;
            for (ModelTableIndexDTO index : indexs) {
                if (!index.getIndexTypePrimary().equalsIgnoreCase("Y")) continue;
                primaryKey = index;
                break;
            }
            final ModelTableIndexDTO finalPrimaryKey = primaryKey;
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ModelTableRowData.class, (ReadListener)new AnalysisEventListener<ModelTableRowData>(){

                public void invoke(ModelTableRowData data, AnalysisContext context) {
                    logger.info(data.getFieldCode() + "-" + data.getFieldName());
                    ModelTableFieldDTO field = new ModelTableFieldDTO();
                    field.setFieldOrder(Integer.valueOf(data.getFieldOrder() != null ? Integer.valueOf(data.getFieldOrder()) : context.readRowHolder().getRowIndex() - indexLen.get()));
                    field.setFieldCode(StringUtils.lowerCase((String)data.getFieldCode()));
                    field.setFieldName(data.getFieldName());
                    if (data.getFieldType().contains("(")) {
                        field.setFieldType(data.getFieldType().substring(0, data.getFieldType().indexOf("(")));
                        Matcher matcher = pattern.matcher(data.getFieldType());
                        if (matcher.matches()) {
                            field.setFieldLength(Integer.valueOf(matcher.group(1)));
                            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                                field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                            }
                        }
                    } else {
                        field.setFieldType(data.getFieldType());
                    }
                    field.setFieldDesc(data.getFieldDesc());
                    if (data.getIsAllowNull() != null && (data.getIsAllowNull().equals("N") || data.getIsAllowNull().equals("Y"))) {
                        field.setIsAllowNull(data.getIsAllowNull());
                    } else {
                        field.setIsAllowNull(data.getIsAllowNull() != null && data.getIsAllowNull().equals("\u662f") ? "Y" : "N");
                    }
                    if (finalPrimaryKey != null && finalPrimaryKey.getIndexFields() != null && finalPrimaryKey.getIndexFields().contains(field.getFieldCode())) {
                        field.setIsPk("Y");
                    } else {
                        field.setIsPk("N");
                    }
                    fields.add(field);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                }
            }).sheet().headRowNumber(Integer.valueOf(indexLen.get()))).doReadSync();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            String createUser = this.getUserInfo().getUserId();
            tableInfo.setObjectId(KeyUtil.createUUIDKey());
            tableInfo.setAppId(appId);
            tableInfo.setSubsId(subsId);
            tableInfo.setBaAppId(baAppId);
            tableInfo.setFolderId(folderId);
            tableInfo.setObjectType(Integer.valueOf(Integer.parseInt(objectType)));
            tableInfo.setCreateUser(createUser);
            tableInfo.setCreateTime(createTime);
            tableInfo.setLastModifyUser(createUser);
            tableInfo.setLastModifyTime(createTime);
            ((ModelTableInfoService)this.getService()).insert((Object)tableInfo);
            for (ModelTableIndexDTO index : indexs) {
                index.setObjectId(tableInfo.getObjectId());
                index.setCreateUser(createUser);
                index.setCreateTime(createTime);
                index.setLastModifyUser(createUser);
                index.setLastModifyTime(createTime);
                index.setIndexName(StringUtils.upperCase((String)index.getIndexName()));
            }
            this.modelTableIndexService.batchInsert(indexs);
            for (ModelTableFieldDTO field : fields) {
                field.setObjectId(tableInfo.getObjectId());
                field.setFieldId(KeyUtil.createUUIDKey());
                field.setCreateTime(createTime);
                field.setCreateUser(createUser);
                field.setLastModifyUser(createUser);
                field.setLastModifyTime(createTime);
                this.modelTableFieldService.insert((Object)field);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ResponseData responseData = this.getResponseData("F");
            return responseData;
        }
        finally {
            try {
                IOUtils.closeQuietly((InputStream)file.getInputStream());
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u5165\u5f02\u5e38", (Throwable)e);
            }
        }
        return this.getResponseData("S");
    }

    @RequestMapping(value={"/client/ModelTableInfoService/checkCommonTableModel"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO checkCommonTableModel(@RequestParam(value="appId") String appId, @RequestParam(value="commonTableName") String commonTableName) {
        return ((ModelTableInfoService)this.getService()).checkCommonTableModel(appId, commonTableName);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generateIsrvRspInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generateIsrvRspInfo(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generateIsrvRspInfo(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generateUserTokenInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generateUserTokenInfo(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generateUserTokenInfo(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generatePageInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generatePageInfo(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generatePageInfo(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generateDateData"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generateDateData(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generateDateData(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generateGivenData"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generateGivenData(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generateGivenData(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/generateRandomData"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelTableInfoDTO generateRandomData(@RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).generateRandomData(appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/deleteByTableModelIds"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByTableModelIds(@RequestBody List<String> tableModelIds) {
        return ((ModelTableInfoService)this.getService()).deleteByTableModelIds(tableModelIds);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/queryAllIsolateTable"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableInfoDTO> queryAllIsolateTable(@RequestBody ModelTableInfoDTO modelTableInfoVo) {
        return ((ModelTableInfoService)this.getService()).queryAllIsolateTable(modelTableInfoVo);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/mergeAppByProjectId"}, method={RequestMethod.POST})
    @ResponseBody
    public int mergeAppByProjectId(@RequestParam(value="originAppId") String originAppId, @RequestParam(value="targetAppId") String targetAppId, @RequestBody List<Map<String, Object>> adjustContentList) {
        return ((ModelTableInfoService)this.getService()).mergeAppByProjectId(originAppId, targetAppId, adjustContentList);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/queryAllByTableInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableInfoDTO> queryAllByTableInfo(@RequestBody ModelTableInfoDTO modelTableInfoVO) {
        return ((ModelTableInfoService)this.getService()).queryAllByTableInfo(modelTableInfoVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysAnalysisIndexData"}, method={RequestMethod.POST})
    @ResponseBody
    public AnalysisIndexExcelDataDTO querySysAnalysisIndexData(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId) {
        return ((ModelTableInfoService)this.getService()).querySysAnalysisIndexData(subsId, appId);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/queryDsTableListByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelTableInfoDTO> queryDsTableListByPage(@RequestBody ModelTableInfoDTO modelTableInfoDTO) {
        return ((ModelTableInfoService)this.getService()).queryDsTableListByPage(modelTableInfoDTO);
    }

    @RequestMapping(value={"/api/model/table/infos/tmps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryListWithTmpGenByPage(ModelTableInfoDTO modelTableInfoDTO) {
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getAppId(), (CharSequence)",")) {
            modelTableInfoDTO.setAppIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getAppId(), (String)",")));
            modelTableInfoDTO.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getComId(), (CharSequence)",")) {
            modelTableInfoDTO.setComIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getComId(), (String)",")));
            modelTableInfoDTO.setComId(null);
        }
        List modelTableInfos = ((ModelTableInfoService)this.getService()).queryListWithTmpGenByPage(modelTableInfoDTO);
        return this.getResponseData(modelTableInfos);
    }

    @RequestMapping(value={"/api/model/table/infos/fns"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryListWithFnByPage(ModelTableInfoDTO modelTableInfoDTO) {
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getAppId(), (CharSequence)",")) {
            modelTableInfoDTO.setAppIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getAppId(), (String)",")));
            modelTableInfoDTO.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getComId(), (CharSequence)",")) {
            modelTableInfoDTO.setComIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getComId(), (String)",")));
            modelTableInfoDTO.setComId(null);
        }
        List modelTableInfos = ((ModelTableInfoService)this.getService()).queryListWithFnByPage(modelTableInfoDTO);
        return this.getResponseData(modelTableInfos);
    }

    @RequestMapping(value={"/api/model/table/infos/fn/forms"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoDTO>> queryListWithFnFormsByPage(ModelTableInfoDTO modelTableInfoDTO) {
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getAppId(), (CharSequence)",")) {
            modelTableInfoDTO.setAppIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getAppId(), (String)",")));
            modelTableInfoDTO.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)modelTableInfoDTO.getComId(), (CharSequence)",")) {
            modelTableInfoDTO.setComIdList(Arrays.asList(StringUtils.split((String)modelTableInfoDTO.getComId(), (String)",")));
            modelTableInfoDTO.setComId(null);
        }
        List modelTableInfos = ((ModelTableInfoService)this.getService()).queryListWithFnFormsByPage(modelTableInfoDTO);
        return this.getResponseData(modelTableInfos);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/syncAppTable2RealDB"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean syncAppTable2RealDB(@RequestParam(value="appId") String appId, @RequestParam(value="ecsId") String ecsId, @RequestParam(value="conflict") String conflict) {
        return ((ModelTableInfoService)this.getService()).syncAppTable2RealDB(appId, ecsId, conflict);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysTableCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisTableExcelDataDTO> querySysTableCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysTableCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldMissNameCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldMissNameCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldMissNameCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldDiffNameCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffNameCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldDiffNameCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldDiffENCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffENCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldDiffENCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldDiffLenCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffLenCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldDiffLenCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/querySysFieldMessyNameCheckByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AnalysisFieldExcelDataDTO> querySysFieldMessyNameCheckByPage(@RequestBody ModelTableInfoDTO paramVO) {
        return ((ModelTableInfoService)this.getService()).querySysFieldMessyNameCheckByPage(paramVO);
    }

    @RequestMapping(value={"/client/ModelTableInfoService/deleteByAppId"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByAppId(@RequestBody ModelTableInfoDTO paramDTO) {
        return ((ModelTableInfoService)this.getService()).deleteByAppId(paramDTO);
    }

    public static class ModelTableRowData {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private String fieldOrder;
        @ExcelProperty(value={"\u5b57\u6bb5\u540d\u79f0"})
        private String fieldCode;
        @ExcelProperty(value={"\u5b57\u6bb5\u63cf\u8ff0"})
        private String fieldName;
        @ExcelProperty(value={"\u6570\u636e\u7c7b\u578b"})
        private String fieldType;
        @ExcelProperty(value={"\u5b57\u6bb5\u8bf4\u660e"})
        private String fieldDesc;
        @ExcelProperty(value={"\u5141\u7a7a"})
        private String isAllowNull;
        @ExcelProperty(value={"\u6240\u5c5e\u4e3b\u9898\u57df"})
        private String subjectId;

        public String getFieldOrder() {
            return this.fieldOrder;
        }

        public void setFieldOrder(String fieldOrder) {
            this.fieldOrder = fieldOrder;
        }

        public String getFieldCode() {
            return this.fieldCode;
        }

        public void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldDesc() {
            return this.fieldDesc;
        }

        public void setFieldDesc(String fieldDesc) {
            this.fieldDesc = fieldDesc;
        }

        public String getIsAllowNull() {
            return this.isAllowNull;
        }

        public void setIsAllowNull(String isAllowNull) {
            this.isAllowNull = isAllowNull;
        }

        public String getSubjectId() {
            return this.subjectId;
        }

        public void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }
    }

    public static class ModelTableIndexData {
        @ExcelProperty(value={"\u7d22\u5f15\u540d"})
        private String indexName;
        @ExcelProperty(value={"\u7d22\u5f15\u5b57\u6bb5"})
        private String indexFields;
        @ExcelProperty(value={"\u7d22\u5f15\u7c7b\u578b"})
        private String indexType;

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public String getIndexFields() {
            return this.indexFields;
        }

        public void setIndexFields(String indexFields) {
            this.indexFields = indexFields;
        }

        public String getIndexType() {
            return this.indexType;
        }

        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }
    }
}

