/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeProduceInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class CodeProduceInfoController
extends BaseController<CodeProduceInfoDTO, CodeProduceInfoService> {
    @Autowired
    private ModelTableInfoService modelTableInfoService;

    @RequestMapping(value={"/api/code/produce/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CodeProduceInfoDTO>> queryCodeProduceInfoAll(CodeProduceInfoDTO dto) {
        List outputVo = ((CodeProduceInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/code/produce/info/{produceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<CodeProduceInfoDTO> queryByPk(@PathVariable(value="produceId") String produceId) {
        CodeProduceInfoDTO inVo = new CodeProduceInfoDTO();
        inVo.setProduceId(produceId);
        CodeProduceInfoDTO outputVo = (CodeProduceInfoDTO)((CodeProduceInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/code/produce/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody CodeProduceInfoDTO inCodeProduceInfoDTO) {
        int outputVo = ((CodeProduceInfoService)this.getService()).deleteByPk((Object)inCodeProduceInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/code/produce/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody CodeProduceInfoDTO inCodeProduceInfoDTO) {
        int outputVo = ((CodeProduceInfoService)this.getService()).updateByPk((Object)inCodeProduceInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/code/produce/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertCodeProduceInfo(@RequestParam(value="allSelected", required=false) String allSelected, @RequestBody CodeProduceInfoDTO inCodeProduceInfoDTO) {
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inCodeProduceInfoDTO.setCreateUser(userId);
        inCodeProduceInfoDTO.setCreateTime(now);
        if (StringUtils.isBlank((CharSequence)allSelected)) {
            if (StringUtils.isBlank((CharSequence)inCodeProduceInfoDTO.getProduceId())) {
                inCodeProduceInfoDTO.setProduceId(UUIDUtil.getUUID());
            }
            int outputVo = ((CodeProduceInfoService)this.getService()).insert((Object)inCodeProduceInfoDTO);
            return this.getResponseData(inCodeProduceInfoDTO.getProduceId());
        }
        List tableList = Collections.emptyList();
        if (StringUtils.equals((CharSequence)allSelected, (CharSequence)YesOrNO.YES.getCode())) {
            ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
            tableParam.setSubsId(inCodeProduceInfoDTO.getSubsId());
            tableParam.setAppId(inCodeProduceInfoDTO.getRefDbAppid());
            tableParam.setComId(inCodeProduceInfoDTO.getComId());
            tableParam.setObjectType(ObjectType.Table.getIntCode());
            tableList = this.modelTableInfoService.queryList((Object)tableParam);
        } else {
            String objectIds = inCodeProduceInfoDTO.getModelTableId();
            String[] objectIdA = StringUtils.split((String)objectIds, (String)",");
            ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
            tableParam.setAppId(inCodeProduceInfoDTO.getAppId());
            tableParam.setSubsId(inCodeProduceInfoDTO.getSubsId());
            tableParam.setComId(inCodeProduceInfoDTO.getComId());
            tableParam.setObjectIds(Arrays.asList(objectIdA));
            tableList = this.modelTableInfoService.queryList((Object)tableParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            ArrayList<CodeProduceInfoDTO> configList = new ArrayList<CodeProduceInfoDTO>();
            for (ModelTableInfoDTO table : tableList) {
                CodeProduceInfoDTO codeConfig = new CodeProduceInfoDTO();
                ((CodeProduceInfoService)this.getService()).deleteByCond(inCodeProduceInfoDTO.getAppId(), table.getObjectId());
                BeanUtility.beanCopy((Object)inCodeProduceInfoDTO, (Object)codeConfig);
                codeConfig.setProduceId(UUIDUtil.getUUID());
                codeConfig.setAppId(inCodeProduceInfoDTO.getAppId());
                codeConfig.setModelTableId(table.getObjectId());
                codeConfig.setModelTableCode(table.getObjectCode());
                codeConfig.setModelTableName(table.getObjectName());
                codeConfig.setProduceDesc(table.getObjectName() + "\u4ee3\u7801\u751f\u6210");
                configList.add(codeConfig);
            }
            int outputVo = ((CodeProduceInfoService)this.getService()).batchInsert(configList);
            return this.getResponseData("", "\u6279\u91cf\u751f\u6210\u6210\u529f", "\u6279\u91cf\u751f\u6210\u5931\u8d25");
        }
        return this.getResponseData("", "\u8868\u6a21\u578b\u67e5\u8be2\u4e3a\u7a7a", "\u6279\u91cf\u751f\u6210\u5931\u8d25");
    }

    @RequestMapping(value={"/client/CodeProduceInfoService/produceCodeFile"}, method={RequestMethod.POST})
    public void produceCodeFile(@RequestParam(value="templateType") String templateType, @RequestParam(value="templateFile") String templateFile, @RequestParam(value="replaceTarget") String replaceTarget, @RequestParam(value="replaceStr") String replaceStr, @RequestParam(value="rootPath") String rootPath, @RequestParam(value="modelName", required=false) String modelName, @RequestParam(value="codePath") String codePath, @RequestParam(value="appId") String appId, @RequestBody CodeTemplateDataBo ctdb) {
        ((CodeProduceInfoService)this.getService()).produceCodeFile(templateType, templateFile, replaceTarget, replaceStr, rootPath, modelName, codePath, appId, ctdb);
    }
}

