/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlCondService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvSqlCondDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class IsrvSqlCondController
extends BaseController<IsrvSqlCondDTO, IsrvSqlCondService> {
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/isrv/sql/conds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<IsrvSqlCondDTO>> queryIsrvSqlCondAll(IsrvSqlCondDTO vo) {
        List outputVo = ((IsrvSqlCondService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/cond/{condId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<IsrvSqlCondDTO> queryByPk(@PathVariable(value="condId") String condId) {
        IsrvSqlCondDTO inVo = new IsrvSqlCondDTO();
        inVo.setCondId(condId);
        IsrvSqlCondDTO outputVo = (IsrvSqlCondDTO)((IsrvSqlCondService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/cond"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody IsrvSqlCondDTO inIsrvSqlCondVo) {
        int outputVo = ((IsrvSqlCondService)this.getService()).deleteByPk((Object)inIsrvSqlCondVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/cond"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody IsrvSqlCondDTO inIsrvSqlCondVo) {
        int outputVo = ((IsrvSqlCondService)this.getService()).updateByPk((Object)inIsrvSqlCondVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/cond"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertIsrvSqlCond(@RequestBody IsrvSqlCondDTO inIsrvSqlCondVo) {
        if (!Objects.nonNull(inIsrvSqlCondVo.getCondId())) {
            inIsrvSqlCondVo.setCondId(UUIDUtil.getUUID());
        }
        int outputVo = ((IsrvSqlCondService)this.getService()).insert((Object)inIsrvSqlCondVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/cond/ioflag"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByFieldIoFlag(@RequestParam(value="fieldId") String fieldId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="ioType") String ioType, @RequestParam(value="ioFlag") String ioFlag) {
        int num = ((IsrvSqlCondService)this.getService()).updateByFieldIoFlag(fieldId, srvModelId, ioType, ioFlag);
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/isrv/sql/cond/ioflags"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByFieldIoFlags(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="ioType") String ioType, @RequestParam(value="ioFlag") String ioFlag) {
        SrvModelInfoDTO model = new SrvModelInfoDTO();
        model.setSrvModelId(srvModelId);
        model = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)model);
        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)model.getSrvModelType());
        if (SrvModelTypeEnum.QUERY_SINGLE != srvModelTypeEnum && SrvModelTypeEnum.DELETE_SINGLE != srvModelTypeEnum) {
            return this.getResponseData(1);
        }
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(objectId);
        List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
        int num = 0;
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (ModelTableFieldDTO field : fieldList) {
                num += ((IsrvSqlCondService)this.getService()).updateByFieldIoFlag(field.getFieldId(), srvModelId, ioType, ioFlag);
            }
        }
        return this.getResponseData(num);
    }
}

