/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvSqlInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class IsrvSqlInfoController
extends BaseController<IsrvSqlInfoDTO, IsrvSqlInfoService> {
    @RequestMapping(value={"/api/isrv/sql/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<IsrvSqlInfoDTO>> queryIsrvSqlInfoAll(IsrvSqlInfoDTO vo) {
        List outputVo = ((IsrvSqlInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/info/{sqlId}/{srvModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<IsrvSqlInfoDTO> queryByPk(@PathVariable(value="sqlId") String sqlId, @PathVariable(value="srvModelId") String srvModelId) {
        IsrvSqlInfoDTO inVo = new IsrvSqlInfoDTO();
        inVo.setSqlId(sqlId);
        inVo.setSrvModelId(srvModelId);
        IsrvSqlInfoDTO outputVo = (IsrvSqlInfoDTO)((IsrvSqlInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody IsrvSqlInfoDTO inIsrvSqlInfoVo) {
        int outputVo = ((IsrvSqlInfoService)this.getService()).deleteByPk((Object)inIsrvSqlInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody IsrvSqlInfoDTO inIsrvSqlInfoVo) {
        if (StringUtils.isBlank((CharSequence)inIsrvSqlInfoVo.getSqlId())) {
            inIsrvSqlInfoVo.setSqlId(UUIDUtil.getUUID());
            inIsrvSqlInfoVo.setSingleResult(YesOrNO.YES.getCode());
            inIsrvSqlInfoVo.setPageSize(Integer.valueOf(1));
            int outputVo = ((IsrvSqlInfoService)this.getService()).insert((Object)inIsrvSqlInfoVo);
            return this.getResponseData(outputVo);
        }
        int outputVo = ((IsrvSqlInfoService)this.getService()).updateByPk((Object)inIsrvSqlInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/isrv/sql/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertIsrvSqlInfo(@RequestBody IsrvSqlInfoDTO inIsrvSqlInfoVo) {
        if (StringUtils.isBlank((CharSequence)inIsrvSqlInfoVo.getSqlId())) {
            inIsrvSqlInfoVo.setSqlId(UUIDUtil.getUUID());
            inIsrvSqlInfoVo.setSingleResult(YesOrNO.YES.getCode());
            inIsrvSqlInfoVo.setPageSize(Integer.valueOf(1));
        }
        int outputVo = ((IsrvSqlInfoService)this.getService()).insert((Object)inIsrvSqlInfoVo);
        return this.getResponseData(outputVo);
    }
}

