/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceactionService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelSubpageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class PageDynamicController
extends AbstractController {
    @Autowired
    private PageModelPackageService pageModelPackageService;
    @Autowired
    private PageModelParamService pageModelParamService;
    @Autowired
    private PageModelInfoService pageModelInfoService;
    @Autowired
    private PageTemplateInfoService pageTemplateInfoService;
    @Autowired
    private PageTemplateFileService pageTemplateFileService;
    @Autowired
    private AppResourceService sResourceService;
    @Autowired
    private AppResourceactionService sResourceactionService;
    @Autowired
    private DataSource dataSource;
    @Value(value="${code.template.path}")
    private String TEMPLATE_PATH;
    @Value(value="${dynamic.render.static.host}")
    private String DYNAMIC_RENDER_STATIC_HOST;
    private static final String HTML_404 = "<!doctype html><html lang=\"zh\"><head><title>HTTP\u72b6\u6001 404 - \u672a\u627e\u5230</title><style type=\"text/css\">body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}</style></head><body><h1>HTTP\u72b6\u6001 404 - \u672a\u627e\u5230</h1><hr class=\"line\" /><p><b>\u7c7b\u578b</b> \u72b6\u6001\u62a5\u544a</p><p><b>\u63cf\u8ff0</b> \u6e90\u670d\u52a1\u5668\u672a\u80fd\u627e\u5230\u76ee\u6807\u8d44\u6e90\u7684\u8868\u793a\u6216\u8005\u662f\u4e0d\u613f\u516c\u5f00\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u8d44\u6e90\u8868\u793a\u3002</p><hr class=\"line\" /><h3>Apache Tomcat/8.5.73</h3></body></html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/page/dynamic"}, method={RequestMethod.GET})
    public void dynamicRender(@RequestParam(value="pageId") String pageId, HttpServletRequest request, HttpServletResponse response) {
        block6: {
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                int bytesRead;
                String html = this.render(pageId);
                response.setContentType("text/html;charset=utf-8");
                response.setHeader("X-Frame-Options", "sameorigin");
                ServletOutputStream out = response.getOutputStream();
                bis = new BufferedInputStream(new ByteArrayInputStream(html.getBytes("utf-8")));
                bos = new BufferedOutputStream((OutputStream)out);
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                bos.flush();
                out.flush();
                ResourceCloseUtil.closeInputStream((InputStream)bis);
            }
            catch (Exception e) {
                logger.error("\u52a8\u6001\u6e32\u67d3\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                response.setStatus(404);
                break block6;
            }
            finally {
                ResourceCloseUtil.closeInputStream(bis);
                ResourceCloseUtil.closeOutputStream(bos);
            }
            ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/openapi/page/dynamic/string"}, method={RequestMethod.GET})
    public String render(@RequestParam(value="pageId") String pageId) {
        String result;
        block7: {
            List paramList;
            String appTemplatePath;
            PageModelInfoDTO modelInfo;
            block8: {
                result = HTML_404;
                PageModelInfoDTO modelParam = new PageModelInfoDTO();
                modelParam.setPageModelId(pageId);
                modelInfo = (PageModelInfoDTO)this.pageModelInfoService.queryByPk((Object)modelParam);
                if (!Objects.nonNull(modelInfo)) break block7;
                appTemplatePath = this.TEMPLATE_PATH;
                PageModelParamDTO param = new PageModelParamDTO();
                param.setPageModelId(modelInfo.getPageModelId());
                param.setSize(Integer.valueOf(1000));
                param.setQueryRef("query");
                paramList = this.pageModelParamService.queryList((Object)param);
                if (!StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) break block8;
                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                String string = result;
                return string;
            }
            try {
                PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
                templateParam.setPageTemplateId(modelInfo.getPageTemplateId());
                PageTemplateInfoDTO template = (PageTemplateInfoDTO)this.pageTemplateInfoService.queryByPk((Object)templateParam);
                PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
                fileParam.setPageTemplateId(template.getPageTemplateId());
                List fileList = this.pageTemplateFileService.queryList((Object)fileParam);
                String appTemplateRepoRootPath = appTemplatePath + File.separator + template.getAppTemplateId() + "-template" + File.separator + template.getAppTemplateId() + "-code" + File.separator;
                String localAppTemplatePath = appTemplateRepoRootPath + template.getPageTemplateCode();
                if (!CollectionUtils.isNotEmpty((Collection)fileList)) break block7;
                PageTemplateFileDTO file = (PageTemplateFileDTO)fileList.get(0);
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (!tempFile.exists()) break block7;
                try {
                    String packagePath = "";
                    String basePath = this.getBasePath(packagePath);
                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, this.TEMPLATE_PATH, basePath);
                    ArrayList dataCodes = new ArrayList();
                    paramList.forEach(pageModelParamDTO -> {
                        List fields = pageModelParamDTO.getFields();
                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                            fields.forEach(f -> {
                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                    dataCodes.add(f.getFieldOption());
                                }
                            });
                        }
                    });
                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                    root.put("BASE_PATH", basePath);
                    root.put("pageModelInfo", modelInfo);
                    root.put("dataCodeJoin", dataCodeJoin);
                    root.put("localAppTemplatePath", localAppTemplatePath);
                    String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                    String js = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath, root);
                    String css = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath, root);
                    HashMap<String, String> dynamicData = new HashMap<String, String>();
                    dynamicData.put("staticHost", this.DYNAMIC_RENDER_STATIC_HOST + template.getAppTemplateId());
                    dynamicData.put("html", html);
                    dynamicData.put("js", js);
                    dynamicData.put("css", css);
                    result = FreemarkerUtil.produceStringByTemplate((String)appTemplateRepoRootPath, (String)"dynamic.html.vm", dynamicData);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public String wrapperPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public String replaceSuffix(String fileName) {
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public String renderOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath, Map<String, Object> root) throws Exception {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = false;
        if (tempFile.exists()) {
            String content = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)templateFile, root);
            return content;
        }
        return "";
    }

    public boolean checkOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath) {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = tempFile.exists();
        return flag;
    }

    public Map<String, Object> prepareParam(PageModelInfoDTO modelInfo, List<PageModelParamDTO> paramList, String appTemplatePath, String basePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("BASE_PATH", basePath);
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                if (!ParamType.kv.getCode().equals(param.getParamType())) {
                    if (CollectionUtils.isNotEmpty((Collection)param.getFields()) && (ParamType.fields.getCode().equals(param.getParamType()) || ParamType.formFields.getCode().equals(param.getParamType()))) {
                        root.put(paramCode, param.getFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getQueryFields()) && ParamType.conds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getQueryFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getButtons()) && ParamType.buttons.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getButtons());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getLinkeds()) && ParamType.linkeds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getLinkeds());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getSubspages()) && ParamType.subpages.getCode().equals(param.getParamType())) {
                        List subpages = param.getSubspages();
                        ArrayList<Map<String, Object>> subPageMapList = new ArrayList<Map<String, Object>>();
                        if (CollectionUtils.isNotEmpty((Collection)subpages)) {
                            for (PageModelSubpageDTO sub : subpages) {
                                Map<String, Object> subPageParam = this.fetchSubPageParam(modelInfo, sub, sub.getModelInfo(), appTemplatePath, basePath);
                                subPageMapList.add(subPageParam);
                            }
                        }
                        root.put(paramCode, subPageMapList);
                        continue;
                    }
                    try {
                        List list = JSON.parseArray((String)param.getParamValue(), Map.class);
                        root.put(paramCode, list);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u53c2\u6570json\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    public String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }

    public Map<String, String> createPackageMap(List<PageModelPackageDTO> packageList) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(packageList)) {
            HashMap<String, PageModelPackageDTO> map = new HashMap<String, PageModelPackageDTO>();
            for (PageModelPackageDTO p : packageList) {
                map.put(p.getPackageId(), p);
            }
            for (PageModelPackageDTO p : packageList) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(p.getPackageCode());
                PageModelPackageDTO parent = (PageModelPackageDTO)map.get(p.getPackageAbvId());
                while (parent != null) {
                    paths.add(parent.getPackageCode());
                    parent = (PageModelPackageDTO)map.get(parent.getPackageAbvId());
                }
                Collections.reverse(paths);
                pathMap.put(p.getPackageId(), StringUtils.join(paths, (String)File.separator));
            }
        }
        return pathMap;
    }

    public String getBasePath(String packagePath) {
        String[] pathNum = StringUtils.split((String)packagePath, (String)File.separator);
        int deep = pathNum.length;
        ++deep;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= deep; ++i) {
            list.add("../");
        }
        return StringUtils.join(list, (String)"");
    }

    public Map<String, String> createRoute(String packagePath, File page) {
        Object[] paths = StringUtils.split((String)(packagePath + File.separator + this.replaceSuffix(page.getName())), (String)File.separator);
        String path = StringUtils.join((Object[])paths, (String)"/");
        HashMap<String, String> route = new HashMap<String, String>();
        route.put("path", path);
        route.put("name", StringUtils.join((Object[])paths, (String)"-"));
        route.put("pageName", page.getName());
        return route;
    }

    public Map<String, Object> fetchSubPageParam(PageModelInfoDTO rootModelInfo, PageModelSubpageDTO subPage, PageModelInfoDTO modelInfo, String appTemplatePath, String basePath) {
        if (modelInfo != null) {
            PageModelParamDTO param = new PageModelParamDTO();
            param.setPageModelId(modelInfo.getPageModelId());
            param.setSize(Integer.valueOf(1000));
            param.setQueryRef("query");
            List paramList = this.pageModelParamService.queryList((Object)param);
            if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                return Collections.emptyMap();
            }
            PageTemplateInfoDTO template = new PageTemplateInfoDTO();
            template.setPageTemplateId(modelInfo.getPageTemplateId());
            this.pageTemplateInfoService.queryByPk((Object)template);
            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
            fileParam.setPageTemplateId(template.getPageTemplateId());
            List fileList = this.pageTemplateFileService.queryList((Object)fileParam);
            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateId();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                PageTemplateFileDTO file = (PageTemplateFileDTO)fileList.get(0);
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (tempFile.exists()) {
                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                    ArrayList dataCodes = new ArrayList();
                    paramList.forEach(pageModelParamDTO -> {
                        List fields = pageModelParamDTO.getFields();
                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                            fields.forEach(f -> {
                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                    dataCodes.add(f.getFieldOption());
                                }
                            });
                        }
                    });
                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                    root.put("templateName", templateName);
                    root.put("templateFilePrefix", this.replaceSuffix(file.getFileName()));
                    root.put("rootModelInfo", rootModelInfo);
                    root.put("subPage", subPage);
                    root.put("BASE_PATH", basePath);
                    root.put("pageModelInfo", modelInfo);
                    root.put("dataCodeJoin", dataCodeJoin);
                    root.put("localAppTemplatePath", localAppTemplatePath);
                    ArrayList<String> jsList = new ArrayList<String>();
                    File localTemplateFile = new File(localAppTemplatePath);
                    if (localTemplateFile.exists()) {
                        File[] files;
                        for (File f : files = localTemplateFile.listFiles()) {
                            if (!StringUtils.endsWithAny((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{".js.vm"})) continue;
                            jsList.add(f.getName());
                        }
                    }
                    root.put("jsList", jsList);
                    boolean jsFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath);
                    boolean cssFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath);
                    root.put("jsFlag", jsFlag);
                    root.put("cssFlag", cssFlag);
                    return root;
                }
            }
        }
        return Collections.emptyMap();
    }
}

