/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageLinkedInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageLinkedInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.PageDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageLinkedInfoController
extends BaseController<PageLinkedInfoDTO, PageLinkedInfoService> {
    @RequestMapping(value={"/api/page/linked/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageLinkedInfoDTO>> queryPageLinkedInfoAll(PageLinkedInfoDTO vo) {
        List outputVo = ((PageLinkedInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/linked/info/{pageModelId}/{pageLinkedId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageLinkedInfoDTO> queryByPk(@PathVariable(value="paramId") String paramId, @PathVariable(value="pageLinkedId") String pageLinkedId) {
        PageLinkedInfoDTO inVo = new PageLinkedInfoDTO();
        inVo.setParamId(paramId);
        inVo.setPageLinkedId(pageLinkedId);
        PageLinkedInfoDTO outputVo = (PageLinkedInfoDTO)((PageLinkedInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u9875\u9762\u6a21\u578b\u53c2\u6570\u94fe\u63a5  ${args[0].pageLinkedId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/linked/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageLinkedInfoDTO inPageLinkedInfoVo) {
        int outputVo = ((PageLinkedInfoService)this.getService()).deleteByPk((Object)inPageLinkedInfoVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Update, desc="\u4fee\u6539\u9875\u9762\u6a21\u578b\u53c2\u6570\u94fe\u63a5 ${args[0].pageLinkedId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/linked/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageLinkedInfoDTO inPageLinkedInfoVo) {
        this.setUserInfoToVO(inPageLinkedInfoVo);
        inPageLinkedInfoVo.setLastUpdateUser(inPageLinkedInfoVo.getLoginUserId());
        inPageLinkedInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageLinkedInfoService)this.getService()).updateByPk((Object)inPageLinkedInfoVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Add, desc="\u65b0\u589e\u9875\u9762\u6a21\u578b\u53c2\u6570\u94fe\u63a5 ${args[0].pageLinkedId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/linked/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageLinkedInfo(@RequestBody PageLinkedInfoDTO inPageLinkedInfoVo) {
        this.setUserInfoToVO(inPageLinkedInfoVo);
        if (StringUtils.isBlank((CharSequence)inPageLinkedInfoVo.getPageLinkedId())) {
            inPageLinkedInfoVo.setPageLinkedId(UUIDUtil.getUUID());
        }
        inPageLinkedInfoVo.setCreateUser(inPageLinkedInfoVo.getLoginUserId());
        inPageLinkedInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPageLinkedInfoVo.setLastUpdateUser(inPageLinkedInfoVo.getLoginUserId());
        inPageLinkedInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageLinkedInfoService)this.getService()).insert((Object)inPageLinkedInfoVo);
        return this.getResponseData(outputVo);
    }
}

