/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.PageDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageModelInfoController
extends BaseController<PageModelInfoDTO, PageModelInfoService> {
    @RequestMapping(value={"/api/page/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageModelInfoDTO>> queryPageModelInfoAll(PageModelInfoDTO vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getAppIds())) {
            vo.setAppIdList(Arrays.asList(StringUtils.split((String)vo.getAppIds(), (String)",")));
        }
        List outputVo = ((PageModelInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/infos/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map>> queryPageModelSummary(PageModelInfoDTO vo) {
        List outputVo = ((PageModelInfoService)this.getService()).queryPageModelSummary(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/info/{pageModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageModelInfoDTO> queryByPk(@PathVariable(value="pageModelId") String pageModelId) {
        PageModelInfoDTO inVo = new PageModelInfoDTO();
        inVo.setPageModelId(pageModelId);
        PageModelInfoDTO outputVo = (PageModelInfoDTO)((PageModelInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u9875\u9762\u6a21\u578b ${args[0].pageModelId}", appId="${args[0].appId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageModelInfoDTO inPageModelInfoVo) {
        int outputVo = ((PageModelInfoService)this.getService()).deleteByPk((Object)inPageModelInfoVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Update, desc="\u4fee\u6539\u9875\u9762\u6a21\u578b ${args[0].pageModelName}", appId="${args[0].appId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageModelInfoDTO inPageModelInfoVo) {
        this.setUserInfoToVO(inPageModelInfoVo);
        inPageModelInfoVo.setLastUpdateUser(inPageModelInfoVo.getLoginUserId());
        inPageModelInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageModelInfoService)this.getService()).updateByPk((Object)inPageModelInfoVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Add, desc="\u65b0\u589e\u9875\u9762\u6a21\u578b ${args[0].pageModelName}", appId="${args[0].appId}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPageModelInfo(@RequestBody PageModelInfoDTO inPageModelInfoVo) {
        this.setUserInfoToVO(inPageModelInfoVo);
        if (StringUtils.isBlank((CharSequence)inPageModelInfoVo.getPageModelId())) {
            inPageModelInfoVo.setPageModelId(UUIDUtil.getUUID());
        }
        inPageModelInfoVo.setCreateUser(inPageModelInfoVo.getLoginUserId());
        inPageModelInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPageModelInfoVo.setLastUpdateUser(inPageModelInfoVo.getLoginUserId());
        inPageModelInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isNotBlank((CharSequence)inPageModelInfoVo.getTableModelId())) {
            inPageModelInfoVo.setInitFormTb(true);
        }
        int outputVo = ((PageModelInfoService)this.getService()).insert((Object)inPageModelInfoVo);
        return this.getResponseData(inPageModelInfoVo.getPageModelId());
    }

    @RequestMapping(value={"/client/PageModelInfoService/initPageModelFromApp"}, method={RequestMethod.GET})
    @ResponseBody
    public String initPageModelFromApp(@RequestParam(value="userId") String userId, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="srcAppId") String srcAppId, @RequestParam(value="coverFlag") boolean coverFlag, @RequestParam(value="tableModelId", required=false) String tableModelId, @RequestParam(value="fnId", required=false) String fnId, @RequestParam(value="types") String types, @RequestParam(value="async") Boolean async) {
        return ((PageModelInfoService)this.getService()).initPageModelFromApp(userId, subsId, appId, srcAppId, coverFlag, tableModelId, fnId, types, async);
    }

    @RequestMapping(value={"/client/PageModelInfoService/initStandalonePageModel"}, method={RequestMethod.POST})
    @ResponseBody
    public String initStandalonePageModel(@RequestParam(value="userId") String userId, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="coverFlag") boolean coverFlag, @RequestParam(value="fnId") String fnId, @RequestParam(value="fnName") String fnName, @RequestParam(value="tableModelId") String tableModelId, @RequestParam(value="types") String types) {
        return ((PageModelInfoService)this.getService()).initStandalonePageModel(userId, subsId, appId, coverFlag, fnId, fnName, tableModelId, types);
    }

    @RequestMapping(value={"/client/PageModelInfoService/deleteByAppId"}, method={RequestMethod.POST})
    public int deleteByAppId(@RequestParam(value="appId") String appId) {
        return ((PageModelInfoService)this.getService()).deleteByAppId(appId);
    }

    @RequestMapping(value={"/client/PageModelInfoService/queryPageModelSummary"}, method={RequestMethod.POST})
    public List<Map> queryPageModelSummary_client(@RequestBody PageModelInfoDTO pageModelInfoDTO) {
        return ((PageModelInfoService)this.getService()).queryPageModelSummary(pageModelInfoDTO);
    }

    @RequestMapping(value={"/client/PageModelInfoService/appIdReset"}, method={RequestMethod.POST})
    public int appIdReset(@RequestParam(value="appId") String appId, @RequestParam(value="newAppId") String newAppId) {
        return ((PageModelInfoService)this.getService()).appIdReset(appId, newAppId);
    }

    @RequestMapping(value={"/client/PageModelInfoService/deleteAppInfoById"}, method={RequestMethod.POST})
    public int deleteAppInfoById(@RequestParam(value="appId") String appId) {
        return ((PageModelInfoService)this.getService()).deleteAppInfoById(appId);
    }

    @RequestMapping(value={"/api/page/model/info/change/belong/deletes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBeLongDeleteFiles(PageModelInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getPageModelId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            ArrayList result = new ArrayList();
            files.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filePath", f.getAbsolutePath().replaceFirst(dir.getAbsolutePath(), "").replaceAll(File.separator, "/"));
                map.put("fileName", f.getName());
                result.add(map);
            });
            if (CollectionUtils.isNotEmpty(result)) {
                Map map = (Map)result.get(0);
                map.put("total", result.size());
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(Collections.emptyList());
    }

    @RequestMapping(value={"/api/page/model/info/change/belong/deletes/confirm"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<String> beLongDeleteFilesConfirm(@RequestBody PageModelInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getPageModelId();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            FileUtils.deleteQuietly((File)dir);
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(dto.getAppId());
            appRepoPullTask.syncRun();
            String appPath = appRepoPullTask.getAppPath();
            try {
                Files.move(new File(appPath).toPath(), dir.toPath(), new CopyOption[0]);
                for (File deleteFile : files) {
                    if (!deleteFile.exists()) continue;
                    FileUtils.deleteQuietly((File)deleteFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getResponseData("\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/api/page/model/info/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PageModelInfoDTO> validate(@RequestBody PageModelInfoDTO dto) {
        dto = (PageModelInfoDTO)((PageModelInfoService)this.getService()).queryByPk((Object)dto);
        boolean flag = ((PageModelInfoService)this.getService()).validate(dto);
        return this.getResponseData(dto);
    }

    @RequestMapping(value={"/api/page/model/info/validate/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> validateList(@RequestBody PageModelInfoDTO dto) {
        dto.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List cardList = ((PageModelInfoService)this.getService()).queryListByPage((Object)dto);
        cardList.forEach(this::validate);
        return this.getResponseData(cardList.size());
    }
}

