/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.PageDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageModelParamController
extends BaseController<PageModelParamDTO, PageModelParamService> {
    @RequestMapping(value={"/api/page/model/params"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageModelParamDTO>> queryPageModelParamAll(PageModelParamDTO vo) {
        List outputVo = ((PageModelParamService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/model/param/{paramId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageModelParamDTO> queryByPk(@PathVariable(value="paramId") String paramId) {
        PageModelParamDTO inVo = new PageModelParamDTO();
        inVo.setParamId(paramId);
        PageModelParamDTO outputVo = (PageModelParamDTO)((PageModelParamService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u9875\u9762\u6a21\u578b\u53c2\u6570 ${args[0].paramName}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/param"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageModelParamDTO inPageModelParamVo) {
        int outputVo = ((PageModelParamService)this.getService()).deleteByPk((Object)inPageModelParamVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Update, desc="\u4fee\u6539\u9875\u9762\u6a21\u578b\u53c2\u6570 ${args[0].paramName}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/param"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageModelParamDTO inPageModelParamVo) {
        this.setUserInfoToVO(inPageModelParamVo);
        inPageModelParamVo.setLastUpdateUser(inPageModelParamVo.getLoginUserId());
        inPageModelParamVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageModelParamService)this.getService()).updateByPk((Object)inPageModelParamVo);
        return this.getResponseData(outputVo);
    }

    @PageDevLogAnno(action=LogAction.Add, desc="\u65b0\u589e\u9875\u9762\u6a21\u578b\u53c2\u6570 ${args[0].paramName}", pageModelId="${args[0].pageModelId}")
    @RequestMapping(value={"/api/page/model/param"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageModelParam(@RequestBody PageModelParamDTO inPageModelParamVo) {
        this.setUserInfoToVO(inPageModelParamVo);
        if (StringUtils.isBlank((CharSequence)inPageModelParamVo.getParamId())) {
            inPageModelParamVo.setParamId(UUIDUtil.getUUID());
        }
        inPageModelParamVo.setCreateUser(inPageModelParamVo.getLoginUserId());
        inPageModelParamVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PageModelParamService)this.getService()).insert((Object)inPageModelParamVo);
        return this.getResponseData(outputVo);
    }
}

