/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.QryModelResultService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelResultDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelResultController
extends BaseController<QryModelResultDTO, QryModelResultService> {
    @RequestMapping(value={"/api/qry/model/results"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelResultDTO>> queryQryModelResultAll(QryModelResultDTO vo) {
        List outputDTO = ((QryModelResultService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/result/{resultId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelResultDTO> queryByPk(@PathVariable(value="resultId") String resultId, @RequestParam(value="qryId") String qryId) {
        QryModelResultDTO inDTO = new QryModelResultDTO();
        inDTO.setResultId(resultId);
        inDTO.setQryId(qryId);
        QryModelResultDTO outputDTO = (QryModelResultDTO)((QryModelResultService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/result"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelResultDTO inQryModelResultDTO) {
        int outputDTO = ((QryModelResultService)this.getService()).deleteByPk((Object)inQryModelResultDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/result"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelResultDTO inQryModelResultDTO) {
        inQryModelResultDTO.setLastUpdateUser(inQryModelResultDTO.getLoginUserId());
        inQryModelResultDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelResultService)this.getService()).updateByPk((Object)inQryModelResultDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/result"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelResult(@RequestBody QryModelResultDTO inQryModelResultDTO) {
        if (StringUtils.isBlank((CharSequence)inQryModelResultDTO.getResultId())) {
            inQryModelResultDTO.setResultId(UUIDUtil.getUUID());
            inQryModelResultDTO.setCreateUser(inQryModelResultDTO.getLoginUserId());
            inQryModelResultDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            int outputDTO = ((QryModelResultService)this.getService()).insert((Object)inQryModelResultDTO);
            return this.getResponseData(outputDTO);
        }
        return this.updateByPk(inQryModelResultDTO);
    }

    @RequestMapping(value={"/api/qry/model/result/batchadd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> batchInsertField(@RequestBody List<QryModelResultDTO> list) {
        int outputDTO = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (QryModelResultDTO vo : list) {
                vo.setResultId(UUIDUtil.getUUID());
                vo.setCreateUser(vo.getLoginUserId());
                vo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            }
            outputDTO = ((QryModelResultService)this.getService()).batchInsert(list);
        }
        return this.getResponseData(outputDTO);
    }
}

