/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.QryModelSortService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelSortDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelSortController
extends BaseController<QryModelSortDTO, QryModelSortService> {
    @RequestMapping(value={"/api/qry/model/sorts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelSortDTO>> queryQryModelSortAll(QryModelSortDTO vo) {
        List outputDTO = ((QryModelSortService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/sort/{sortId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelSortDTO> queryByPk(@PathVariable(value="sortId") String sortId, @RequestParam(value="qryId") String qryId) {
        QryModelSortDTO inDTO = new QryModelSortDTO();
        inDTO.setSortId(sortId);
        inDTO.setQryId(qryId);
        QryModelSortDTO outputDTO = (QryModelSortDTO)((QryModelSortService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/sort"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelSortDTO inQryModelSortDTO) {
        int outputDTO = ((QryModelSortService)this.getService()).deleteByPk((Object)inQryModelSortDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/sort"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelSortDTO inQryModelSortDTO) {
        inQryModelSortDTO.setLastUpdateUser(inQryModelSortDTO.getLoginUserId());
        inQryModelSortDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelSortService)this.getService()).updateByPk((Object)inQryModelSortDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/sort"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelSort(@RequestBody QryModelSortDTO inQryModelSortDTO) {
        if (StringUtils.isBlank((CharSequence)inQryModelSortDTO.getSortId())) {
            inQryModelSortDTO.setSortId(UUIDUtil.getUUID());
            inQryModelSortDTO.setCreateUser(inQryModelSortDTO.getLoginUserId());
            inQryModelSortDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            int outputDTO = ((QryModelSortService)this.getService()).insert((Object)inQryModelSortDTO);
            return this.getResponseData(outputDTO);
        }
        return this.updateByPk(inQryModelSortDTO);
    }
}

