/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.QueryDatasourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QueryDatasourceDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QueryDatasourceController
extends BaseController<QueryDatasourceDTO, QueryDatasourceService> {
    @Autowired
    private ModelTableInfoService modelTableInfoService;

    @RequestMapping(value={"/api/query/datasources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QueryDatasourceDTO>> queryQueryDatasourceAll(QueryDatasourceDTO vo) {
        List outputDTO = ((QueryDatasourceService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/query/datasource/{dsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QueryDatasourceDTO> queryByPk(@PathVariable(value="dsId") String dsId) {
        QueryDatasourceDTO inDTO = new QueryDatasourceDTO();
        inDTO.setDsId(dsId);
        QueryDatasourceDTO outputDTO = (QueryDatasourceDTO)((QueryDatasourceService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/query/datasource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QueryDatasourceDTO inQueryDatasourceDTO) {
        int outputDTO = ((QueryDatasourceService)this.getService()).deleteByPk((Object)inQueryDatasourceDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/query/datasource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QueryDatasourceDTO inQueryDatasourceDTO) {
        inQueryDatasourceDTO.setLastUpdateUser(inQueryDatasourceDTO.getLoginUserId());
        inQueryDatasourceDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QueryDatasourceService)this.getService()).updateByPk((Object)inQueryDatasourceDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/query/datasource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertQueryDatasource(@RequestBody QueryDatasourceDTO inQueryDatasourceDTO) {
        if (StringUtils.isBlank((CharSequence)inQueryDatasourceDTO.getDsId())) {
            inQueryDatasourceDTO.setDsId(UUIDUtil.getUUID());
        }
        inQueryDatasourceDTO.setCreateUser(inQueryDatasourceDTO.getLoginUserId());
        inQueryDatasourceDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QueryDatasourceService)this.getService()).insert((Object)inQueryDatasourceDTO);
        return this.getResponseData(outputDTO == 1 ? inQueryDatasourceDTO.getDsId() : "");
    }

    @RequestMapping(value={"/api/query/datasource/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> importDsTableModel(@RequestBody QueryDatasourceDTO inQueryDatasourceDTO) {
        int outputDTO = ((QueryDatasourceService)this.getService()).importDsTableModel(inQueryDatasourceDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/query/datasources/tables"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryDsTables(@RequestBody QueryDatasourceDTO vo) {
        vo.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List dsList = ((QueryDatasourceService)this.getService()).queryList((Object)vo);
        HashMap<String, Object> outputDTO = new HashMap<String, Object>();
        outputDTO.put("ds", dsList);
        HashMap<String, List> tableMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)dsList)) {
            for (QueryDatasourceDTO ds : dsList) {
                ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
                tableParam.setDsId(ds.getDsId());
                tableParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                List tableList = this.modelTableInfoService.queryDsTableListByPage(tableParam);
                tableMap.put(ds.getDsId(), tableList);
            }
        }
        outputDTO.put("table", tableMap);
        return this.getResponseData(outputDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/query/datasource/connection/test"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> dsConnectionTest(@RequestBody QueryDatasourceDTO vo) {
        QueryDatasourceDTO qd = vo;
        String dbUrl = qd.getDsConnStr();
        String dbUser = qd.getDsUsername();
        String dbPwd = qd.getDsPassword();
        DBImportPlugin readPlugin = DBImportPlugin.Factory.getInstance((int)qd.getDsDbms());
        Connection conn = null;
        try {
            conn = readPlugin.getDBConnection(dbUrl, dbUser, dbPwd);
            if (conn != null) {
                ResponseData responseData = this.getResponseData("\u8fde\u63a5\u6210\u529f");
                return responseData;
            }
            ResponseData responseData = this.getResponseData("\u8fde\u63a5\u5931\u8d25");
            return responseData;
        }
        catch (Exception e) {
            ResponseData responseData = this.getResponseData("\u8fde\u63a5\u5931\u8d25\uff0c" + e.getMessage());
            return responseData;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

