/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.dev.console.facade.SrvErrorMappingService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvErrorMappingDTO;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class SrvErrorMappingController
extends BaseController<SrvErrorMappingDTO, SrvErrorMappingService> {
    @RequestMapping(value={"/api/srv/error/mappings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvErrorMappingDTO>> queryDictErrorInfoAll(SrvErrorMappingDTO vo) {
        List outputVo = ((SrvErrorMappingService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/error/mapping/{appId}/{errorCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvErrorMappingDTO> queryByPk(@PathVariable(value="appId") String appId, @PathVariable(value="errorCode") String errorCode) {
        SrvErrorMappingDTO inVo = new SrvErrorMappingDTO();
        inVo.setAppId(appId);
        inVo.setErrorCode(errorCode);
        SrvErrorMappingDTO outputVo = (SrvErrorMappingDTO)((SrvErrorMappingService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/error/mapping"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvErrorMappingDTO inSrvErrorMappingVo) {
        int outputVo = ((SrvErrorMappingService)this.getService()).deleteByPk((Object)inSrvErrorMappingVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/error/mapping"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvErrorMappingDTO inSrvErrorMappingVo) {
        int outputVo = ((SrvErrorMappingService)this.getService()).updateByPk((Object)inSrvErrorMappingVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/error/mapping"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictErrorInfo(@RequestBody SrvErrorMappingDTO inSrvErrorMappingVo) {
        int outputVo = ((SrvErrorMappingService)this.getService()).insert((Object)inSrvErrorMappingVo);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/srv/error/mapping/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "srvErrorMapping.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u54cd\u5e94\u4fe1\u606f\u9879\u6a21\u677f.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @PostMapping(value={"/api/srv/error/mapping/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, final @RequestParam(value="subsId") String subsId, final @RequestParam(value="appId") String appId, @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        try {
            final ArrayList list = new ArrayList();
            UserInfo userInfo = this.getUserInfo();
            String createTime = TimeUtil.getCurrentDateTime();
            List<String> HEAD = Arrays.asList("\u54cd\u5e94\u7801", "\u54cd\u5e94\u4fe1\u606f\u6a21\u677f");
            final ArrayList headCellList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), SrvErrorMappingExcel.class, (ReadListener)new AnalysisEventListener<SrvErrorMappingExcel>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(SrvErrorMappingExcel data, AnalysisContext analysisContext) {
                    SrvErrorMappingDTO srvError = new SrvErrorMappingDTO();
                    srvError.setSubsId(subsId);
                    srvError.setAppId(appId);
                    srvError.setErrorCode(data.getErrorCode());
                    srvError.setErrorMessage(data.getErrorMessage());
                    list.add(srvError);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet().headRowNumber(Integer.valueOf(1))).doReadSync();
            if (headCellList.size() != HEAD.size()) {
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 0; i < HEAD.size(); ++i) {
                if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            if (list.size() > 0) {
                ((SrvErrorMappingService)this.getService()).excelUpload(appId, excelUploadType, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getResponseData("S");
    }

    public static class SrvErrorMappingExcel {
        @ExcelProperty(value={"\u54cd\u5e94\u7801"})
        private String errorCode;
        @ExcelProperty(value={"\u54cd\u5e94\u4fe1\u606f\u6a21\u677f"})
        private String errorMessage;

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

