/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.google.gson.JsonObject;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SrvModelInoutController
extends BaseController<SrvModelInoutDTO, SrvModelInoutService> {
    @Autowired
    @Qualifier(value="srvModelInoutServiceImpl")
    private SrvModelInoutService srvModelInoutService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/srv/model/inouts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInoutDTO>> querySrvModelInoutAll(SrvModelInoutDTO vo) {
        if (StringUtils.contains((CharSequence)vo.getIoType(), (CharSequence)",")) {
            vo.setIoTypes(Arrays.asList(StringUtils.split((String)vo.getIoType(), (String)",")));
            vo.setIoType(null);
        }
        List outputVo = this.srvModelInoutService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inouts/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelInoutDTO>> queryAllOwnerNotPage(SrvModelInoutDTO vo) {
        List outputVo = this.srvModelInoutService.queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout/{recordKeyId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvModelInoutDTO> queryByPk(@PathVariable(value="recordKeyId") String recordKeyId) {
        SrvModelInoutDTO inVo = new SrvModelInoutDTO();
        inVo.setRecordKeyId(recordKeyId);
        SrvModelInoutDTO outputVo = (SrvModelInoutDTO)this.srvModelInoutService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout"}, method={RequestMethod.DELETE})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u670d\u52a1\u5165\u53c2\u51fa\u53c2\u5220\u9664 ${args[0].tableModelName} ${args[0].tableModelCode}", objectId="${args[0].tableModelId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvModelInoutDTO inSrvModelInoutVo) {
        int outputVo = 0;
        try {
            outputVo = this.srvModelInoutService.deleteByPk((Object)inSrvModelInoutVo);
        }
        catch (Exception e) {
            outputVo = -1;
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvModelInoutDTO inSrvModelInoutVo) {
        int outputVo = this.srvModelInoutService.updateByPk((Object)inSrvModelInoutVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout/{srvModelId}/{tableModelId}/{oldData}/{newData}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@PathVariable(value="srvModelId") String srvModelId, @PathVariable(value="tableModelId") String tableModelId, @PathVariable(value="oldData") String oldData, @PathVariable(value="newData") String newData) {
        JsonObject oldJsonObject = new JsonObject();
        oldJsonObject.addProperty("fieldCode", oldData.split("_1_")[0]);
        oldJsonObject.addProperty("mustNeed", oldData.split("_1_")[1]);
        JsonObject newJsonObject = new JsonObject();
        newJsonObject.addProperty("fieldCode", newData.split("_1_")[0]);
        newJsonObject.addProperty("mustNeed", newData.split("_1_")[1]);
        SrvModelInoutDTO srvModelInoutVO = new SrvModelInoutDTO();
        srvModelInoutVO.setSrvModelId(srvModelId);
        srvModelInoutVO.setTableModelId(tableModelId);
        srvModelInoutVO.setIoType("I");
        srvModelInoutVO = this.srvModelInoutService.queryBySrvModelIdAndTableModelId(srvModelInoutVO);
        int outputVo = this.srvModelInoutService.updateByPk((Object)srvModelInoutVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSrvModelInout(@RequestBody SrvModelInoutDTO inSrvModelInoutVo) {
        if (StringUtils.isBlank((CharSequence)inSrvModelInoutVo.getRecordKeyId())) {
            inSrvModelInoutVo.setRecordKeyId(UUIDUtil.getUUID());
        }
        int outputVo = this.srvModelInoutService.insert((Object)inSrvModelInoutVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/inout/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySrvModelAllFields(@RequestParam(value="srvModelId") String srvModelId) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(srvModelId);
        inoutParam.setIoType(IOType.Input.getCode());
        List vars = this.srvModelInoutService.queryList((Object)inoutParam);
        ArrayList<SrvModelInoutDTO> inputs = new ArrayList<SrvModelInoutDTO>();
        HashMap<String, List> fieldsMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)vars)) {
            for (SrvModelInoutDTO v : vars) {
                inputs.add(v);
                if (!StringUtils.isNotBlank((CharSequence)v.getTableModelId())) continue;
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(v.getTableModelId());
                List fields = this.modelTableFieldService.queryList((Object)fieldParam);
                fieldsMap.put(v.getTableModelId(), fields);
            }
        }
        result.put(DomainVarType.Input.getCode(), inputs);
        result.put("fields", fieldsMap);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/srv/model/inout/index/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySrvModelAllFieldsForIndex(@RequestParam(value="srvModelId") String srvModelId) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(srvModelId);
        List vars = this.srvModelInoutService.queryList((Object)inoutParam);
        ArrayList<SrvModelInoutDTO> inputs = new ArrayList<SrvModelInoutDTO>();
        ArrayList<SrvModelInoutDTO> outputs = new ArrayList<SrvModelInoutDTO>();
        ArrayList middles = new ArrayList();
        HashMap<String, List> fieldsMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)vars)) {
            for (SrvModelInoutDTO v : vars) {
                if (v.getIoType().equals(IOType.Input.getCode())) {
                    inputs.add(v);
                } else if (v.getIoType().equals(IOType.Output.getCode())) {
                    outputs.add(v);
                } else if (v.getIoType().equals(IOType.Middle.getCode())) continue;
                if (!StringUtils.isNotBlank((CharSequence)v.getTableModelId())) continue;
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(v.getTableModelId());
                List fields = this.modelTableFieldService.queryList((Object)fieldParam);
                fieldsMap.put(v.getTableModelId(), fields);
            }
        }
        result.put(IOType.Input.getCode(), inputs);
        result.put(IOType.Output.getCode(), outputs);
        result.put("fields", fieldsMap);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/client/SrvModelInoutService/deleteBySrvModelId"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteBySrvModelId(@RequestBody SrvModelInoutDTO srvModelInoutVo) {
        return ((SrvModelInoutService)this.getService()).deleteBySrvModelId(srvModelInoutVo);
    }

    @RequestMapping(value={"/client/SrvModelInoutService/countByTableModelId"}, method={RequestMethod.POST})
    @ResponseBody
    public int countByTableModelId(@RequestParam(value="appId") String appId, @RequestParam(value="tableModelId") String tableModelId) {
        return ((SrvModelInoutService)this.getService()).countByTableModelId(appId, tableModelId);
    }
}

