/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.facade.RdmBugInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmBugInfoDTO;
import com.irdstudio.allinrdm.project.console.types.BugType;
import com.irdstudio.allinrdm.project.console.types.RdmBugFlowState;
import com.irdstudio.allinrdm.project.console.types.RdmBugReproducible;
import com.irdstudio.allinrdm.project.console.types.RdmBugSeverity;
import com.irdstudio.allinrdm.project.console.types.RdmBugTestType;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class RdmBugInfoController
extends BaseController<RdmBugInfoDTO, RdmBugInfoService> {
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;
    @Autowired
    protected RdmModuleInfoService rdmModuleInfoService;
    public static Pattern pattern = Pattern.compile("(\\d+)\u5e74(\\d+)\u6708(\\d+)[\u65e5\u53f7] (\\d+)\\:\\d+\\:\\d");

    @RequestMapping(value={"/api/rdm/bug/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmBugInfoDTO>> queryRdmBugInfoAll(RdmBugInfoDTO dto) {
        List outputVo = ((RdmBugInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/bug/info/{bugId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmBugInfoDTO> queryByPk(@PathVariable(value="bugId") String bugId) {
        RdmBugInfoDTO inVo = new RdmBugInfoDTO();
        inVo.setBugId(bugId);
        RdmBugInfoDTO outputVo = (RdmBugInfoDTO)((RdmBugInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/bug/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmBugInfoDTO inRdmBugInfoDTO) {
        int outputVo = ((RdmBugInfoService)this.getService()).deleteByPk((Object)inRdmBugInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/bug/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmBugInfoDTO inRdmBugInfoDTO) {
        this.setUserInfoToVO(inRdmBugInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inRdmBugInfoDTO.setLastUpdateUser(userId);
        inRdmBugInfoDTO.setLastUpdateTime(now);
        int outputVo = ((RdmBugInfoService)this.getService()).updateByPk((Object)inRdmBugInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/bug/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmBugInfo(@RequestBody RdmBugInfoDTO inRdmBugInfoDTO) {
        this.setUserInfoToVO(inRdmBugInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inRdmBugInfoDTO.setCreateUser(userId);
        inRdmBugInfoDTO.setCreateUserName(this.getUserInfo().getUserName());
        inRdmBugInfoDTO.setCreateTime(now);
        inRdmBugInfoDTO.setLastUpdateUser(userId);
        inRdmBugInfoDTO.setLastUpdateTime(now);
        if (StringUtils.isBlank((CharSequence)inRdmBugInfoDTO.getBugId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inRdmBugInfoDTO.setBugId(seqService.nextSequence("RDM-BUG-SEQ", inRdmBugInfoDTO.getProjectId()));
        }
        int outputVo = ((RdmBugInfoService)this.getService()).insert((Object)inRdmBugInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/bug/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxId() {
        return this.getResponseData(((RdmBugInfoService)this.getService()).queryMaxId());
    }

    @RequestMapping(value={"/api/rdm/bug/info/incharges"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmBugInchargeGroupByPage(RdmBugInfoDTO param) {
        List outputVo = ((RdmBugInfoService)this.getService()).queryRdmBugInchargeGroupByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/RdmBugInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByCond(@RequestBody RdmBugInfoDTO param) {
        return ((RdmBugInfoService)this.getService()).deleteByCond(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/rdm/bug/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="moduleId", required=false) String moduleId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", "\u4e0d\u7b26\u5408\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String userId = this.getUserInfo().getUserId();
            RdmBugExcelListener listener = new RdmBugExcelListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmBugInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(el -> {
                    RdmModuleInfoDTO moduleInfo = this.rdmModuleInfoService.findModuleMapping(projectId, el.getModuleName());
                    if (moduleInfo != null) {
                        el.setModuleId(moduleInfo.getModuleId());
                        el.setModuleName(moduleInfo.getModuleName());
                    }
                    el.setProjectId(projectId);
                    el.setSubsId(subsId);
                    el.setLoginUserId(userId);
                    el.setBugType(BugType.BUG_TYPE_01.getCode());
                });
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    RdmBugInfoDTO deleteParam = new RdmBugInfoDTO();
                    deleteParam.setProjectId(projectId);
                    deleteParam.setModuleId(moduleId);
                    ((RdmBugInfoService)this.getService()).deleteByCond(deleteParam);
                }
                ((RdmBugInfoService)this.getService()).saveExcel(list);
            }
            responseData = this.getResponseData("\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    public static String parseExcelUploadDateString(String excelStr, String formatPattern) {
        if (StringUtils.isNotBlank((CharSequence)excelStr)) {
            String formatStr = excelStr;
            Matcher startedMatcher = pattern.matcher(excelStr);
            if (startedMatcher.matches()) {
                formatStr = String.format("%s-%s-%s %s:%s:%s\"", startedMatcher.group(1), StringUtils.leftPad((String)startedMatcher.group(2), (int)2, (String)"0"), StringUtils.leftPad((String)startedMatcher.group(3), (int)2, (String)"0"), StringUtils.leftPad((String)startedMatcher.group(4), (int)2, (String)"0"), StringUtils.leftPad((String)startedMatcher.group(5), (int)2, (String)"0"), StringUtils.leftPad((String)startedMatcher.group(6), (int)2, (String)"0"));
            } else {
                formatStr = StringUtils.replaceEach((String)excelStr, (String[])new String[]{".", "/", "\\"}, (String[])new String[]{"-", "-", "-"});
                Object[] strs = StringUtils.split((String)formatStr, (String)"-");
                for (int i = 0; i < strs.length; ++i) {
                    if (strs[i].length() != 1) continue;
                    strs[i] = StringUtils.leftPad((String)strs[i], (int)2, (String)"0");
                }
                formatStr = StringUtils.join((Object[])strs, (String)"-");
            }
            if (StringUtils.isBlank((CharSequence)formatPattern)) {
                formatPattern = "yyyy-MM-dd HH:mm:ss";
            }
            if (StringUtils.equals((CharSequence)formatPattern, (CharSequence)"yyyy-MM-dd HH:mm:ss")) {
                return formatStr;
            }
            try {
                Date date = DateUtils.parseDate((String)formatStr, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                return DateFormatUtils.format((Date)date, (String)formatPattern);
            }
            catch (Exception e) {
                return excelStr;
            }
        }
        return excelStr;
    }

    @RequestMapping(value={"/api/rdm/bug/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBugSummary(@RequestBody RdmBugInfoDTO paramDTO) {
        List outputVo = ((RdmBugInfoService)this.getService()).queryBugSummary(paramDTO);
        ResponseData resp = this.getResponseData(outputVo);
        return resp;
    }

    public static class CellItem {
        @ExcelProperty(value={"\u7f3a\u9677\u7f16\u53f7"})
        private String bugId;
        @ExcelProperty(value={"\u7f3a\u9677\u6807\u9898"})
        private String bugName;
        @ExcelProperty(value={"\u6d4b\u8bd5\u73af\u5883"})
        private String bugTestEnv;
        @ExcelProperty(value={"\u6d4b\u8bd5\u9636\u6bb5"})
        private String bugTestStage;
        @ExcelProperty(value={"\u6d4b\u8bd5\u8f6e\u6b21"})
        private String bugTestRound;
        @ExcelProperty(value={"\u53d1\u73b0\u6a21\u5757"})
        private String moduleName;
        @ExcelProperty(value={"\u53d1\u73b0\u4ea4\u6613"})
        private String fnName;
        @ExcelProperty(value={"\u5904\u7406\u4eba"})
        private String inchargeName;
        @ExcelProperty(value={"\u4e25\u91cd\u7ea7\u522b"})
        private String bugSeverity;
        @ExcelProperty(value={"\u7f3a\u9677\u72b6\u6001"})
        private String bugFlowState;
        @ExcelProperty(value={"\u521b\u5efa\u4eba"})
        private String proposerName;
        @ExcelProperty(value={"\u7f3a\u9677\u63cf\u8ff0"})
        private String bugContent;
        @ExcelProperty(value={"\u6ce8\u91ca"})
        private String bugRemark;
        @ExcelProperty(value={"\u53ef\u91cd\u73b0"})
        private String bugReproducible;
        @ExcelProperty(value={"\u6d4b\u8bd5\u7c7b\u578b"})
        private String bugTestType;
        @ExcelProperty(value={"\u662f\u5426\u5386\u53f2\u95ee\u9898"})
        private String bugOldFlag;
        @ExcelProperty(value={"\u91cd\u65b0\u6253\u5f00\u6b21\u6570"})
        private Integer bugReopenNum;
        @ExcelProperty(value={"\u9884\u8ba1\u4fee\u590d\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss")
        private String bugDeadline;
        @ExcelProperty(value={"\u521b\u5efa\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss")
        private String bugStarted;
        @ExcelProperty(value={"\u5173\u95ed\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss")
        private String bugFinished;

        public String getBugId() {
            return this.bugId;
        }

        public void setBugId(String bugId) {
            this.bugId = bugId;
        }

        public String getBugTestEnv() {
            return this.bugTestEnv;
        }

        public void setBugTestEnv(String bugTestEnv) {
            this.bugTestEnv = bugTestEnv;
        }

        public String getBugTestStage() {
            return this.bugTestStage;
        }

        public void setBugTestStage(String bugTestStage) {
            this.bugTestStage = bugTestStage;
        }

        public String getBugTestRound() {
            return this.bugTestRound;
        }

        public void setBugTestRound(String bugTestRound) {
            this.bugTestRound = bugTestRound;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getFnName() {
            return this.fnName;
        }

        public void setFnName(String fnName) {
            this.fnName = fnName;
        }

        public String getInchargeName() {
            return this.inchargeName;
        }

        public void setInchargeName(String inchargeName) {
            this.inchargeName = inchargeName;
        }

        public String getBugSeverity() {
            return this.bugSeverity;
        }

        public void setBugSeverity(String bugSeverity) {
            this.bugSeverity = bugSeverity;
        }

        public String getBugFlowState() {
            return this.bugFlowState;
        }

        public void setBugFlowState(String bugFlowState) {
            this.bugFlowState = bugFlowState;
        }

        public String getProposerName() {
            return this.proposerName;
        }

        public void setProposerName(String proposerName) {
            this.proposerName = proposerName;
        }

        public String getBugContent() {
            return this.bugContent;
        }

        public void setBugContent(String bugContent) {
            this.bugContent = bugContent;
        }

        public String getBugRemark() {
            return this.bugRemark;
        }

        public void setBugRemark(String bugRemark) {
            this.bugRemark = bugRemark;
        }

        public String getBugReproducible() {
            return this.bugReproducible;
        }

        public void setBugReproducible(String bugReproducible) {
            this.bugReproducible = bugReproducible;
        }

        public String getBugTestType() {
            return this.bugTestType;
        }

        public void setBugTestType(String bugTestType) {
            this.bugTestType = bugTestType;
        }

        public String getBugOldFlag() {
            return this.bugOldFlag;
        }

        public void setBugOldFlag(String bugOldFlag) {
            this.bugOldFlag = bugOldFlag;
        }

        public Integer getBugReopenNum() {
            return this.bugReopenNum;
        }

        public void setBugReopenNum(Integer bugReopenNum) {
            this.bugReopenNum = bugReopenNum;
        }

        public String getBugDeadline() {
            return this.bugDeadline;
        }

        public void setBugDeadline(String bugDeadline) {
            this.bugDeadline = bugDeadline;
        }

        public String getBugStarted() {
            return this.bugStarted;
        }

        public void setBugStarted(String bugStarted) {
            this.bugStarted = bugStarted;
        }

        public String getBugFinished() {
            return this.bugFinished;
        }

        public void setBugFinished(String bugFinished) {
            this.bugFinished = bugFinished;
        }

        public String getBugName() {
            return this.bugName;
        }

        public void setBugName(String bugName) {
            this.bugName = bugName;
        }
    }

    public static class RdmBugExcelListener
    extends AnalysisEventListener<CellItem> {
        private List<RdmBugInfoDTO> list = new ArrayList<RdmBugInfoDTO>();

        public List<RdmBugInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            String users;
            String[] userNames;
            RdmBugInfoDTO vo = new RdmBugInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            if (StringUtils.contains((CharSequence)data.getBugSeverity(), (CharSequence)"-")) {
                vo.setBugSeverity(StringUtils.split((String)data.getBugSeverity(), (String)"-")[0]);
            } else {
                vo.setBugSeverity(RdmBugSeverity.codeByName((String)data.getBugSeverity()));
            }
            RdmBugFlowState bugFlogStat = RdmBugFlowState.getByName((String)data.getBugFlowState());
            if (bugFlogStat != null) {
                vo.setBugFlowState(bugFlogStat.getCode());
                vo.setBugState(bugFlogStat.getMapStat());
            }
            vo.setBugReproducible(RdmBugReproducible.codeByName((String)data.getBugReproducible()));
            vo.setBugTestType(RdmBugTestType.codeByName((String)data.getBugTestType()));
            vo.setBugOldFlag(YesOrNO.codeByName((String)data.getBugOldFlag()));
            vo.setBugName(vo.getBugContent());
            if (StringUtils.containsAny((CharSequence)vo.getInchargeName(), (CharSequence[])new CharSequence[]{"\u3001", ",", "\uff0c"}) && (userNames = StringUtils.split((String)(users = StringUtils.replaceEach((String)vo.getInchargeName(), (String[])new String[]{"\u3001", ",", "\uff0c"}, (String[])new String[]{",", ",", ","})), (String)",")) != null && userNames.length > 1) {
                vo.setInchargeName(userNames[0]);
                vo.setCollaboratorName(userNames[1]);
            }
            vo.setBugStarted(RdmBugInfoController.parseExcelUploadDateString(vo.getBugStarted(), null));
            vo.setBugDeadline(RdmBugInfoController.parseExcelUploadDateString(vo.getBugDeadline(), null));
            vo.setBugFinished(RdmBugInfoController.parseExcelUploadDateString(vo.getBugFinished(), null));
            vo.setFpId(data.getFnName());
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

