/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.RdmPlanInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmPlanInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmPlanInfoController
extends BaseController<RdmPlanInfoDTO, RdmPlanInfoService> {
    @RequestMapping(value={"/api/rdm/plan/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmPlanInfoDTO>> queryRdmPlanInfoAll(RdmPlanInfoDTO dto) {
        List outputVo = ((RdmPlanInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmPlanInfoDTO>> queryList(RdmPlanInfoDTO dto) {
        List outputVo = ((RdmPlanInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/info/{planId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmPlanInfoDTO> queryByPk(@PathVariable(value="planId") String planId) {
        RdmPlanInfoDTO inVo = new RdmPlanInfoDTO();
        inVo.setPlanId(planId);
        RdmPlanInfoDTO outputVo = (RdmPlanInfoDTO)((RdmPlanInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryPlanId(@RequestParam(value="projectId") String projectId) {
        return this.getResponseData(((RdmPlanInfoService)this.getService()).queryMaxId(projectId));
    }

    @RequestMapping(value={"/api/rdm/plan/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmPlanInfoDTO inRdmPlanInfoDTO) {
        int outputVo = ((RdmPlanInfoService)this.getService()).deleteByPk((Object)inRdmPlanInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmPlanInfoDTO inRdmPlanInfoDTO) {
        int outputVo = ((RdmPlanInfoService)this.getService()).updateByPk((Object)inRdmPlanInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmPlanInfo(@RequestBody RdmPlanInfoDTO inRdmPlanInfoDTO) {
        this.setUserInfoToVO(inRdmPlanInfoDTO);
        inRdmPlanInfoDTO.setCreateUser(inRdmPlanInfoDTO.getLoginUserId());
        inRdmPlanInfoDTO.setCreateUserName(inRdmPlanInfoDTO.getLoginUserName());
        inRdmPlanInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((CharSequence)inRdmPlanInfoDTO.getPlanId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inRdmPlanInfoDTO.setPlanId(seqService.nextSequence("RDM-PRJ-PLN-SEQ", inRdmPlanInfoDTO.getProjectId()));
        }
        int outputVo = ((RdmPlanInfoService)this.getService()).insert((Object)inRdmPlanInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/plan/info/incharge/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryPlanInchargeGroupByPage(RdmPlanInfoDTO paramDTO) {
        List outputVo = ((RdmPlanInfoService)this.getService()).queryPlanInchargeGroupByPage(paramDTO);
        ResponseData resp = this.getResponseData(outputVo);
        return resp;
    }

    @RequestMapping(value={"/api/rdm/plan/infos/exec"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryPlanExecByPage(RdmPlanInfoDTO paramDTO) {
        List outputVo = ((RdmPlanInfoService)this.getService()).queryPlanExecByPage(paramDTO);
        ResponseData resp = this.getResponseData(outputVo);
        return resp;
    }

    @RequestMapping(value={"/api/rdm/plan/info/user/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmPlanWorkloadUserByPage(RdmPlanInfoDTO param) {
        List resultList = ((RdmPlanInfoService)this.getService()).queryRdmPlanWorkloadUserByPage(param);
        return this.getResponseData(resultList);
    }

    @RequestMapping(value={"/api/rdm/plan/info/time/line"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmPlanTimeLineData(RdmPlanInfoDTO param) {
        List resultList = ((RdmPlanInfoService)this.getService()).queryRdmPlanTimeLineData(param);
        return this.getResponseData(resultList);
    }

    @RequestMapping(value={"/api/rdm/plan/info/workloads"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmPlanInfoDTO>> queryPlanWorkloadByPage(RdmPlanInfoDTO param) {
        List resultList = ((RdmPlanInfoService)this.getService()).queryPlanWorkloadByPage(param);
        return this.getResponseData(resultList);
    }

    @RequestMapping(value={"/api/rdm/plan/info/period/date"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmPlanInfoDTO> queryProjectPlanPeriod(@RequestParam(value="projectId") String projectId) {
        RdmPlanInfoDTO param = new RdmPlanInfoDTO();
        param.setProjectId(projectId);
        return this.getResponseData(((RdmPlanInfoService)this.getService()).queryProjectPlanPeriod(param));
    }

    @RequestMapping(value={"/client/RdmPlanInfoService/queryPlanInchargeGroupByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryPlanInchargeGroupByPage_client(@RequestBody RdmPlanInfoDTO paramDTO) {
        return ((RdmPlanInfoService)this.getService()).queryPlanInchargeGroupByPage(paramDTO);
    }

    @RequestMapping(value={"/client/RdmPlanInfoService/queryRdmPlanWorkloadUserByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryRdmPlanWorkloadUserByPage_client(@RequestBody RdmPlanInfoDTO paramDTO) {
        return ((RdmPlanInfoService)this.getService()).queryRdmPlanWorkloadUserByPage(paramDTO);
    }

    @RequestMapping(value={"/client/RdmPlanInfoService/queryRdmPlanTimeLineData"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryRdmPlanTimeLineData_client(@RequestBody RdmPlanInfoDTO paramDTO) {
        return ((RdmPlanInfoService)this.getService()).queryRdmPlanTimeLineData(paramDTO);
    }

    @RequestMapping(value={"/client/RdmPlanInfoService/queryPlanWorkloadByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<RdmPlanInfoDTO> queryPlanWorkloadByPage_client(@RequestBody RdmPlanInfoDTO paramDTO) {
        return ((RdmPlanInfoService)this.getService()).queryPlanWorkloadByPage(paramDTO);
    }

    @RequestMapping(value={"/api/rdm/plan/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryPlanSummary(@RequestBody RdmPlanInfoDTO paramDTO) {
        List outputVo = ((RdmPlanInfoService)this.getService()).queryPlanSummary(paramDTO);
        ResponseData resp = this.getResponseData(outputVo);
        return resp;
    }
}

