/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskTmpService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskTmpDTO;
import com.irdstudio.allinrdm.project.console.types.TaskCategory;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.allinrdm.project.console.types.TaskType;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.DateUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class RdmTaskInfoController
extends BaseController<RdmTaskInfoDTO, RdmTaskInfoService> {
    @Autowired
    protected RdmTaskTmpService rdmTaskTmpService;
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;

    @RequestMapping(value={"/api/rdm/task/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmTaskInfoDTO>> queryRdmTaskInfoAll(RdmTaskInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getTaskState(), (CharSequence)",")) {
            String[] states = StringUtils.split((String)dto.getTaskState(), (String)",");
            dto.setTaskState(null);
            dto.setTaskStates(Arrays.asList(states));
        }
        if (StringUtils.contains((CharSequence)dto.getPlanId(), (CharSequence)",")) {
            String[] objectiveIds = StringUtils.split((String)dto.getPlanId(), (String)",");
            dto.setPlanId(null);
            dto.setPlanIdList(Arrays.asList(objectiveIds));
        }
        List outputVo = ((RdmTaskInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/task/info/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmTaskInfoDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        RdmTaskInfoDTO inVo = new RdmTaskInfoDTO();
        inVo.setTaskId(taskId);
        RdmTaskInfoDTO outputVo = (RdmTaskInfoDTO)((RdmTaskInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/task/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmTaskInfoDTO inRdmTaskInfoDTO) {
        int outputVo = ((RdmTaskInfoService)this.getService()).deleteByPk((Object)inRdmTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/task/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmTaskInfoDTO inRdmTaskInfoDTO) {
        this.setUserInfoToVO(inRdmTaskInfoDTO);
        inRdmTaskInfoDTO.setLastUpdateUser(inRdmTaskInfoDTO.getLoginUserId());
        inRdmTaskInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RdmTaskInfoService)this.getService()).updateByPk((Object)inRdmTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/task/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmTaskInfo(@RequestBody RdmTaskInfoDTO inRdmTaskInfoDTO) {
        if (StringUtils.isBlank((CharSequence)inRdmTaskInfoDTO.getTaskId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inRdmTaskInfoDTO.setTaskId(seqService.nextSequence("RDM-TSK-SEQ", inRdmTaskInfoDTO.getProjectId()));
        }
        this.setUserInfoToVO(inRdmTaskInfoDTO);
        inRdmTaskInfoDTO.setCreateUser(inRdmTaskInfoDTO.getLoginUserId());
        inRdmTaskInfoDTO.setCreateUserName(inRdmTaskInfoDTO.getLoginUserName());
        inRdmTaskInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inRdmTaskInfoDTO.setLastUpdateUser(inRdmTaskInfoDTO.getLoginUserId());
        inRdmTaskInfoDTO.setLastUpdateTime(inRdmTaskInfoDTO.getCreateTime());
        int outputVo = ((RdmTaskInfoService)this.getService()).insert((Object)inRdmTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/task/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxId() {
        return this.getResponseData(((RdmTaskInfoService)this.getService()).queryMaxId());
    }

    @RequestMapping(value={"/api/rdm/task/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryTaskSummary(@RequestBody RdmTaskInfoDTO param) {
        List homePageVOList = ((RdmTaskInfoService)this.getService()).queryTaskSummary(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/task/info/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmTaskSummaryByPage(RdmTaskInfoDTO param) {
        List homePageVOList = ((RdmTaskInfoService)this.getService()).queryRdmTaskSummaryByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/task/info/incharge/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmTaskInchargeGroupByPage(RdmTaskInfoDTO param) {
        List homePageVOList = ((RdmTaskInfoService)this.getService()).queryRdmTaskInchargeGroupByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/task/info/page/home/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryHomeTaskSummary(RdmTaskInfoDTO param) {
        List homePageVOList = ((RdmTaskInfoService)this.getService()).queryHomeTaskSummary(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/rdm/task/info/time/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmTaskWorkloadTimeByPage(RdmTaskInfoDTO param) {
        List resultList = ((RdmTaskInfoService)this.getService()).queryRdmTaskWorkloadTimeByPage(param);
        return this.getResponseData(resultList);
    }

    @RequestMapping(value={"/api/rdm/task/info/user/page/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryRdmTaskWorkloadUserByPage(RdmTaskInfoDTO param) {
        List resultList = ((RdmTaskInfoService)this.getService()).queryRdmTaskWorkloadUserByPage(param);
        return this.getResponseData(resultList);
    }

    @RequestMapping(value={"/client/RdmTaskInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody RdmTaskInfoDTO param) {
        return ((RdmTaskInfoService)this.getService()).deleteByCond(param);
    }

    @RequestMapping(value={"/api/rdm/task/info/excel/exec"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> execExcelImport(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="planId", required=false) String planId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="serialNo") String serialNo) {
        try {
            RdmTaskTmpDTO tmpParam = new RdmTaskTmpDTO();
            tmpParam.setSerialNo(serialNo);
            List list = this.rdmTaskTmpService.queryList((Object)tmpParam);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List taskList = list.stream().map(tmp -> {
                    RdmTaskInfoDTO task = new RdmTaskInfoDTO();
                    BeanUtility.beanCopy((Object)tmp, (Object)task);
                    return task;
                }).collect(Collectors.toList());
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    RdmTaskInfoDTO deleteParam = new RdmTaskInfoDTO();
                    deleteParam.setProjectId(projectId);
                    deleteParam.setPlanId(planId);
                    ((RdmTaskInfoService)this.getService()).deleteByCond(deleteParam);
                }
                ((RdmTaskInfoService)this.getService()).saveExcel(this.getUserInfo().getUserId(), subsId, projectId, planId, taskList);
                this.rdmTaskTmpService.deleteByCond(tmpParam);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/rdm/task/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="planId", required=false) String planId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", "\u4e0d\u7b26\u5408\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String key = UUIDUtil.getShortUUID();
            RdmTaskExcelListener listener = new RdmTaskExcelListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmTaskTmpDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(tmp -> {
                    tmp.setRecordKeyid(UUIDUtil.getUUID());
                    tmp.setSerialNo(key);
                    tmp.setSubsId(subsId);
                    tmp.setProjectId(projectId);
                    tmp.setPlanId(planId);
                });
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    RdmTaskTmpDTO deleteParam = new RdmTaskTmpDTO();
                    deleteParam.setSerialNo(key);
                    this.rdmTaskTmpService.deleteByCond(deleteParam);
                }
                this.rdmTaskTmpService.batchInsert(list);
            }
            responseData = this.getResponseData(key, "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    @PostMapping(value={"/api/rdm/task/info/update/excel"})
    @ResponseBody
    public ResponseData<String> uploadUpdateTaskExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="planId", required=false) String planId, @RequestPart(value="file") MultipartFile file) {
        try {
            String key = UUIDUtil.getShortUUID();
            RdmTaskExcelListener listener = new RdmTaskExcelListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmTaskTmpDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(tmp -> {
                    tmp.setRecordKeyid(UUIDUtil.getUUID());
                    tmp.setSerialNo(key);
                    tmp.setSubsId(subsId);
                    tmp.setPlanId(planId);
                    tmp.setProjectId(projectId);
                });
                RdmTaskTmpDTO deleteParam = new RdmTaskTmpDTO();
                deleteParam.setSerialNo(key);
                this.rdmTaskTmpService.deleteByCond(deleteParam);
                this.rdmTaskTmpService.batchInsert(list);
            }
            return this.getResponseData(key, "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    @RequestMapping(value={"/api/rdm/task/info/update/excel/exec"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> execExcelImportUpdate(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="planId", required=false) String planId, @RequestParam(value="updateFields", required=false) String updateFields, @RequestParam(value="serialNo") String serialNo) {
        try {
            String userId = this.getUserInfo().getUserId();
            String now = CurrentDateUtil.getTodayDateEx2();
            RdmTaskTmpDTO tmpParam = new RdmTaskTmpDTO();
            tmpParam.setSerialNo(serialNo);
            List list = this.rdmTaskTmpService.queryList((Object)tmpParam);
            ArrayList taskUpdateList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.forEach(tmp -> {
                    RdmTaskInfoDTO task = new RdmTaskInfoDTO();
                    task.setTaskId(tmp.getTaskId());
                    task.setProjectId(projectId);
                    task.setPlanId(planId);
                    task.setSubsId(subsId);
                    task.setTaskCategory(tmp.getTaskCategory());
                    boolean hasUpdate = false;
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskName")) {
                        task.setTaskName(tmp.getTaskName());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskContent")) {
                        task.setTaskContent(tmp.getTaskContent());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskStarted")) {
                        task.setTaskStarted(tmp.getTaskStarted());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskDeadline")) {
                        task.setTaskDeadline(tmp.getTaskDeadline());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskEstWorkload")) {
                        task.setTaskEstWorkload(tmp.getTaskEstWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskRealWorkload")) {
                        task.setTaskRealWorkload(tmp.getTaskRealWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskFinished")) {
                        task.setTaskFinished(tmp.getTaskFinished());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskState")) {
                        task.setTaskState(tmp.getTaskState());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"inchargeName")) {
                        task.setInchargeName(tmp.getInchargeName());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"fpId")) {
                        task.setFpId(tmp.getFpId());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"collaboratorName")) {
                        task.setCollaboratorName(tmp.getCollaboratorName());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"taskRemark")) {
                        task.setTaskRemark(tmp.getTaskRemark());
                        hasUpdate = true;
                    }
                    if (hasUpdate) {
                        task.setLoginUserId(userId);
                        task.setLastUpdateUser(userId);
                        task.setLastUpdateTime(now);
                        taskUpdateList.add(task);
                    }
                });
                ((RdmTaskInfoService)this.getService()).batchUpdateTask(userId, subsId, projectId, taskUpdateList);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    @RequestMapping(value={"/client/RdmTaskInfoService/queryRdmTaskInchargeGroupByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryRdmTaskInchargeGroupByPage_client(@RequestBody RdmTaskInfoDTO paramDTO) {
        return ((RdmTaskInfoService)this.getService()).queryRdmTaskInchargeGroupByPage(paramDTO);
    }

    @RequestMapping(value={"/client/RdmTaskInfoService/queryRdmTaskWorkloadTimeByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryRdmTaskWorkloadTimeByPage_client(@RequestBody RdmTaskInfoDTO paramDTO) {
        return ((RdmTaskInfoService)this.getService()).queryRdmTaskWorkloadTimeByPage(paramDTO);
    }

    @RequestMapping(value={"/client/RdmTaskInfoService/queryRdmTaskWorkloadUserByPage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map<String, Object>> queryRdmTaskWorkloadUserByPage_client(@RequestBody RdmTaskInfoDTO paramDTO) {
        return ((RdmTaskInfoService)this.getService()).queryRdmTaskWorkloadUserByPage(paramDTO);
    }

    @RequestMapping(value={"/client/RdmTaskInfoService/batchUpdateTask"}, method={RequestMethod.POST})
    @ResponseBody
    public int batchUpdateTask(@RequestParam(value="userId") String userId, @RequestParam(value="subsId") String subsId, @RequestParam(value="projectId") String projectId, @RequestBody List<RdmTaskInfoDTO> taskUpdateList) {
        return ((RdmTaskInfoService)this.getService()).batchUpdateTask(userId, subsId, projectId, taskUpdateList);
    }

    @RequestMapping(value={"/api/rdm/task/info/fp/batch/create"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> createTaskFromFp(@RequestBody RdmTaskInfoDTO param) {
        this.setUserInfoToVO(param);
        String outputVo = ((RdmTaskInfoService)this.getService()).createTaskFromFp(param);
        return this.getResponseData(outputVo);
    }

    public static class CellItem {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private String seq;
        @ExcelProperty(value={"\u4efb\u52a1\u7f16\u53f7"})
        private String taskId;
        @ExcelProperty(value={"\u4efb\u52a1\u7c7b\u522b"})
        private String taskCategory;
        @ExcelProperty(value={"\u4efb\u52a1\u7c7b\u578b"})
        private String taskType;
        @ExcelProperty(value={"\u4efb\u52a1\u6807\u9898"})
        private String taskName;
        @ExcelProperty(value={"\u4efb\u52a1\u5185\u5bb9"})
        private String taskContent;
        @ExcelProperty(value={"\u5173\u8054\u529f\u80fd\u70b9"})
        private String fpId;
        @ExcelProperty(value={"\u8d23\u4efb\u4eba"})
        private String inchargeName;
        @ExcelProperty(value={"\u4ea7\u51fa\u7269"})
        private String taskProduce;
        @ExcelProperty(value={"\u8ba1\u5212\u5de5\u65f6"})
        private String taskEstWorkload;
        @ExcelProperty(value={"\u6267\u884c\u5de5\u65f6"})
        private String taskRealWorkload;
        @ExcelProperty(value={"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5")
        private String taskStarted;
        @ExcelProperty(value={"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5")
        private String taskDeadline;
        @ExcelProperty(value={"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4"})
        @DateTimeFormat(value="yyyy\u5e74MM\u6708dd\u65e5")
        private String taskFinished;
        @ExcelProperty(value={"\u72b6\u6001"})
        private String taskState;
        @ExcelProperty(value={"\u5907\u6ce8"})
        private String taskRemark;

        public String getTaskCategory() {
            return this.taskCategory;
        }

        public void setTaskCategory(String taskCategory) {
            this.taskCategory = taskCategory;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskContent() {
            return this.taskContent;
        }

        public void setTaskContent(String taskContent) {
            this.taskContent = taskContent;
        }

        public String getInchargeName() {
            return this.inchargeName;
        }

        public void setInchargeName(String inchargeName) {
            this.inchargeName = inchargeName;
        }

        public String getTaskProduce() {
            return this.taskProduce;
        }

        public void setTaskProduce(String taskProduce) {
            this.taskProduce = taskProduce;
        }

        public String getTaskEstWorkload() {
            return this.taskEstWorkload;
        }

        public void setTaskEstWorkload(String taskEstWorkload) {
            this.taskEstWorkload = taskEstWorkload;
        }

        public String getTaskStarted() {
            return this.taskStarted;
        }

        public void setTaskStarted(String taskStarted) {
            this.taskStarted = taskStarted;
        }

        public String getTaskDeadline() {
            return this.taskDeadline;
        }

        public void setTaskDeadline(String taskDeadline) {
            this.taskDeadline = taskDeadline;
        }

        public String getTaskFinished() {
            return this.taskFinished;
        }

        public void setTaskFinished(String taskFinished) {
            this.taskFinished = taskFinished;
        }

        public String getTaskState() {
            return this.taskState;
        }

        public void setTaskState(String taskState) {
            this.taskState = taskState;
        }

        public String getTaskRemark() {
            return this.taskRemark;
        }

        public void setTaskRemark(String taskRemark) {
            this.taskRemark = taskRemark;
        }

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTaskRealWorkload() {
            return this.taskRealWorkload;
        }

        public void setTaskRealWorkload(String taskRealWorkload) {
            this.taskRealWorkload = taskRealWorkload;
        }

        public String getFpId() {
            return this.fpId;
        }

        public void setFpId(String fpId) {
            this.fpId = fpId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }
    }

    public static class RdmTaskExcelListener
    extends AnalysisEventListener<CellItem> {
        private List<RdmTaskTmpDTO> list = new ArrayList<RdmTaskTmpDTO>();

        public List<RdmTaskTmpDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            String users;
            String[] userNames;
            RdmTaskTmpDTO vo = new RdmTaskTmpDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            if (StringUtils.isNotBlank((CharSequence)data.getTaskId())) {
                vo.setTaskId(data.getTaskId());
            } else {
                vo.setTaskId(data.getSeq());
            }
            vo.setTaskCategory(TaskCategory.codeByName((String)data.getTaskCategory()));
            vo.setTaskType(TaskType.codeByName((String)data.getTaskType()));
            vo.setTaskState(TaskState.codeByName((String)data.getTaskState()));
            if (data.getTaskEstWorkload() != null) {
                vo.setTaskEstWorkload(new BigDecimal(data.getTaskEstWorkload()));
            }
            if (data.getTaskRealWorkload() != null) {
                vo.setTaskRealWorkload(new BigDecimal(data.getTaskRealWorkload()));
            }
            if (StringUtils.isBlank((CharSequence)vo.getTaskContent())) {
                vo.setTaskContent(vo.getTaskName());
            }
            if (StringUtils.containsAny((CharSequence)vo.getInchargeName(), (CharSequence[])new CharSequence[]{"\u3001", ",", "\uff0c"}) && (userNames = StringUtils.split((String)(users = StringUtils.replaceEach((String)vo.getInchargeName(), (String[])new String[]{"\u3001", ",", "\uff0c"}, (String[])new String[]{",", ",", ","})), (String)",")) != null && userNames.length > 1) {
                vo.setInchargeName(userNames[0]);
                vo.setCollaboratorName(userNames[1]);
            }
            vo.setTaskStarted(DateUtility.parseExcelUploadDateString((String)vo.getTaskStarted(), null));
            vo.setTaskDeadline(DateUtility.parseExcelUploadDateString((String)vo.getTaskDeadline(), null));
            vo.setTaskFinished(DateUtility.parseExcelUploadDateString((String)vo.getTaskFinished(), null));
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

