/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.TestCaseInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.TestCaseInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TestCaseInfoController
extends BaseController<TestCaseInfoDTO, TestCaseInfoService> {
    @RequestMapping(value={"/api/t/c/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TestCaseInfoDTO>> queryTestCaseInfoAll(TestCaseInfoDTO dto) {
        List outputVo = ((TestCaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/info/{caseId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<TestCaseInfoDTO> queryByPk(@PathVariable(value="caseId") String caseId) {
        TestCaseInfoDTO inVo = new TestCaseInfoDTO();
        inVo.setCaseId(caseId);
        TestCaseInfoDTO outputVo = (TestCaseInfoDTO)((TestCaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody TestCaseInfoDTO inTestCaseInfoDTO) {
        int outputVo = ((TestCaseInfoService)this.getService()).deleteByPk((Object)inTestCaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody TestCaseInfoDTO inTestCaseInfoDTO) {
        this.setUserInfoToVO(inTestCaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTestCaseInfoDTO.setLastUpdateTime(now);
        inTestCaseInfoDTO.setLastUpdateUser(userId);
        int outputVo = ((TestCaseInfoService)this.getService()).updateByPk((Object)inTestCaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertTestCaseInfo(@RequestBody TestCaseInfoDTO inTestCaseInfoDTO) {
        this.setUserInfoToVO(inTestCaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTestCaseInfoDTO.setLastUpdateTime(now);
        inTestCaseInfoDTO.setLastUpdateUser(userId);
        inTestCaseInfoDTO.setCreateTime(now);
        inTestCaseInfoDTO.setCreateUser(userId);
        inTestCaseInfoDTO.setCreateUserName(this.getUserInfo().getUserName());
        if (StringUtils.isBlank((CharSequence)inTestCaseInfoDTO.getCaseId())) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            inTestCaseInfoDTO.setCaseId(seqService.nextSequence("RDM-CASE-SEQ", inTestCaseInfoDTO.getProjectId()));
        }
        int outputVo = ((TestCaseInfoService)this.getService()).insert((Object)inTestCaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryNextCaseId() {
        return this.getResponseData(UUIDUtil.getShortUUID());
    }
}

