/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.TestCaseStepService;
import com.irdstudio.allinrdm.project.console.facade.dto.TestCaseStepDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TestCaseStepController
extends BaseController<TestCaseStepDTO, TestCaseStepService> {
    @RequestMapping(value={"/api/t/c/steps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TestCaseStepDTO>> queryTestCaseStepAll(TestCaseStepDTO dto) {
        List outputVo = ((TestCaseStepService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/step/{stepId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<TestCaseStepDTO> queryByPk(@PathVariable(value="stepId") String stepId) {
        TestCaseStepDTO inVo = new TestCaseStepDTO();
        inVo.setStepId(stepId);
        TestCaseStepDTO outputVo = (TestCaseStepDTO)((TestCaseStepService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/step"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody TestCaseStepDTO inTestCaseStepDTO) {
        int outputVo = ((TestCaseStepService)this.getService()).deleteByPk((Object)inTestCaseStepDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/step"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody TestCaseStepDTO inTestCaseStepDTO) {
        this.setUserInfoToVO(inTestCaseStepDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTestCaseStepDTO.setLastUpdateTime(now);
        inTestCaseStepDTO.setLastUpdateUser(userId);
        int outputVo = ((TestCaseStepService)this.getService()).updateByPk((Object)inTestCaseStepDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/t/c/step"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertTestCaseStep(@RequestBody TestCaseStepDTO inTestCaseStepDTO) {
        this.setUserInfoToVO(inTestCaseStepDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        if (StringUtils.isNotBlank((CharSequence)inTestCaseStepDTO.getStepId())) {
            TestCaseStepDTO checkObj = (TestCaseStepDTO)((TestCaseStepService)this.getService()).queryByPk((Object)inTestCaseStepDTO);
            if (checkObj != null) {
                inTestCaseStepDTO.setLastUpdateTime(now);
                inTestCaseStepDTO.setLastUpdateUser(userId);
                int outputVo = ((TestCaseStepService)this.getService()).updateByPk((Object)inTestCaseStepDTO);
                return this.getResponseData(inTestCaseStepDTO.getStepId());
            }
            inTestCaseStepDTO.setLastUpdateTime(now);
            inTestCaseStepDTO.setLastUpdateUser(userId);
            inTestCaseStepDTO.setCreateTime(now);
            inTestCaseStepDTO.setCreateUser(userId);
            inTestCaseStepDTO.setCreateUserName(this.getUserInfo().getUserName());
            if (StringUtils.isBlank((CharSequence)inTestCaseStepDTO.getStepId())) {
                inTestCaseStepDTO.setStepId(UUIDUtil.getShortUUID());
            }
            int outputVo = ((TestCaseStepService)this.getService()).insert((Object)inTestCaseStepDTO);
            return this.getResponseData(inTestCaseStepDTO.getStepId());
        }
        inTestCaseStepDTO.setLastUpdateTime(now);
        inTestCaseStepDTO.setLastUpdateUser(userId);
        inTestCaseStepDTO.setCreateTime(now);
        inTestCaseStepDTO.setCreateUser(userId);
        inTestCaseStepDTO.setCreateUserName(this.getUserInfo().getUserName());
        if (StringUtils.isBlank((CharSequence)inTestCaseStepDTO.getStepId())) {
            inTestCaseStepDTO.setStepId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((TestCaseStepService)this.getService()).insert((Object)inTestCaseStepDTO);
        return this.getResponseData(inTestCaseStepDTO.getStepId());
    }

    @RequestMapping(value={"/client/TestCaseStepService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByCond(@RequestBody TestCaseStepDTO param) {
        return ((TestCaseStepService)this.getService()).deleteByCond(param);
    }
}

