/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.ComFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class ComFolderInfoController
extends BaseController<ComFolderInfoDTO, ComFolderInfoService> {
    @RequestMapping(value={"/api/com/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ComFolderInfoDTO>> queryComFolderInfoAll(ComFolderInfoDTO dto) {
        List outputVo = ((ComFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ComFolderInfoDTO>> queryList(ComFolderInfoDTO dto) {
        List outputVo = ((ComFolderInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<ComFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        ComFolderInfoDTO inVo = new ComFolderInfoDTO();
        inVo.setFolderId(folderId);
        ComFolderInfoDTO outputVo = (ComFolderInfoDTO)((ComFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ComFolderInfoDTO inComFolderInfoDTO) {
        int outputVo = ((ComFolderInfoService)this.getService()).deleteByPk((Object)inComFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ComFolderInfoDTO inComFolderInfoDTO) {
        this.setUserInfoToVO(inComFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inComFolderInfoDTO.setLastModifyUser(userId);
        inComFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((ComFolderInfoService)this.getService()).updateByPk((Object)inComFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertComFolderInfo(@RequestBody ComFolderInfoDTO inComFolderInfoDTO) {
        this.setUserInfoToVO(inComFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inComFolderInfoDTO.setCreateUser(userId);
        inComFolderInfoDTO.setCreateTime(now);
        inComFolderInfoDTO.setLastModifyUser(userId);
        inComFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inComFolderInfoDTO.getFolderId())) {
            inComFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((ComFolderInfoService)this.getService()).insert((Object)inComFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/com/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody ComFolderInfoDTO paramDTO, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((ComFolderInfoService)this.getService()).folderMerge(paramDTO, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/com/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody ComFolderInfoDTO paramDTO) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((ComFolderInfoService)this.getService()).folderMove(paramDTO);
        return this.getResponseData(outputVo);
    }
}

