/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.StdTaskDetailService;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdTaskDetailDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class StdTaskDetailController
extends BaseController<StdTaskDetailDTO, StdTaskDetailService> {
    @RequestMapping(value={"/api/std/task/details"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<StdTaskDetailDTO>> queryStdTaskDetailAll(StdTaskDetailDTO dto) {
        List outputVo = ((StdTaskDetailService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/task/detail/{taskDetailId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<StdTaskDetailDTO> queryByPk(@PathVariable(value="taskDetailId") String taskDetailId) {
        StdTaskDetailDTO inVo = new StdTaskDetailDTO();
        inVo.setTaskDetailId(taskDetailId);
        StdTaskDetailDTO outputVo = (StdTaskDetailDTO)((StdTaskDetailService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/task/detail"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody StdTaskDetailDTO inStdTaskDetailDTO) {
        int outputVo = ((StdTaskDetailService)this.getService()).deleteByPk((Object)inStdTaskDetailDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/task/detail"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody StdTaskDetailDTO inStdTaskDetailDTO) {
        this.setUserInfoToVO(inStdTaskDetailDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdTaskDetailDTO.setLastModifyUser(userId);
        inStdTaskDetailDTO.setLastModifyTime(now);
        int outputVo = ((StdTaskDetailService)this.getService()).updateByPk((Object)inStdTaskDetailDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/task/detail"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertStdTaskDetail(@RequestBody StdTaskDetailDTO inStdTaskDetailDTO) {
        this.setUserInfoToVO(inStdTaskDetailDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdTaskDetailDTO.setCreateUser(userId);
        inStdTaskDetailDTO.setCreateTime(now);
        inStdTaskDetailDTO.setLastModifyUser(userId);
        inStdTaskDetailDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inStdTaskDetailDTO.getTaskDetailId())) {
            inStdTaskDetailDTO.setTaskDetailId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((StdTaskDetailService)this.getService()).insert((Object)inStdTaskDetailDTO);
        return this.getResponseData(outputVo);
    }
}

